/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.editor.outline.impl;

import com.google.inject.Inject;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.xtext.ui.editor.IURIEditorOpener;
import org.eclipse.xtext.ui.editor.outline.IOutlineNode;
import org.eclipse.xtext.util.ITextRegion;
import org.eclipse.xtext.util.concurrent.IUnitOfWork;

public class OutlineNodeElementOpener {
    @Inject
    private IURIEditorOpener uriEditorOpener;

    public void open(IOutlineNode node, ISourceViewer textViewer) {
        if (node != null) {
            ITextRegion textRegion = node.getSignificantTextRegion();
            if (textRegion != null && textRegion != ITextRegion.EMPTY_REGION) {
                int offset = textRegion.getOffset();
                int length = textRegion.getLength();
                textViewer.setRangeIndication(offset, length, true);
                textViewer.revealRange(offset, length);
                textViewer.setSelectedRange(offset, length);
            } else {
                node.readOnly((IUnitOfWork)new IUnitOfWork.Void<EObject>(){

                    public void process(EObject state) throws Exception {
                        OutlineNodeElementOpener.this.openEObject(state);
                    }
                });
            }
        }
    }

    protected void openEObject(EObject state) {
        URI uri = EcoreUtil.getURI((EObject)state);
        this.uriEditorOpener.open(uri, true);
    }
}

