/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.typesystem.references;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.xtext.common.types.JvmAnyTypeReference;
import org.eclipse.xtext.common.types.JvmArrayType;
import org.eclipse.xtext.common.types.JvmComponentType;
import org.eclipse.xtext.common.types.JvmCompoundTypeReference;
import org.eclipse.xtext.common.types.JvmGenericArrayTypeReference;
import org.eclipse.xtext.common.types.JvmMultiTypeReference;
import org.eclipse.xtext.common.types.JvmParameterizedTypeReference;
import org.eclipse.xtext.common.types.JvmSynonymTypeReference;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeConstraint;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.JvmUnknownTypeReference;
import org.eclipse.xtext.common.types.JvmUpperBound;
import org.eclipse.xtext.common.types.JvmWildcardTypeReference;
import org.eclipse.xtext.common.types.TypesPackage;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.xbase.typesystem.references.AnyTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.ArrayTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.CompoundTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.FunctionTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.ITypeReferenceOwner;
import org.eclipse.xtext.xbase.typesystem.references.LightweightTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.ParameterizedTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.UnboundTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.UnboundTypeReferenceResolver;
import org.eclipse.xtext.xbase.typesystem.references.UnknownTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.WildcardTypeReference;
import org.eclipse.xtext.xbase.typing.IJvmTypeReferenceProvider;
import org.eclipse.xtext.xtype.XComputedTypeReference;
import org.eclipse.xtext.xtype.XFunctionTypeRef;
import org.eclipse.xtext.xtype.util.AbstractXtypeReferenceVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OwnedConverter
extends AbstractXtypeReferenceVisitor<LightweightTypeReference>
implements Function<JvmTypeReference, LightweightTypeReference> {
    private final ITypeReferenceOwner owner;
    private final boolean keepUnboundWildcards;

    public OwnedConverter(ITypeReferenceOwner owner) {
        this(owner, false);
    }

    public OwnedConverter(ITypeReferenceOwner owner, boolean keepUnboundWildcards) {
        this.keepUnboundWildcards = keepUnboundWildcards;
        this.owner = (ITypeReferenceOwner)Preconditions.checkNotNull((Object)owner, (Object)"owner");
    }

    public ITypeReferenceOwner getOwner() {
        return this.owner;
    }

    public LightweightTypeReference toLightweightReference(JvmTypeReference reference) {
        return (LightweightTypeReference)this.visit(reference);
    }

    public LightweightTypeReference toRawLightweightReference(JvmType type) {
        if (type instanceof JvmArrayType) {
            JvmComponentType componentType = ((JvmArrayType)type).getComponentType();
            LightweightTypeReference componentTypeReference = this.toRawLightweightReference((JvmType)componentType);
            return new ArrayTypeReference(this.getOwner(), componentTypeReference);
        }
        return new ParameterizedTypeReference(this.getOwner(), type);
    }

    public LightweightTypeReference apply(JvmTypeReference reference) {
        return this.toLightweightReference(reference);
    }

    public LightweightTypeReference doVisitAnyTypeReference(JvmAnyTypeReference reference) {
        return new AnyTypeReference(this.owner);
    }

    public LightweightTypeReference doVisitGenericArrayTypeReference(JvmGenericArrayTypeReference reference) {
        JvmTypeReference originalComponentType = reference.getComponentType();
        LightweightTypeReference lightweightComponentType = null;
        if (originalComponentType != null) {
            lightweightComponentType = (LightweightTypeReference)this.visit(originalComponentType);
            if (lightweightComponentType.isAny() || lightweightComponentType.isUnknown()) {
                return lightweightComponentType;
            }
        } else {
            lightweightComponentType = this.getObjectReference();
        }
        return new ArrayTypeReference(this.owner, lightweightComponentType);
    }

    public LightweightTypeReference doVisitMultiTypeReference(JvmMultiTypeReference reference) {
        return this.doVisitCompoundReference((JvmCompoundTypeReference)reference, false);
    }

    protected LightweightTypeReference doVisitCompoundReference(JvmCompoundTypeReference reference, boolean synonym) {
        CompoundTypeReference result = new CompoundTypeReference(this.owner, synonym);
        for (JvmTypeReference component : reference.getReferences()) {
            result.addComponent((LightweightTypeReference)this.visit(component));
        }
        return result;
    }

    @Override
    public LightweightTypeReference doVisitComputedTypeReference(XComputedTypeReference reference) {
        IJvmTypeReferenceProvider typeProvider = reference.getTypeProvider();
        if (typeProvider instanceof UnboundTypeReferenceResolver) {
            UnboundTypeReference typeReference = ((UnboundTypeReferenceResolver)typeProvider).getUnboundTypeReference();
            return typeReference.copyInto(this.owner);
        }
        JvmTypeReference equivalent = reference.getEquivalent();
        if (equivalent == null) {
            return new UnknownTypeReference(this.owner);
        }
        return (LightweightTypeReference)super.doVisitComputedTypeReference(reference);
    }

    public LightweightTypeReference doVisitParameterizedTypeReference(JvmParameterizedTypeReference reference) {
        JvmType type = this.getType((JvmTypeReference)reference);
        if (type == null || type.eIsProxy()) {
            String name;
            Set<EObject> sourceElements;
            EObject firstSource;
            List nodes = NodeModelUtils.findNodesForFeature((EObject)reference, (EStructuralFeature)TypesPackage.Literals.JVM_PARAMETERIZED_TYPE_REFERENCE__TYPE);
            if (nodes.isEmpty() && (firstSource = (EObject)Iterables.getFirst(sourceElements = this.owner.getServices().getJvmModelAssociations().getSourceElements((EObject)reference), null)) instanceof JvmParameterizedTypeReference) {
                nodes = NodeModelUtils.findNodesForFeature((EObject)firstSource, (EStructuralFeature)TypesPackage.Literals.JVM_PARAMETERIZED_TYPE_REFERENCE__TYPE);
            }
            if (nodes.size() == 1 && (name = ((INode)nodes.get(0)).getText().trim()) != null && name.length() != 0) {
                String shortName;
                int lastDollar;
                int lastDot = name.lastIndexOf(46);
                int lastDotOrDollar = Math.max(lastDot, lastDollar = name.lastIndexOf(36));
                if (lastDotOrDollar != -1 && lastDotOrDollar != name.length() - 1 && (shortName = name.substring(lastDotOrDollar + 1)).length() != 0) {
                    name = shortName;
                }
                return new UnknownTypeReference(this.owner, name);
            }
            return new UnknownTypeReference(this.owner);
        }
        ParameterizedTypeReference result = new ParameterizedTypeReference(this.owner, type);
        for (JvmTypeReference argument : reference.getArguments()) {
            result.addTypeArgument(((LightweightTypeReference)this.visit(argument)).getWrapperTypeIfPrimitive());
        }
        return result;
    }

    protected JvmType getType(JvmTypeReference reference) {
        return reference.getType();
    }

    public LightweightTypeReference doVisitSynonymTypeReference(JvmSynonymTypeReference reference) {
        return this.doVisitCompoundReference((JvmCompoundTypeReference)reference, true);
    }

    public LightweightTypeReference doVisitWildcardTypeReference(JvmWildcardTypeReference reference) {
        ParameterizedTypeReference upperBound;
        WildcardTypeReference result = new WildcardTypeReference(this.owner);
        boolean upperBoundSeen = false;
        for (JvmTypeConstraint constraint : reference.getConstraints()) {
            if (constraint.getTypeReference() == null) continue;
            if (constraint instanceof JvmUpperBound) {
                upperBoundSeen = true;
                result.addUpperBound(((LightweightTypeReference)this.visit(constraint.getTypeReference())).getWrapperTypeIfPrimitive());
                continue;
            }
            result.setLowerBound(((LightweightTypeReference)this.visit(constraint.getTypeReference())).getWrapperTypeIfPrimitive());
        }
        if (!this.keepUnboundWildcards) {
            if (!upperBoundSeen) {
                upperBound = this.getObjectReference();
                result.addUpperBound(upperBound);
            }
            if (result.getUpperBounds().isEmpty()) {
                throw new IllegalStateException("UpperBounds may not be empty");
            }
        } else if (!upperBoundSeen && result.getLowerBound() != null) {
            upperBound = this.getObjectReference();
            result.addUpperBound(upperBound);
        }
        return result;
    }

    @Override
    public LightweightTypeReference doVisitFunctionTypeReference(XFunctionTypeRef reference) {
        FunctionTypeReference result = new FunctionTypeReference(this.owner, reference.getType());
        JvmTypeReference equivalent = reference.getEquivalent();
        if (equivalent instanceof JvmParameterizedTypeReference) {
            for (JvmTypeReference argument : ((JvmParameterizedTypeReference)equivalent).getArguments()) {
                result.addTypeArgument((LightweightTypeReference)this.visit(argument));
            }
        }
        for (JvmTypeReference parameter : reference.getParamTypes()) {
            result.addParameterType((LightweightTypeReference)this.visit(parameter));
        }
        if (reference.getReturnType() != null) {
            result.setReturnType((LightweightTypeReference)this.visit(reference.getReturnType()));
        }
        return result;
    }

    public LightweightTypeReference doVisitUnknownTypeReference(JvmUnknownTypeReference reference) {
        if (reference.eIsSet((EStructuralFeature)TypesPackage.Literals.JVM_UNKNOWN_TYPE_REFERENCE__QUALIFIED_NAME)) {
            return new UnknownTypeReference(this.getOwner(), reference.getQualifiedName());
        }
        return new UnknownTypeReference(this.getOwner());
    }

    protected LightweightTypeReference handleNullReference() {
        return new UnknownTypeReference(this.getOwner());
    }

    protected ParameterizedTypeReference getObjectReference() {
        JvmType objectType = this.owner.getServices().getTypeReferences().findDeclaredType(Object.class, (Notifier)this.getOwner().getContextResourceSet());
        ParameterizedTypeReference result = new ParameterizedTypeReference(this.owner, objectType);
        return result;
    }

    public LightweightTypeReference doVisitTypeReference(JvmTypeReference reference) {
        throw new IllegalStateException("Did not expect: " + reference);
    }
}

