/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.editor.contentassist;

import com.google.inject.ImplementedBy;
import com.google.inject.Inject;
import com.google.inject.name.Named;
import java.util.List;
import org.eclipse.xtext.ui.editor.contentassist.PrefixMatcher;
import org.eclipse.xtext.util.Strings;

public class FQNPrefixMatcher
extends PrefixMatcher {
    @Inject
    private PrefixMatcher.IgnoreCase delegate;
    @Inject(optional=true)
    @Named(value="org.eclipse.xtext.ui.editor.contentassist.FQNPrefixMatcher.delimiter")
    private char delimiter = (char)46;
    @Inject
    private LastSegmentFinder lastSegmentFinder;

    public boolean isCandidateMatchingPrefix(String name, String prefix) {
        if (this.delegate.isCandidateMatchingPrefix(name, prefix)) {
            return true;
        }
        if (name.indexOf(this.delimiter) >= 0) {
            if (prefix.indexOf(this.delimiter) < 0) {
                String lastSegment = this.lastSegmentFinder.getLastSegment(name, this.delimiter);
                if (lastSegment != null && this.delegate.isCandidateMatchingPrefix(lastSegment, prefix)) {
                    return true;
                }
            } else {
                List splitPrefix = Strings.split((String)prefix, (char)'.');
                if (splitPrefix.isEmpty()) {
                    return false;
                }
                List splitName = Strings.split((String)name, (char)'.');
                if (splitName.size() < splitPrefix.size()) {
                    return false;
                }
                int i = 0;
                while (i < splitPrefix.size()) {
                    if (!this.delegate.isCandidateMatchingPrefix((String)splitName.get(i), (String)splitPrefix.get(i))) {
                        return false;
                    }
                    ++i;
                }
                return true;
            }
        }
        return false;
    }

    public void setDelimiter(char delimiter) {
        this.delimiter = delimiter;
    }

    public char getDelimiter() {
        return this.delimiter;
    }

    public void setDelegate(PrefixMatcher.IgnoreCase delegate) {
        this.delegate = delegate;
    }

    public PrefixMatcher.IgnoreCase getDelegate() {
        return this.delegate;
    }

    public void setLastSegmentFinder(LastSegmentFinder lastSegmentFinder) {
        this.lastSegmentFinder = lastSegmentFinder;
    }

    public LastSegmentFinder getLastSegmentFinder() {
        return this.lastSegmentFinder;
    }

    public static class DefaultLastSegmentFinder
    implements LastSegmentFinder {
        public String getLastSegment(String fqn, char delimiter) {
            if (fqn == null || fqn.length() == 0) {
                return null;
            }
            boolean lookForUppercase = true;
            int lastDelimiterIndex = -1;
            int i = 0;
            while (i < fqn.length()) {
                if (lookForUppercase && Character.isUpperCase(fqn.charAt(i))) {
                    return fqn.substring(i);
                }
                boolean bl = lookForUppercase = delimiter == fqn.charAt(i);
                if (lookForUppercase) {
                    lastDelimiterIndex = i;
                }
                ++i;
            }
            if (lastDelimiterIndex >= 0 && lastDelimiterIndex < fqn.length() - 1) {
                return fqn.substring(lastDelimiterIndex + 1);
            }
            return null;
        }
    }

    @ImplementedBy(value=DefaultLastSegmentFinder.class)
    public static interface LastSegmentFinder {
        public String getLastSegment(String var1, char var2);
    }
}

