/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.editor.validation;

import java.util.Map;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationPresentation;
import org.eclipse.jface.text.source.ImageUtilities;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.texteditor.AnnotationPreference;
import org.eclipse.ui.texteditor.AnnotationPreferenceLookup;
import org.eclipse.xtext.ui.editor.model.IXtextDocument;
import org.eclipse.xtext.ui.internal.XtextPluginImages;
import org.eclipse.xtext.validation.Issue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XtextAnnotation
extends Annotation
implements IAnnotationPresentation {
    private final IXtextDocument document;
    private final Issue issue;
    private final int layer;
    private final boolean isQuickfixable;
    private final AnnotationPreferenceLookup lookup = EditorsUI.getAnnotationPreferenceLookup();

    public String getIssueCode() {
        return this.issue.getCode();
    }

    public String[] getIssueData() {
        return this.issue.getData();
    }

    public IXtextDocument getDocument() {
        return this.document;
    }

    public URI getUriToProblem() {
        return this.issue.getUriToProblem();
    }

    public Issue getIssue() {
        return this.issue;
    }

    public boolean isQuickFixable() {
        return this.isQuickfixable;
    }

    public XtextAnnotation(String type, boolean isPersistent, IXtextDocument document, Issue issue, boolean isQuickfixable) {
        super(type, isPersistent, issue.getMessage());
        AnnotationPreference preference = this.lookup.getAnnotationPreference((Annotation)this);
        this.layer = preference != null ? preference.getPresentationLayer() + 1 : 1;
        this.document = document;
        this.issue = issue;
        this.isQuickfixable = isQuickfixable;
    }

    public int getLayer() {
        return this.layer;
    }

    public void paint(GC gc, Canvas canvas, Rectangle bounds) {
        Image image = this.getImages().get(this.getType());
        if (image != null) {
            ImageUtilities.drawImage((Image)image, (GC)gc, (Canvas)canvas, (Rectangle)bounds, (int)0x1000000, (int)128);
        }
    }

    private Map<String, Image> getImages() {
        return this.isQuickfixable ? XtextPluginImages.getAnnotationImagesFixable() : XtextPluginImages.getAnnotationImagesNonfixable();
    }
}

