/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.refactoring.impl;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtext.ui.refactoring.IRenameStrategy;
import org.eclipse.xtext.ui.refactoring.IRenamedElementTracker;
import org.eclipse.xtext.ui.refactoring.impl.RefactoringException;
import org.eclipse.xtext.util.Strings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RenamedElementTracker
implements IRenamedElementTracker {
    @Override
    public Map<URI, URI> renameAndTrack(Iterable<URI> renamedElementURIs, String newName, ResourceSet resourceSet, IRenameStrategy renameStrategy, IProgressMonitor monitor) {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor).setWorkRemaining(3);
        Map<EObject, URI> renamedElement2oldURI = this.resolveRenamedElements(renamedElementURIs, resourceSet);
        progress.worked(1);
        renameStrategy.applyDeclarationChange(newName, resourceSet);
        progress.worked(1);
        Map<URI, URI> old2newURI = this.relocateRenamedElements(renamedElement2oldURI);
        progress.worked(1);
        renameStrategy.revertDeclarationChange(resourceSet);
        return old2newURI;
    }

    protected Map<EObject, URI> resolveRenamedElements(Iterable<URI> renamedElementURIs, ResourceSet resourceSet) {
        HashMap renamedElement2oldURI = Maps.newHashMap();
        for (URI renamedElementURI : renamedElementURIs) {
            EObject renamedElement = resourceSet.getEObject(renamedElementURI, true);
            if (renamedElement == null) {
                throw new RefactoringException("Cannot resolve dependent element " + Strings.notNull((Object)renamedElementURI));
            }
            renamedElement2oldURI.put(renamedElement, renamedElementURI);
        }
        return renamedElement2oldURI;
    }

    protected Map<URI, URI> relocateRenamedElements(Map<EObject, URI> renamedElement2oldURI) {
        HashMap old2newURI = Maps.newHashMap();
        for (Map.Entry<EObject, URI> entry : renamedElement2oldURI.entrySet()) {
            URI newURI = EcoreUtil.getURI((EObject)entry.getKey());
            old2newURI.put(entry.getValue(), newURI);
        }
        return old2newURI;
    }
}

