/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.commons.sdk.util.junit5.extension;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.concurrent.TimeoutException;
import org.junit.jupiter.api.extension.AfterTestExecutionCallback;
import org.junit.jupiter.api.extension.BeforeTestExecutionCallback;
import org.junit.jupiter.api.extension.ExtensionContext;

public class TestMethodWrapper
implements BeforeTestExecutionCallback,
AfterTestExecutionCallback {
    public void beforeTestExecution(ExtensionContext context) throws Exception {
        Object testInstance = context.getRequiredTestInstance();
        String fixtureInfo = "";
        try {
            Class<?> clazz = testInstance.getClass();
            Field fixtureField = null;
            while (clazz != null) {
                try {
                    fixtureField = clazz.getDeclaredField("fixture");
                    break;
                }
                catch (NoSuchFieldException e) {
                    clazz = clazz.getSuperclass();
                }
            }
            if (fixtureField != null) {
                fixtureField.setAccessible(true);
                Object fixture = fixtureField.get(testInstance);
                if (fixture != null) {
                    try {
                        Method getInfo = fixture.getClass().getMethod("getInfo", new Class[0]);
                        Object info = getInfo.invoke(fixture, new Object[0]);
                        fixtureInfo = String.valueOf(info);
                    }
                    catch (Exception exception) {}
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        System.err.println("Running " + TestMethodWrapper.qualifiedTestName(context) + (String)(fixtureInfo.isEmpty() ? "" : "@" + fixtureInfo));
    }

    private static String qualifiedTestName(ExtensionContext context) {
        return ((Class)context.getTestClass().get()).getSimpleName() + "." + ((Method)context.getTestMethod().get()).getName();
    }

    public void afterTestExecution(ExtensionContext context) throws Exception {
        context.getExecutionException().ifPresent(ex -> {
            if (ex instanceof TimeoutException) {
                System.err.println("\n=== THREAD DUMP ===");
                for (Thread t : Thread.getAllStackTraces().keySet()) {
                    System.err.println("Thread: " + t.getName());
                    StackTraceElement[] stackTraceElementArray = t.getStackTrace();
                    int n = stackTraceElementArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        StackTraceElement ste = stackTraceElementArray[n2];
                        System.err.println("\tat " + String.valueOf(ste));
                        ++n2;
                    }
                }
                System.err.println("=== END THREAD DUMP ===\n");
            }
        });
    }
}

