/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.tasks.tests.data;

import java.util.Collections;
import java.util.Set;
import junit.framework.TestCase;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.mylyn.internal.tasks.core.RepositoryModel;
import org.eclipse.mylyn.internal.tasks.core.TaskList;
import org.eclipse.mylyn.internal.tasks.core.TaskRepositoryManager;
import org.eclipse.mylyn.internal.tasks.core.TaskTask;
import org.eclipse.mylyn.internal.tasks.core.data.SynchronizationManger;
import org.eclipse.mylyn.internal.tasks.core.data.TaskAttributeDiff;
import org.eclipse.mylyn.internal.tasks.core.data.TaskDataDiff;
import org.eclipse.mylyn.tasks.core.IRepositoryManager;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.core.ITaskComment;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.core.data.TaskAttribute;
import org.eclipse.mylyn.tasks.core.data.TaskAttributeMapper;
import org.eclipse.mylyn.tasks.core.data.TaskData;
import org.junit.Test;

public class SynchronizationMangerTest
extends TestCase {
    private SynchronizationManger manager;
    private RepositoryModel model;
    private TaskRepository repository;
    private TaskAttributeMapper mapper;
    private TaskData newData;
    private TaskData oldData;

    protected void setUp() throws Exception {
        TaskTask task = new TaskTask("kind", "url", "1");
        this.repository = new TaskRepository(task.getConnectorKind(), task.getRepositoryUrl());
        this.mapper = new TaskAttributeMapper(this.repository);
        TaskRepositoryManager repositoryManager = new TaskRepositoryManager();
        repositoryManager.addRepository(this.repository);
        TaskList taskList = new TaskList();
        taskList.addTask((ITask)task);
        this.model = new RepositoryModel(taskList, (IRepositoryManager)repositoryManager);
        this.newData = new TaskData(this.mapper, this.repository.getConnectorKind(), this.repository.getUrl(), "1");
        this.oldData = new TaskData(this.mapper, this.repository.getConnectorKind(), this.repository.getUrl(), "1");
        this.manager = new SynchronizationManger(this.model);
    }

    @Test
    public void testHasChangedAttributes() {
        TaskDataDiff diff = this.manager.createDiff(this.newData, this.oldData, (IProgressMonitor)new NullProgressMonitor());
        SynchronizationMangerTest.assertFalse((boolean)diff.hasChanged());
    }

    @Test
    public void testHasChangedAttributesWithoutKind() {
        TaskAttribute attributeCustom = this.newData.getRoot().createAttribute("custom");
        attributeCustom.setValue("1");
        TaskDataDiff diff = this.manager.createDiff(this.newData, this.oldData, (IProgressMonitor)new NullProgressMonitor());
        SynchronizationMangerTest.assertFalse((boolean)diff.hasChanged());
    }

    @Test
    public void testHasChangedAttributesWithKind() {
        TaskAttribute attributeCustom = this.newData.getRoot().createAttribute("custom");
        attributeCustom.setValue("1");
        attributeCustom.getMetaData().setKind("kind");
        TaskDataDiff diff = this.manager.createDiff(this.newData, this.oldData, (IProgressMonitor)new NullProgressMonitor());
        SynchronizationMangerTest.assertTrue((boolean)diff.hasChanged());
    }

    @Test
    public void testHasChangedAttributesWithChangedValues() {
        TaskAttribute attributeOld = this.oldData.getRoot().createAttribute("task.common.summary");
        attributeOld.setValue("1");
        TaskAttribute attributeNew = this.newData.getRoot().createAttribute("task.common.summary");
        attributeNew.setValue("2");
        TaskDataDiff diff = this.manager.createDiff(this.newData, this.oldData, (IProgressMonitor)new NullProgressMonitor());
        SynchronizationMangerTest.assertTrue((boolean)diff.hasChanged());
    }

    @Test
    public void testHasChangedAttributesWithChangedCustomValues() {
        TaskAttribute attributeOld = this.oldData.getRoot().createAttribute("custom");
        attributeOld.setValue("1");
        attributeOld.getMetaData().setKind("kind");
        TaskAttribute attributeNew = this.newData.getRoot().createAttribute("custom");
        attributeNew.setValue("2");
        attributeNew.getMetaData().setKind("kind");
        TaskDataDiff diff = this.manager.createDiff(this.newData, this.oldData, (IProgressMonitor)new NullProgressMonitor());
        SynchronizationMangerTest.assertTrue((boolean)diff.hasChanged());
    }

    @Test
    public void testHasChangedAttributesWithUnchangedCustomValues() {
        TaskAttribute attributeOld = this.oldData.getRoot().createAttribute("custom");
        attributeOld.setValue("1");
        attributeOld.getMetaData().setKind("kind");
        TaskAttribute attributeNew = this.newData.getRoot().createAttribute("custom");
        attributeNew.setValue("1");
        attributeNew.getMetaData().setKind("kind");
        TaskDataDiff diff = this.manager.createDiff(this.newData, this.oldData, (IProgressMonitor)new NullProgressMonitor());
        SynchronizationMangerTest.assertFalse((boolean)diff.hasChanged());
    }

    @Test
    public void testHasChangedAttributesMultiple() {
        TaskAttribute attributeCustom = this.newData.getRoot().createAttribute("custom");
        attributeCustom.setValue("1");
        TaskAttribute attributeSummary = this.newData.getRoot().createAttribute("task.common.summary");
        attributeSummary.setValue("1");
        TaskDataDiff diff = this.manager.createDiff(this.newData, this.oldData, (IProgressMonitor)new NullProgressMonitor());
        SynchronizationMangerTest.assertTrue((boolean)diff.hasChanged());
    }

    @Test
    public void testHasChangedAttributesWithComments() {
        TaskAttribute attributeComment = this.newData.getRoot().createAttribute("custom");
        attributeComment.setValue("1");
        attributeComment.getMetaData().setType("comment");
        TaskDataDiff diff = this.manager.createDiff(this.newData, this.oldData, (IProgressMonitor)new NullProgressMonitor());
        SynchronizationMangerTest.assertTrue((boolean)diff.hasChanged());
    }

    @Test
    public void testGetChangedAttributesWithComments() {
        TaskAttribute attributeComment = this.newData.getRoot().createAttribute("custom");
        attributeComment.setValue("1");
        attributeComment.getMetaData().setType("comment");
        TaskDataDiff diff = this.manager.createDiff(this.newData, this.oldData, (IProgressMonitor)new NullProgressMonitor());
        SynchronizationMangerTest.assertEquals((int)1, (int)diff.getNewComments().size());
        SynchronizationMangerTest.assertEquals((Object)attributeComment, (Object)((ITaskComment)diff.getNewComments().iterator().next()).getTaskAttribute());
    }

    @Test
    public void testHasChangedAttributesWithAttachments() {
        TaskAttribute attributeAttachment = this.newData.getRoot().createAttribute("custom");
        attributeAttachment.setValue("1");
        attributeAttachment.getMetaData().setType("attachment");
        TaskDataDiff diff = this.manager.createDiff(this.newData, this.oldData, (IProgressMonitor)new NullProgressMonitor());
        SynchronizationMangerTest.assertTrue((boolean)diff.hasChanged());
    }

    @Test
    public void testGetChangedAttributesWithAttachments() {
        TaskAttribute attributeAttachment = this.newData.getRoot().createAttribute("custom");
        attributeAttachment.setValue("1");
        attributeAttachment.getMetaData().setType("attachment");
        TaskDataDiff diff = this.manager.createDiff(this.newData, this.oldData, (IProgressMonitor)new NullProgressMonitor());
        SynchronizationMangerTest.assertEquals(Collections.singleton(attributeAttachment), (Object)diff.getNewAttachments());
    }

    @Test
    public void testGetChangedAttributesMultipleKind() {
        TaskAttribute attributeCustom = this.newData.getRoot().createAttribute("custom");
        attributeCustom.setValue("1");
        attributeCustom.getMetaData().setKind("kind");
        TaskAttribute attributeSummary = this.newData.getRoot().createAttribute("task.common.summary");
        attributeSummary.setValue("1");
        TaskDataDiff diff = this.manager.createDiff(this.newData, this.oldData, (IProgressMonitor)new NullProgressMonitor());
        SynchronizationMangerTest.assertEquals(Set.of(new TaskAttributeDiff(null, attributeSummary), new TaskAttributeDiff(null, attributeCustom)), (Object)diff.getChangedAttributes());
        SynchronizationMangerTest.assertTrue((boolean)diff.hasChanged());
    }

    @Test
    public void testHasChangedAttributesSummaryEmptyValue() {
        this.newData.getRoot().createAttribute("task.common.summary");
        TaskDataDiff diff = this.manager.createDiff(this.newData, this.oldData, (IProgressMonitor)new NullProgressMonitor());
        SynchronizationMangerTest.assertFalse((boolean)diff.hasChanged());
    }
}

