/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.opal.propertytable.snippets;

import java.util.Date;
import java.util.Locale;
import java.util.Map;
import org.eclipse.nebula.widgets.opal.commons.SWTGraphicUtil;
import org.eclipse.nebula.widgets.opal.propertytable.PTProperty;
import org.eclipse.nebula.widgets.opal.propertytable.PropertyTable;
import org.eclipse.nebula.widgets.opal.propertytable.editor.PTCheckboxEditor;
import org.eclipse.nebula.widgets.opal.propertytable.editor.PTColorEditor;
import org.eclipse.nebula.widgets.opal.propertytable.editor.PTComboEditor;
import org.eclipse.nebula.widgets.opal.propertytable.editor.PTDateEditor;
import org.eclipse.nebula.widgets.opal.propertytable.editor.PTDimensionEditor;
import org.eclipse.nebula.widgets.opal.propertytable.editor.PTDirectoryEditor;
import org.eclipse.nebula.widgets.opal.propertytable.editor.PTEditor;
import org.eclipse.nebula.widgets.opal.propertytable.editor.PTFileEditor;
import org.eclipse.nebula.widgets.opal.propertytable.editor.PTFloatEditor;
import org.eclipse.nebula.widgets.opal.propertytable.editor.PTFontEditor;
import org.eclipse.nebula.widgets.opal.propertytable.editor.PTInsetsEditor;
import org.eclipse.nebula.widgets.opal.propertytable.editor.PTIntegerEditor;
import org.eclipse.nebula.widgets.opal.propertytable.editor.PTPasswordEditor;
import org.eclipse.nebula.widgets.opal.propertytable.editor.PTRectangleEditor;
import org.eclipse.nebula.widgets.opal.propertytable.editor.PTSpinnerEditor;
import org.eclipse.nebula.widgets.opal.propertytable.editor.PTURLEditor;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class PropertyTableSnippetRefresh {
    public static void main(String[] args) {
        Locale.setDefault(Locale.ENGLISH);
        Display display = new Display();
        Shell shell = new Shell(display);
        shell.setText("PropertyTable snippet");
        shell.setLayout((Layout)new GridLayout(2, true));
        Button button1 = new Button((Composite)shell, 8);
        button1.setText("First set of values");
        button1.setLayoutData((Object)new GridData(3, 2, false, false));
        Button button2 = new Button((Composite)shell, 8);
        button2.setText("Second set of values");
        button2.setLayoutData((Object)new GridData(1, 2, false, false));
        PropertyTable table = PropertyTableSnippetRefresh.buildPropertyTable((Composite)shell);
        table.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        button1.addListener(13, event -> {
            Map map = table.getProperties();
            map.put("id", "My id");
            map.put("text", "blahblah...");
            map.put("url", "http://www.google.com");
            map.put("password", "password");
            map.put("int", "123");
            map.put("float", "123.45");
            map.put("spinner", null);
            map.put("directory", null);
            map.put("file", null);
            map.put("comboReadOnly", null);
            map.put("combo", null);
            map.put("cb", Boolean.FALSE);
            map.put("color", null);
            map.put("font", null);
            map.put("dimension", null);
            map.put("rectangle", null);
            map.put("inset", null);
            map.put("date", null);
            table.setProperties(map);
        });
        button2.addListener(13, event -> {
            Map map = table.getProperties();
            map.put("id", "(2)My id");
            map.put("text", "(2)blahblah...");
            map.put("url", "(2)http://www.google.com");
            map.put("password", "(2)password");
            map.put("int", "1234");
            map.put("float", "1234.56");
            map.put("spinner", 12);
            map.put("directory", "C:/temp");
            map.put("file", "C:/temp/temp.txt");
            map.put("comboReadOnly", "Summer");
            map.put("combo", "Value 2");
            map.put("cb", Boolean.TRUE);
            map.put("color", null);
            map.put("font", null);
            map.put("dimension", null);
            map.put("rectangle", null);
            map.put("inset", null);
            map.put("date", new Date());
            table.setProperties(map);
        });
        shell.setSize(800, 600);
        shell.open();
        SWTGraphicUtil.centerShell((Shell)shell);
        while (!shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        display.dispose();
    }

    private static PropertyTable buildPropertyTable(Composite composite) {
        PropertyTable table = new PropertyTable(composite, 0);
        table.showButtons();
        table.viewAsCategories();
        table.showDescription();
        table.addProperty(new PTProperty("id", "Identifier", "Description for identifier", (Object)"My id")).setCategory("General");
        table.addProperty(new PTProperty("text", "Description", "Description for the description field", (Object)"blahblah...")).setCategory("General");
        table.addProperty(new PTProperty("url", "URL:", "This is a nice <b>URL</b>", (Object)"http://www.google.com").setCategory("General")).setEditor((PTEditor)new PTURLEditor());
        table.addProperty(new PTProperty("password", "Password", "Enter your <i>password</i> and keep it secret...", (Object)"password")).setCategory("General").setEditor((PTEditor)new PTPasswordEditor());
        table.addProperty(new PTProperty("int", "An integer", "Type any integer", (Object)"123")).setCategory("Number").setEditor((PTEditor)new PTIntegerEditor());
        table.addProperty(new PTProperty("float", "A float", "Type any float", (Object)"123.45")).setCategory("Number").setEditor((PTEditor)new PTFloatEditor());
        table.addProperty(new PTProperty("spinner", "Another integer", "Use a spinner to enter an integer")).setCategory("Number").setEditor((PTEditor)new PTSpinnerEditor(0, 100));
        table.addProperty(new PTProperty("directory", "Directory", "Select a directory")).setCategory("Directory/File").setEditor((PTEditor)new PTDirectoryEditor());
        table.addProperty(new PTProperty("file", "File", "Select a file")).setCategory("Directory/File").setEditor((PTEditor)new PTFileEditor());
        table.addProperty(new PTProperty("comboReadOnly", "Combo (read-only)", "A simple combo with seasons")).setCategory("Combo").setEditor((PTEditor)new PTComboEditor(true, new Object[]{"Spring", "Summer", "Autumn", "Winter"}));
        table.addProperty(new PTProperty("combo", "Combo", "A combo that is not read-only")).setCategory("Combo").setEditor((PTEditor)new PTComboEditor(new Object[]{"Value 1", "Value 2", "Value 3"}));
        table.addProperty(new PTProperty("cb", "Checkbox", "A checkbox")).setCategory("Checkbox").setEditor((PTEditor)new PTCheckboxEditor()).setCategory("Checkbox");
        table.addProperty(new PTProperty("cb2", "Checkbox (disabled)", "A disabled checkbox...")).setEditor((PTEditor)new PTCheckboxEditor()).setCategory("Checkbox").setEnabled(false);
        table.addProperty(new PTProperty("color", "Color", "Pick it !")).setCategory("Misc").setEditor((PTEditor)new PTColorEditor());
        table.addProperty(new PTProperty("font", "Font", "Pick again my friend")).setEditor((PTEditor)new PTFontEditor()).setCategory("Misc");
        table.addProperty(new PTProperty("dimension", "Dimension", "A dimension is composed of a width and a height")).setCategory("Misc").setEditor((PTEditor)new PTDimensionEditor());
        table.addProperty(new PTProperty("rectangle", "Rectangle", "A rectangle is composed of a position (x,y) and a dimension(width,height)")).setCategory("Misc").setEditor((PTEditor)new PTRectangleEditor());
        table.addProperty(new PTProperty("inset", "Inset", "An inset is composed of the following fields:top,left,bottom,right)")).setCategory("Misc").setEditor((PTEditor)new PTInsetsEditor());
        table.addProperty(new PTProperty("date", "Date", "Well, is there something more to say ?")).setCategory("Misc").setEditor((PTEditor)new PTDateEditor());
        return table;
    }
}

