/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.opal.nebulaslider;

import org.eclipse.nebula.widgets.opal.nebulaslider.NebulaSlider;
import org.eclipse.nebula.widgets.opal.nebulaslider.NebulaSliderGraphicConfiguration;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;

public class NebularSliderDefaultConfiguration
implements NebulaSliderGraphicConfiguration {
    private static final int H_MARGIN = 5;
    private static final int SELECTOR_WIDTH = 78;
    private static final int BAR_HEIGHT = 12;
    private static final int SELECTOR_HEIGHT = 32;
    protected final NebulaSlider parentSlider;
    private Font font;

    public NebularSliderDefaultConfiguration(NebulaSlider parentSlider) {
        this.parentSlider = parentSlider;
    }

    @Override
    public Color getBarInsideColor() {
        return this.getAndDisposeColor(225, 225, 225);
    }

    @Override
    public Color getBarBorderColor() {
        return this.getAndDisposeColor(211, 211, 211);
    }

    @Override
    public Color getBarSelectionColor() {
        return this.getAndDisposeColor(41, 128, 185);
    }

    @Override
    public Color getSelectorColor() {
        return this.getAndDisposeColor(52, 152, 219);
    }

    @Override
    public Color getSelectorColorBorder() {
        return this.getAndDisposeColor(224, 237, 245);
    }

    @Override
    public Color getSelectorTextColor() {
        return this.getAndDisposeColor(255, 255, 255);
    }

    @Override
    public Color getArrowColor() {
        return this.getAndDisposeColor(153, 203, 237);
    }

    @Override
    public Font getTextFont() {
        if (this.font == null || this.font.isDisposed()) {
            FontData fontData = this.parentSlider.getFont().getFontData()[0];
            Font newFont = new Font((Device)this.parentSlider.getDisplay(), fontData.getName(), this.getFontSize(fontData), 1);
            this.parentSlider.addDisposeListener(e -> {
                if (!newFont.isDisposed()) {
                    newFont.dispose();
                }
            });
            this.font = newFont;
        }
        return this.font;
    }

    protected int getFontSize(FontData fontData) {
        return Math.max(fontData.getHeight(), 14);
    }

    @Override
    public int getHorizontalMargin() {
        return 5;
    }

    @Override
    public int getSelectorWidth() {
        return 78;
    }

    @Override
    public int getSelectorHeight() {
        return 32;
    }

    @Override
    public int getBarHeight() {
        return 12;
    }

    protected Color getAndDisposeColor(int r, int g, int b) {
        return new Color(r, g, b);
    }

    @Override
    public int getArrowLineWidth() {
        return 3;
    }
}

