/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.timeline.figures.detail.track.lane;

import java.util.List;
import java.util.ListIterator;
import java.util.stream.Collectors;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.XYLayout;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.PrecisionRectangle;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.nebula.widgets.timeline.ITimelineEvent;
import org.eclipse.nebula.widgets.timeline.TimeBaseConverter;
import org.eclipse.nebula.widgets.timeline.Timing;
import org.eclipse.nebula.widgets.timeline.figures.IStyledFigure;
import org.eclipse.nebula.widgets.timeline.figures.RootFigure;
import org.eclipse.nebula.widgets.timeline.figures.detail.track.lane.EventFigure;
import org.eclipse.nebula.widgets.timeline.jface.ITimelineStyleProvider;

public class LaneFigure
extends Figure
implements IStyledFigure {
    private int fPreferredHeight;

    public LaneFigure(ITimelineStyleProvider styleProvider) {
        this.setLayoutManager((LayoutManager)new LaneLayout());
        this.updateStyle(styleProvider);
    }

    @Override
    public void updateStyle(ITimelineStyleProvider styleProvider) {
        this.setForegroundColor(styleProvider.getLaneColor());
        this.fPreferredHeight = styleProvider.getLaneHeight();
    }

    public Dimension getPreferredSize(int wHint, int hHint) {
        return new Dimension(wHint, this.fPreferredHeight);
    }

    public void add(IFigure figure, Object constraint, int index) {
        super.add(figure, constraint, index);
        this.getChildren().sort((o1, o2) -> ((EventFigure)o1).compareTo((EventFigure)o2));
    }

    public List<EventFigure> getEventFigures() {
        return this.getChildren().stream().filter(p -> p instanceof EventFigure).map(p -> (EventFigure)p).collect(Collectors.toList());
    }

    private class LaneLayout
    extends XYLayout {
        private LaneLayout() {
        }

        private Rectangle getConstraintAsRectangle(IFigure figure) {
            ITimelineEvent event = (ITimelineEvent)this.getConstraint(figure);
            return new PrecisionRectangle((double)event.getStartTimestamp(), 0.0, (double)event.getDuration(), 1.0);
        }

        public void layout(IFigure parent) {
            TimeBaseConverter timeViewDetails = RootFigure.getRootFigure(parent).getTimeViewDetails();
            for (Object figure : LaneFigure.this.getChildren()) {
                ITimelineEvent event = (ITimelineEvent)this.getConstraint((IFigure)figure);
                Timing screenCoordinates = timeViewDetails.toDetailCoordinates(event.getTiming());
                PrecisionRectangle screenBounds = new PrecisionRectangle(screenCoordinates.getTimestamp(), (double)LaneFigure.this.getBounds().y(), screenCoordinates.getDuration(), (double)LaneFigure.this.getBounds().height());
                if (screenBounds.width() == 0) {
                    screenBounds.setWidth(1);
                }
                ((IFigure)figure).setBounds((Rectangle)screenBounds);
            }
        }

        protected Dimension calculatePreferredSize(IFigure f, int wHint, int hHint) {
            Rectangle rect = new Rectangle();
            ListIterator children = f.getChildren().listIterator();
            while (children.hasNext()) {
                IFigure child = (IFigure)children.next();
                Rectangle r = this.getConstraintAsRectangle(child);
                if (r == null) continue;
                if (r.width == -1 || r.height == -1) {
                    Dimension preferredSize = child.getPreferredSize(r.width, r.height);
                    r = r.getCopy();
                    if (r.width == -1) {
                        r.width = preferredSize.width;
                    }
                    if (r.height == -1) {
                        r.height = preferredSize.height;
                    }
                }
                rect.union(r);
            }
            Dimension d = rect.getSize();
            Insets insets = f.getInsets();
            return new Dimension(d.width + insets.getWidth(), d.height + insets.getHeight()).union(this.getBorderPreferredSize(f));
        }
    }
}

