/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.visualization.internal.widgets.introspection;

import java.beans.BeanDescriptor;
import java.beans.BeanInfo;
import java.beans.EventSetDescriptor;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.MethodDescriptor;
import java.beans.PropertyDescriptor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.nebula.visualization.internal.widgets.introspection.GenericBeanInfo;

public class DefaultWidgetIntrospector {
    public static String[] FIGURE_NON_PROPERTIES = new String[]{"children", "class", "clientArea", "coordinateSystem", "clippingStrategy", "focusTraversable", "insets", "layoutManager", "localBackgroundColor", "localForegroundColor", "maximumSize", "minimumSize", "mirrored", "parent", "preferredSize", "requestFocusEnabled", "toolTip", "showing", "updateManager", "valid", "beanInfo"};

    public BeanInfo getBeanInfo(Class<?> beanClass) throws IntrospectionException {
        Introspector.flushFromCaches(beanClass);
        BeanInfo bi = Introspector.getBeanInfo(beanClass);
        BeanDescriptor bd = bi.getBeanDescriptor();
        MethodDescriptor[] mds = bi.getMethodDescriptors();
        EventSetDescriptor[] esds = bi.getEventSetDescriptors();
        PropertyDescriptor[] pds = bi.getPropertyDescriptors();
        ArrayList<PropertyDescriptor> filteredPDList = new ArrayList<PropertyDescriptor>();
        List<String> nonPropList = Arrays.asList(this.getNonProperties());
        PropertyDescriptor[] propertyDescriptorArray = pds;
        int n = pds.length;
        int n2 = 0;
        while (n2 < n) {
            PropertyDescriptor pd = propertyDescriptorArray[n2];
            if (!nonPropList.contains(pd.getName()) && pd.getWriteMethod() != null && pd.getReadMethod() != null) {
                filteredPDList.add(pd);
            }
            ++n2;
        }
        int defaultEvent = bi.getDefaultEventIndex();
        int defaultProperty = bi.getDefaultPropertyIndex();
        return new GenericBeanInfo(bd, esds, defaultEvent, filteredPDList.toArray(new PropertyDescriptor[filteredPDList.size()]), defaultProperty, mds, null);
    }

    public String[] getNonProperties() {
        return FIGURE_NON_PROPERTIES;
    }

    public String[] concatenateStringArrays(String[] A, String[] B) {
        String[] C = new String[A.length + B.length];
        System.arraycopy(A, 0, C, 0, A.length);
        System.arraycopy(B, 0, C, A.length, B.length);
        return C;
    }
}

