/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.geomap;

import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.nebula.widgets.geomap.internal.TileRef;
import org.eclipse.nebula.widgets.geomap.internal.URLService;

public class TileServer
extends URLService {
    private String urlFormat = "{0}/{1}/{2}.png";
    private final int minZoom;
    private final int maxZoom;

    public TileServer(String url, int minZoom, int maxZoom, String urlFormat) {
        super(url, urlFormat);
        this.minZoom = minZoom;
        this.maxZoom = maxZoom;
    }

    public TileServer(String url, int maxZoom) {
        this.parseUrl(url, "{0}/{1}/{2}.png");
        this.minZoom = 0;
        this.maxZoom = maxZoom;
    }

    @Override
    protected Object[] getURLFormatArguments(Object ref) {
        TileRef tile = (TileRef)ref;
        return new Object[]{String.valueOf(tile.z), String.valueOf(tile.x), String.valueOf(tile.y)};
    }

    protected Map<String, String> createZXYMap(TileRef tile, String zKey, String xKey, String yKey) {
        HashMap<String, String> formatMap = new HashMap<String, String>();
        formatMap.put(zKey, String.valueOf(tile.z));
        formatMap.put(xKey, String.valueOf(tile.x));
        formatMap.put(yKey, String.valueOf(tile.y));
        return formatMap;
    }

    protected Map<String, String> getURLFormatMap(TileRef tile) {
        return this.createZXYMap(tile, "{0}", "{1}", "{2}");
    }

    protected String getTileURL(TileRef tile, String urlFormat, Object[] formatArguments) {
        return this.getURL() + MessageFormat.format(urlFormat, formatArguments);
    }

    protected String getTileURL(TileRef tile, String urlFormat, Map<String, String> formatMap) {
        for (String key : formatMap.keySet()) {
            urlFormat = urlFormat.replace(key, formatMap.get(key));
        }
        return this.getURL() + urlFormat;
    }

    public String getTileURL(TileRef tile) {
        if (this.urlFormat != null) {
            Object[] urlFormatArguments = this.getURLFormatArguments(tile);
            if (urlFormatArguments != null) {
                return this.getTileURL(tile, this.urlFormat, urlFormatArguments);
            }
            Map<String, String> urlFormatMap = this.getURLFormatMap(tile);
            if (urlFormatMap != null) {
                return this.getTileURL(tile, this.urlFormat, urlFormatMap);
            }
        }
        return null;
    }

    @Override
    public String toString() {
        return this.getURL();
    }

    public int getMinZoom() {
        return this.minZoom;
    }

    public int getMaxZoom() {
        return this.maxZoom;
    }
}

