/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.timeline.listeners;

import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.MouseEvent;
import org.eclipse.draw2d.MouseListener;
import org.eclipse.draw2d.MouseMotionListener;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.nebula.widgets.timeline.TimeBaseConverter;
import org.eclipse.nebula.widgets.timeline.figures.RootFigure;
import org.eclipse.nebula.widgets.timeline.figures.detail.track.lane.EventFigure;

public class DetailAreaListener
extends MouseMotionListener.Stub
implements MouseListener,
MouseMotionListener {
    private Point fLocation = null;
    private final Figure fFigure;
    private boolean fDragged = false;

    public DetailAreaListener(Figure figure) {
        this.fFigure = figure;
        figure.addMouseListener((MouseListener)this);
        figure.addMouseMotionListener((MouseMotionListener)this);
    }

    public void mousePressed(MouseEvent me) {
        this.fDragged = false;
        this.fLocation = me.getLocation();
        me.consume();
    }

    public void mouseReleased(MouseEvent me) {
        if (!this.fDragged) {
            IFigure figureUnderCursor = this.fFigure.findFigureAt(me.x, me.y);
            if (figureUnderCursor instanceof EventFigure) {
                RootFigure.getRootFigure((IFigure)this.fFigure).setSelection((EventFigure)figureUnderCursor);
            } else {
                long eventTime = RootFigure.getTimeViewDetails((IFigure)this.fFigure).screenOffsetToEventTime(me.x);
                RootFigure.getRootFigure((IFigure)this.fFigure).createCursor(eventTime);
            }
        }
        if (this.fLocation != null) {
            this.fLocation = null;
            me.consume();
        }
    }

    public void mouseDoubleClicked(MouseEvent me) {
    }

    public void mouseDragged(MouseEvent me) {
        if (this.fLocation != null) {
            this.fDragged = true;
            Point targetLocation = me.getLocation();
            Dimension offset = this.fLocation.getDifference(targetLocation);
            if (offset.width() != 0) {
                TimeBaseConverter timeDetails = RootFigure.getRootFigure((IFigure)this.fFigure).getTimeViewDetails();
                if (timeDetails.translateDetailAreaOffset(offset.width())) {
                    this.fLocation = targetLocation;
                }
                me.consume();
            }
        }
    }
}

