/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.p2;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum VersionSegment implements Enumerator
{
    MAJOR(0, "Major", "Major"),
    MINOR(0, "Minor", "Minor"),
    MICRO(0, "Micro", "Micro"),
    QUALIFIER(0, "Qualifier", "Qualifier");

    public static final int MAJOR_VALUE = 0;
    public static final int MINOR_VALUE = 0;
    public static final int MICRO_VALUE = 0;
    public static final int QUALIFIER_VALUE = 0;
    private static final VersionSegment[] VALUES_ARRAY;
    public static final List<VersionSegment> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new VersionSegment[]{MAJOR, MINOR, MICRO, QUALIFIER};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static VersionSegment get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            VersionSegment result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static VersionSegment getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            VersionSegment result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static VersionSegment get(int value) {
        switch (value) {
            case 0: {
                return MAJOR;
            }
        }
        return null;
    }

    private VersionSegment(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

