/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.ast;

import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.ast.LocalDeclaration;
import org.eclipse.jdt.internal.compiler.ast.Pattern;
import org.eclipse.jdt.internal.compiler.ast.RecordPattern;
import org.eclipse.jdt.internal.compiler.ast.SwitchStatement;
import org.eclipse.jdt.internal.compiler.ast.TypeReference;
import org.eclipse.jdt.internal.compiler.codegen.BranchLabel;
import org.eclipse.jdt.internal.compiler.codegen.CodeStream;
import org.eclipse.jdt.internal.compiler.flow.FlowContext;
import org.eclipse.jdt.internal.compiler.flow.FlowInfo;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.LocalVariableBinding;
import org.eclipse.jdt.internal.compiler.lookup.RecordComponentBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;

public class TypePattern
extends Pattern {
    public LocalDeclaration local;
    private boolean isEitherOrPattern = false;

    public TypePattern(LocalDeclaration local) {
        this.local = local;
    }

    public static TypePattern createTypePattern(LocalDeclaration lokal) {
        if (lokal.name.length == 1 && lokal.name[0] == '_') {
            return new TypePattern(lokal){

                @Override
                public boolean isUnnamed() {
                    return true;
                }
            };
        }
        return new TypePattern(lokal);
    }

    @Override
    public TypeReference getType() {
        return this.local.type;
    }

    @Override
    public void setIsEitherOrPattern() {
        this.isEitherOrPattern = true;
    }

    @Override
    public LocalVariableBinding[] bindingsWhenTrue() {
        LocalVariableBinding[] localVariableBindingArray;
        if (this.isUnnamed() || this.local.binding == null) {
            localVariableBindingArray = NO_VARIABLES;
        } else {
            LocalVariableBinding[] localVariableBindingArray2 = new LocalVariableBinding[1];
            localVariableBindingArray = localVariableBindingArray2;
            localVariableBindingArray2[0] = this.local.binding;
        }
        return localVariableBindingArray;
    }

    @Override
    public FlowInfo analyseCode(BlockScope currentScope, FlowContext flowContext, FlowInfo flowInfo) {
        flowInfo = this.local.analyseCode(currentScope, flowContext, flowInfo);
        FlowInfo patternInfo = flowInfo.copy();
        if (this.isUnnamed()) {
            return patternInfo;
        }
        patternInfo.markAsDefinitelyAssigned(this.local.binding);
        if (!this.isTotalTypeNode) {
            patternInfo.markAsDefinitelyNonNull(this.local.binding);
        } else if (flowContext.associatedNode instanceof SwitchStatement) {
            SwitchStatement swStmt = (SwitchStatement)flowContext.associatedNode;
            int nullStatus = swStmt.containsNull ? 4 : swStmt.expression.nullStatus(patternInfo, flowContext);
            patternInfo.markNullStatus(this.local.binding, nullStatus);
        }
        return patternInfo;
    }

    @Override
    public void generateCode(BlockScope currentScope, CodeStream codeStream, BranchLabel patternMatchLabel, BranchLabel matchFailLabel) {
        if (this.isUnnamed()) {
            if (this.getEnclosingPattern() == null || this.isTotalTypeNode) {
                switch (this.local.binding.type.id) {
                    case 7: 
                    case 8: {
                        codeStream.pop2();
                        break;
                    }
                    default: {
                        codeStream.pop();
                        break;
                    }
                }
            }
        } else {
            if (!this.isTotalTypeNode) {
                codeStream.checkcast(this.local.binding.type);
            }
            this.local.generateCode(currentScope, codeStream);
        }
    }

    @Override
    public boolean dominates(Pattern p) {
        if (!this.isUnguarded()) {
            return false;
        }
        if (p.resolvedType == null || this.resolvedType == null) {
            return false;
        }
        return p.resolvedType.erasure().isSubtypeOf(this.resolvedType.erasure(), false);
    }

    @Override
    public TypeBinding resolveType(BlockScope scope) {
        RecordComponentBinding[] components;
        ReferenceBinding recType;
        if (this.resolvedType != null) {
            return this.resolvedType;
        }
        Pattern enclosingPattern = this.getEnclosingPattern();
        if ((this.local.type == null || this.local.type.isTypeNameVar(scope)) && enclosingPattern instanceof RecordPattern && (recType = (ReferenceBinding)enclosingPattern.resolvedType) != null && (components = recType.components()).length > this.index) {
            RecordComponentBinding rcb = components[this.index];
            if (rcb.type != null && (rcb.tagBits & 0x80L) != 0L) {
                scope.problemReporter().invalidType(this, rcb.type);
            }
            TypeBinding[] mentionedTypeVariables = rcb.type != null ? rcb.type.syntheticTypeVariablesMentioned() : Binding.NO_TYPE_VARIABLES;
            TypeBinding typeBinding = this.resolvedType = mentionedTypeVariables.length > 0 ? rcb.type.upwardsProjection(scope, mentionedTypeVariables) : rcb.type;
            if (this.local.type != null) {
                this.local.type.resolvedType = this.resolvedType;
            }
        }
        this.local.resolve(scope, true);
        if (this.local.binding != null) {
            this.local.binding.modifiers |= 0x10000000;
            if (enclosingPattern != null) {
                this.local.binding.useFlag = 1;
            }
            if (this.local.type != null) {
                this.resolvedType = this.local.binding.type;
            }
        }
        if (this.isEitherOrPattern && !this.isUnnamed()) {
            scope.problemReporter().namedPatternVariablesDisallowedHere(this.local);
        }
        return this.resolvedType;
    }

    @Override
    public void traverse(ASTVisitor visitor, BlockScope scope) {
        if (visitor.visit(this, scope)) {
            this.local.traverse(visitor, scope);
        }
        visitor.endVisit(this, scope);
    }

    @Override
    public StringBuilder printExpression(int indent, StringBuilder output) {
        return this.local.printAsExpression(indent, output);
    }
}

