/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.p2.internal.ui;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.oomph.p2.Requirement;
import org.eclipse.oomph.p2.internal.ui.RepositoryExplorer;
import org.eclipse.oomph.p2.internal.ui.SearchEclipseDialog;
import org.eclipse.oomph.util.ObjectUtil;
import org.eclipse.ui.handlers.HandlerUtil;

public abstract class SearchEclipseHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        SearchEclipseDialog dialog = this.getSearchEclipseDialog();
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (selection instanceof IStructuredSelection) {
            Object[] objectArray = ((IStructuredSelection)selection).toArray();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object object = objectArray[n2];
                Requirement requirement = (Requirement)ObjectUtil.adapt((Object)object, Requirement.class);
                if (requirement != null) {
                    dialog.setFilterString(requirement);
                    break;
                }
                ++n2;
            }
        }
        return null;
    }

    protected abstract SearchEclipseDialog getSearchEclipseDialog();

    public static final class Repositories
    extends SearchEclipseHandler {
        @Override
        protected SearchEclipseDialog getSearchEclipseDialog() {
            return RepositoryExplorer.getSearchEclipseRepositoriesDialog();
        }
    }

    public static final class Requirements
    extends SearchEclipseHandler {
        @Override
        protected SearchEclipseDialog getSearchEclipseDialog() {
            return RepositoryExplorer.getSearchEclipseRequirementDialog();
        }
    }
}

