/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.maven.provider;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.UnexecutableCommand;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.command.CommandParameter;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.DelegatingWrapperItemProvider;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.IItemStyledLabelProvider;
import org.eclipse.emf.edit.provider.ItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.StyledString;
import org.eclipse.emf.edit.provider.ViewerNotification;
import org.eclipse.oomph.maven.MavenFactory;
import org.eclipse.oomph.maven.MavenPackage;
import org.eclipse.oomph.maven.Project;
import org.eclipse.oomph.maven.provider.CoordinateItemProvider;
import org.eclipse.oomph.maven.provider.ReferenceGroup;

public class ProjectItemProvider
extends CoordinateItemProvider {
    public ProjectItemProvider(AdapterFactory adapterFactory) {
        super(adapterFactory);
    }

    @Override
    public List<IItemPropertyDescriptor> getPropertyDescriptors(Object object) {
        if (this.itemPropertyDescriptors == null) {
            super.getPropertyDescriptors(object);
            this.addLocationPropertyDescriptor(object);
            this.addIncomingParentReferencesPropertyDescriptor(object);
            this.addIncomingDependencyReferencesPropertyDescriptor(object);
        }
        return this.itemPropertyDescriptors;
    }

    protected void addLocationPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_Project_location_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_Project_location_feature", "_UI_Project_type"), (EStructuralFeature)MavenPackage.Literals.PROJECT__LOCATION, false, false, false, ItemPropertyDescriptor.GENERIC_VALUE_IMAGE, null, null));
    }

    protected void addIncomingParentReferencesPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_Project_incomingParentReferences_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_Project_incomingParentReferences_feature", "_UI_Project_type"), (EStructuralFeature)MavenPackage.Literals.PROJECT__INCOMING_PARENT_REFERENCES, false, false, true, null, null, null));
    }

    protected void addIncomingDependencyReferencesPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_Project_incomingDependencyReferences_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_Project_incomingDependencyReferences_feature", "_UI_Project_type"), (EStructuralFeature)MavenPackage.Literals.PROJECT__INCOMING_DEPENDENCY_REFERENCES, false, false, true, null, null, null));
    }

    public Collection<? extends EStructuralFeature> getChildrenFeaturesGen(Object object) {
        if (this.childrenFeatures == null) {
            super.getChildrenFeatures(object);
            this.childrenFeatures.add(MavenPackage.Literals.PROJECT__PARENT);
            this.childrenFeatures.add(MavenPackage.Literals.PROJECT__DEPENDENCIES);
            this.childrenFeatures.add(MavenPackage.Literals.PROJECT__MANAGED_DEPENDENCIES);
            this.childrenFeatures.add(MavenPackage.Literals.PROJECT__PROPERTIES);
        }
        return this.childrenFeatures;
    }

    protected Collection<? extends EStructuralFeature> getActualChildrenFeatures(Object object) {
        ArrayList<? extends EStructuralFeature> actualChildrenFeatures = new ArrayList<EStructuralFeature>(this.getChildrenFeaturesGen(object));
        actualChildrenFeatures.remove(MavenPackage.Literals.PROJECT__DEPENDENCIES);
        actualChildrenFeatures.remove(MavenPackage.Literals.PROJECT__MANAGED_DEPENDENCIES);
        actualChildrenFeatures.remove(MavenPackage.Literals.PROJECT__PROPERTIES);
        return actualChildrenFeatures;
    }

    @Override
    public final Collection<? extends EStructuralFeature> getChildrenFeatures(Object object) {
        return this.getActualChildrenFeatures(object);
    }

    @Override
    protected EStructuralFeature getChildFeature(Object object, Object child) {
        return super.getChildFeature(object, child);
    }

    public Collection<?> basicGetChildren(Object object) {
        return super.getChildren(object);
    }

    public Collection<?> getChildren(Object object) {
        ArrayList children = new ArrayList(this.basicGetChildren(object));
        Project project = (Project)object;
        if (!project.getDependencies().isEmpty()) {
            children.add(new GroupedItemProvider(this.getAdapterFactory(), project, MavenPackage.Literals.PROJECT__DEPENDENCIES));
        }
        if (!project.getManagedDependencies().isEmpty()) {
            children.add(new GroupedItemProvider(this.getAdapterFactory(), project, MavenPackage.Literals.PROJECT__MANAGED_DEPENDENCIES));
        }
        if (!project.getProperties().isEmpty()) {
            children.add(new GroupedItemProvider(this.getAdapterFactory(), project, MavenPackage.Literals.PROJECT__PROPERTIES));
        }
        if (!project.getIncomingParentReferences().isEmpty()) {
            children.add(new GroupedItemProvider(this.getAdapterFactory(), project, MavenPackage.Literals.PROJECT__INCOMING_PARENT_REFERENCES));
        }
        if (!project.getIncomingDependencyReferences().isEmpty()) {
            children.add(new GroupedItemProvider(this.getAdapterFactory(), project, MavenPackage.Literals.PROJECT__INCOMING_DEPENDENCY_REFERENCES));
        }
        return children;
    }

    @Override
    public Object getImage(Object object) {
        return this.overlayImage(object, this.getResourceLocator().getImage("full/obj16/Project"));
    }

    @Override
    protected boolean shouldComposeCreationImage() {
        return true;
    }

    @Override
    public String getText(Object object) {
        return this.getStyledText(object).getString();
    }

    @Override
    public StyledString getStyledText(Object object) {
        StyledString styledLabel = super.getStyledText(object);
        Project project = (Project)object;
        String location = project.getLocation();
        styledLabel.append(" - ", StyledString.Style.QUALIFIER_STYLER);
        styledLabel.append(location, StyledString.Style.DECORATIONS_STYLER);
        return styledLabel;
    }

    @Override
    public void notifyChanged(Notification notification) {
        this.updateChildren(notification);
        switch (notification.getFeatureID(Project.class)) {
            case 8: {
                this.fireNotifyChanged((Notification)new ViewerNotification(notification, notification.getNotifier(), false, true));
                return;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                this.fireNotifyChanged((Notification)new ViewerNotification(notification, notification.getNotifier(), true, false));
                return;
            }
        }
        super.notifyChanged(notification);
    }

    @Override
    protected void collectNewChildDescriptors(Collection<Object> newChildDescriptors, Object object) {
        super.collectNewChildDescriptors(newChildDescriptors, object);
        newChildDescriptors.add(this.createChildParameter(MavenPackage.Literals.PROJECT__PARENT, MavenFactory.eINSTANCE.createParent()));
        newChildDescriptors.add(this.createChildParameter(MavenPackage.Literals.PROJECT__DEPENDENCIES, MavenFactory.eINSTANCE.createDependency()));
        newChildDescriptors.add(this.createChildParameter(MavenPackage.Literals.PROJECT__MANAGED_DEPENDENCIES, MavenFactory.eINSTANCE.createDependency()));
        newChildDescriptors.add(this.createChildParameter(MavenPackage.Literals.PROJECT__PROPERTIES, MavenFactory.eINSTANCE.createProperty()));
    }

    public String getCreateChildText(Object owner, Object feature, Object child, Collection<?> selection) {
        boolean qualify;
        Object childFeature = feature;
        Object childObject = child;
        boolean bl = qualify = childFeature == MavenPackage.Literals.PROJECT__DEPENDENCIES || childFeature == MavenPackage.Literals.PROJECT__MANAGED_DEPENDENCIES;
        if (qualify) {
            return this.getString("_UI_CreateChild_text2", new Object[]{this.getTypeText(childObject), this.getFeatureText(childFeature), this.getTypeText(owner)});
        }
        return super.getCreateChildText(owner, feature, child, selection);
    }

    private static class GroupedItemProvider
    extends ProjectItemProvider
    implements ReferenceGroup {
        private final Project project;
        private final EReference eReference;

        private GroupedItemProvider(AdapterFactory adapterFactory, Project project, EReference eStructuralFeature) {
            super(adapterFactory);
            this.project = project;
            this.eReference = eStructuralFeature;
        }

        @Override
        public EReference getFeature() {
            return this.eReference;
        }

        @Override
        protected Collection<? extends EStructuralFeature> getActualChildrenFeatures(Object object) {
            return List.of(this.eReference);
        }

        @Override
        public Collection<?> getChildren(Object object) {
            return this.basicGetChildren(this.project);
        }

        protected Object createWrapper(EObject object, EStructuralFeature feature, Object value, int index) {
            if (!this.eReference.isContainment()) {
                return new Wrapper(value, object, feature, index, this.adapterFactory);
            }
            return value;
        }

        @Override
        public Object getImage(Object object) {
            return super.getImage(object);
        }

        @Override
        public StyledString getStyledText(Object object) {
            StyledString styledLabel = new StyledString();
            styledLabel.append(this.getFeatureText(this.eReference), StyledString.Style.DECORATIONS_STYLER);
            return styledLabel;
        }

        @Override
        public List<IItemPropertyDescriptor> getPropertyDescriptors(Object object) {
            return List.of();
        }

        public IItemPropertyDescriptor getPropertyDescriptor(Object object, Object propertyId) {
            return null;
        }

        public Object getParent(Object object) {
            return this.project;
        }

        public Collection<?> getNewChildDescriptors(Object object, EditingDomain editingDomain, Object sibling) {
            return List.of();
        }

        public Command createCommand(Object object, EditingDomain domain, Class<? extends Command> commandClass, CommandParameter commandParameter) {
            return UnexecutableCommand.INSTANCE;
        }

        public int hashCode() {
            return Objects.hash(this.project, this.eReference);
        }

        public boolean equals(Object other) {
            if (other instanceof GroupedItemProvider) {
                GroupedItemProvider groupedItemProvider = (GroupedItemProvider)other;
                if (groupedItemProvider.eReference == this.eReference && groupedItemProvider.project == this.project) {
                    return true;
                }
            }
            return false;
        }
    }

    private static class Wrapper
    extends DelegatingWrapperItemProvider
    implements IItemStyledLabelProvider {
        public Wrapper(Object value, Object owner, EStructuralFeature feature, int index, AdapterFactory adapterFactory) {
            super(value, owner, feature, index, adapterFactory);
        }

        public Object getStyledText(Object object) {
            EObject delegateValue = (EObject)this.getDelegateValue();
            EObject eContainer = delegateValue.eContainer();
            IItemStyledLabelProvider itemStyledLabelProvider = (IItemStyledLabelProvider)this.getRootAdapterFactory().adapt((Notifier)eContainer, IItemStyledLabelProvider.class);
            return itemStyledLabelProvider.getStyledText((Object)eContainer);
        }

        public boolean hasChildren(Object object) {
            return false;
        }

        public Collection<?> getChildren(Object object) {
            return List.of();
        }
    }
}

