/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.p2;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum RequirementType implements Enumerator
{
    NONE(0, "NONE", "None"),
    FEATURE(1, "FEATURE", "Feature"),
    PROJECT(2, "PROJECT", "Project");

    public static final int NONE_VALUE = 0;
    public static final int FEATURE_VALUE = 1;
    public static final int PROJECT_VALUE = 2;
    private static final RequirementType[] VALUES_ARRAY;
    public static final List<RequirementType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new RequirementType[]{NONE, FEATURE, PROJECT};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static RequirementType get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            RequirementType result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static RequirementType getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            RequirementType result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static RequirementType get(int value) {
        switch (value) {
            case 0: {
                return NONE;
            }
            case 1: {
                return FEATURE;
            }
            case 2: {
                return PROJECT;
            }
        }
        return null;
    }

    private RequirementType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

