/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.edit.provider.resource;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.command.AbstractCommand;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.edit.EMFEditPlugin;
import org.eclipse.emf.edit.command.AbstractOverrideableCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.emf.edit.provider.ItemProviderAdapter;
import org.eclipse.emf.edit.provider.ViewerNotification;

public class ResourceSetItemProvider
extends ItemProviderAdapter
implements IEditingDomainItemProvider,
IStructuredItemContentProvider,
ITreeItemContentProvider,
IItemLabelProvider,
IItemPropertySource {
    public ResourceSetItemProvider(AdapterFactory adapterFactory) {
        super(adapterFactory);
    }

    @Override
    public List<IItemPropertyDescriptor> getPropertyDescriptors(Object object) {
        if (this.itemPropertyDescriptors == null) {
            super.getPropertyDescriptors(object);
        }
        return this.itemPropertyDescriptors;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<?> getChildren(Object object) {
        ResourceSet resourceSet;
        ResourceSet resourceSet2 = resourceSet = (ResourceSet)object;
        synchronized (resourceSet2) {
            return new ArrayList(resourceSet.getResources());
        }
    }

    @Override
    public Object getParent(Object object) {
        return null;
    }

    @Override
    public Object getImage(Object object) {
        return this.getResourceLocator().getImage("full/obj16/ResourceSet");
    }

    @Override
    public String getText(Object object) {
        return EMFEditPlugin.INSTANCE.getString("_UI_ResourceSet_label");
    }

    public void notifyChanged(Notification notification) {
        switch (notification.getFeatureID(ResourceSet.class)) {
            case 0: {
                this.fireNotifyChanged(new ViewerNotification(notification, notification.getNotifier(), true, false));
                return;
            }
        }
        super.notifyChanged(notification);
    }

    @Override
    public Collection<?> getNewChildDescriptors(Object object, EditingDomain editingDomain, Object sibling) {
        return Collections.emptyList();
    }

    @Override
    protected void collectNewChildDescriptors(Collection<Object> newChildDescriptors, Object object) {
        super.collectNewChildDescriptors(newChildDescriptors, object);
    }

    @Override
    protected Command createDragAndDropCommand(EditingDomain domain, Object owner, float location, int operations, int operation, Collection<?> collection) {
        ResourceSet resourceSet = (ResourceSet)owner;
        class LoadResourceCommand
        extends AbstractOverrideableCommand
        implements AbstractCommand.NonDirtying {
            protected List<Resource> resources;
            private final /* synthetic */ Collection val$collection;
            private final /* synthetic */ ResourceSet val$resourceSet;

            protected LoadResourceCommand(EditingDomain domain, Collection collection, ResourceSet resourceSet) {
                this.val$collection = collection;
                this.val$resourceSet = resourceSet;
                super(domain);
            }

            protected boolean prepare() {
                for (Object object : this.val$collection) {
                    if (object instanceof URI) continue;
                    return false;
                }
                return true;
            }

            @Override
            public void doExecute() {
                this.resources = new ArrayList<Resource>();
                for (Object object : this.val$collection) {
                    URI uri = (URI)object;
                    Resource resource = this.val$resourceSet.getResource(uri, false);
                    if (resource == null) {
                        try {
                            resource = this.val$resourceSet.getResource(uri, true);
                        }
                        catch (RuntimeException exception) {
                            resource = this.val$resourceSet.getResource(uri, false);
                            EMFEditPlugin.INSTANCE.log(exception);
                        }
                    }
                    if (resource == null) continue;
                    this.resources.add(resource);
                }
            }

            @Override
            public void doUndo() {
                this.val$resourceSet.getResources().removeAll(this.resources);
                this.resources = null;
            }

            @Override
            public void doRedo() {
                this.doExecute();
            }

            @Override
            public Collection<?> doGetAffectedObjects() {
                return this.resources == null ? Collections.singleton(this.val$resourceSet) : this.resources;
            }

            @Override
            public String doGetDescription() {
                return EMFEditPlugin.INSTANCE.getString("_UI_LoadResources_description");
            }

            @Override
            public String doGetLabel() {
                return EMFEditPlugin.INSTANCE.getString("_UI_LoadResources_label");
            }
        }
        return new LoadResourceCommand(domain, collection, resourceSet);
    }

    @Override
    public ResourceLocator getResourceLocator() {
        return EMFEditPlugin.INSTANCE;
    }
}

