/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.about;

import java.io.File;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.text.StringMatcher;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.ConfigurationInfo;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.about.AboutUtils;
import org.eclipse.ui.internal.about.ProductInfoPage;

public final class AboutSystemPage
extends ProductInfoPage {
    private static final String ID = "productInfo.system";
    private static final int BROWSE_ERROR_LOG_BUTTON = 1024;
    private static final int COPY_TO_CLIPBOARD_BUTTON = 1025;
    private Text text;
    private String info = "";

    public void createControl(Composite parent) {
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "org.eclipse.ui.system_summary_dialog_context");
        Composite outer = this.createOuterComposite(parent);
        Text filterText = new Text(outer, 2944);
        filterText.setLayoutData((Object)GridDataFactory.fillDefaults().create());
        filterText.setFont(JFaceResources.getDialogFont());
        filterText.setMessage(WorkbenchMessages.AboutPluginsDialog_filterTextMessage);
        filterText.setFocus();
        this.text = new Text(outer, 527114);
        this.text.setBackground(parent.getDisplay().getSystemColor(25));
        GridData gridData = new GridData(272);
        gridData.grabExcessVerticalSpace = true;
        gridData.grabExcessHorizontalSpace = true;
        gridData.heightHint = this.convertVerticalDLUsToPixels(300);
        gridData.widthHint = this.convertHorizontalDLUsToPixels(400);
        this.text.setLayoutData((Object)gridData);
        this.text.setFont(JFaceResources.getTextFont());
        this.fetchConfigurationInfo(this.text);
        filterText.addModifyListener(e -> {
            String filter = filterText.getText();
            if (filter.isEmpty()) {
                this.text.setText(this.info);
            } else {
                String[] infoLines;
                StringMatcher matcher = new StringMatcher("*" + filter + "*", true, false);
                StringBuilder filteredInfo = new StringBuilder();
                boolean previousLineEmpty = false;
                String delim = System.lineSeparator();
                String[] stringArray = infoLines = this.info.split(delim);
                int n = infoLines.length;
                int n2 = 0;
                while (n2 < n) {
                    String line = stringArray[n2];
                    boolean lineEmpty = line.isEmpty();
                    if (!(lineEmpty && previousLineEmpty || !lineEmpty && !line.startsWith("***") && !matcher.match(line))) {
                        previousLineEmpty = lineEmpty;
                        filteredInfo.append(line).append(delim);
                    }
                    ++n2;
                }
                this.text.setText(filteredInfo.toString());
            }
        });
        this.setControl((Control)outer);
    }

    @Override
    public void createPageButtons(Composite parent) {
        Button button = this.createButton(parent, 1024, WorkbenchMessages.AboutSystemDialog_browseErrorLogName);
        String filename = Platform.getLogFileLocation().toOSString();
        button.setEnabled(new File(filename).exists());
        this.createButton(parent, 1025, WorkbenchMessages.AboutSystemDialog_copyToClipboardName);
    }

    @Override
    String getId() {
        return ID;
    }

    public void copyToClipboard() {
        if (this.text == null) {
            return;
        }
        Clipboard clipboard = null;
        try {
            clipboard = new Clipboard(this.text.getShell().getDisplay());
            String contents = this.text.getSelectionText();
            if (contents.isEmpty()) {
                contents = this.text.getText();
            }
            clipboard.setContents(new Object[]{contents}, new Transfer[]{TextTransfer.getInstance()});
        }
        finally {
            if (clipboard != null) {
                clipboard.dispose();
            }
        }
    }

    @Override
    protected void buttonPressed(int buttonId) {
        switch (buttonId) {
            case 1024: {
                this.openErrorLogBrowser();
                break;
            }
            case 1025: {
                this.runCopyToClipboard();
            }
        }
        super.buttonPressed(buttonId);
    }

    private void openErrorLogBrowser() {
        AboutUtils.openErrorLogBrowser(this.getShell());
    }

    private void runCopyToClipboard() {
        if (this.text == null) {
            return;
        }
        Clipboard clipboard = null;
        try {
            clipboard = new Clipboard(this.getShell().getDisplay());
            clipboard.setContents(new Object[]{this.text.getText()}, new Transfer[]{TextTransfer.getInstance()});
        }
        finally {
            if (clipboard != null) {
                clipboard.dispose();
            }
        }
    }

    private void fetchConfigurationInfo(Text text) {
        text.setText(WorkbenchMessages.AboutSystemPage_RetrievingSystemInfo);
        Job job = Job.create((String)WorkbenchMessages.AboutSystemPage_FetchJobTitle, monitor -> {
            this.info = ConfigurationInfo.getSystemSummary();
            if (!text.isDisposed()) {
                text.getDisplay().asyncExec(() -> {
                    if (!text.isDisposed()) {
                        text.setText(this.info);
                    }
                });
            }
            return Status.OK_STATUS;
        });
        job.schedule();
    }
}

