/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.about;

import org.eclipse.core.commands.IHandler;
import org.eclipse.core.expressions.EvaluationResult;
import org.eclipse.core.expressions.Expression;
import org.eclipse.core.expressions.ExpressionInfo;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.runtime.IProduct;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.about.InstallationPage;
import org.eclipse.ui.handlers.IHandlerActivation;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.about.CopyTableSelectionHandler;
import org.eclipse.ui.swt.IFocusService;

public abstract class ProductInfoPage
extends InstallationPage
implements IShellProvider {
    private IProduct product;
    private String productName;

    protected IProduct getProduct() {
        if (this.product == null) {
            this.product = Platform.getProduct();
        }
        return this.product;
    }

    public String getProductName() {
        if (this.productName == null) {
            if (this.getProduct() != null) {
                this.productName = this.getProduct().getName();
            }
            if (this.productName == null) {
                this.productName = WorkbenchMessages.AboutDialog_defaultProductName;
            }
        }
        return this.productName;
    }

    public void setProductName(String name) {
        this.productName = name;
    }

    abstract String getId();

    protected Composite createOuterComposite(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridData gd = new GridData(4, 4, true, true);
        composite.setLayoutData((Object)gd);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        composite.setLayout((Layout)layout);
        return composite;
    }

    protected final void addCopySupport(Table table) {
        CopyTableSelectionHandler handler = new CopyTableSelectionHandler();
        Menu menu = new Menu((Control)table);
        MenuItem copyItem = new MenuItem(menu, 0);
        copyItem.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> handler.copySelection(table)));
        copyItem.setText(JFaceResources.getString((String)"copy"));
        copyItem.setImage(ISharedImages.get().getImage("IMG_TOOL_COPY"));
        table.setMenu(menu);
        IFocusService fs = (IFocusService)PlatformUI.getWorkbench().getService(IFocusService.class);
        IHandlerService hs = (IHandlerService)PlatformUI.getWorkbench().getService(IHandlerService.class);
        if (fs != null && hs != null) {
            fs.addFocusTracker((Control)table, ((Object)((Object)this)).getClass().getName() + ".table");
            IHandlerActivation handlerActivation = hs.activateHandler("org.eclipse.ui.edit.copy", (IHandler)handler, ProductInfoPage.controlFocusedExpression((Control)table));
            table.addDisposeListener(e -> hs.deactivateHandler(handlerActivation));
        }
    }

    private static Expression controlFocusedExpression(final Control control) {
        return new Expression(){

            public EvaluationResult evaluate(IEvaluationContext context) {
                return context.getVariable("activeFocusControl") == control ? EvaluationResult.TRUE : EvaluationResult.FALSE;
            }

            public void collectExpressionInfo(ExpressionInfo info) {
                info.addVariableNameAccess("activeFocusControl");
            }
        };
    }
}

