/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.engine;

import org.eclipse.core.internal.preferences.EclipsePreferences;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.equinox.internal.p2.engine.ProfilePreferences;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.osgi.service.prefs.BackingStoreException;

public class SharedProfilePreferences
extends ProfilePreferences {
    public SharedProfilePreferences() {
        this(null, null);
    }

    public SharedProfilePreferences(EclipsePreferences nodeParent, String nodeName) {
        super(nodeParent, nodeName);
        String path = this.absolutePath();
        this.segmentCount = SharedProfilePreferences.getSegmentCount((String)path);
        if (this.segmentCount <= 3) {
            return;
        }
        if (this.segmentCount == 4) {
            this.profileLock = new Object();
        }
        if (this.segmentCount < 5) {
            return;
        }
        this.qualifier = this.getQualifierSegment();
    }

    @Override
    protected IProvisioningAgent getAgent(String segment) throws BackingStoreException {
        IProvisioningAgent agent = super.getAgent(segment);
        return (IProvisioningAgent)agent.getService("org.eclipse.equinox.shared.base.agent");
    }

    @Override
    protected void doSave(IProvisioningAgent agent) throws BackingStoreException {
        throw new BackingStoreException("Can't store in shared install");
    }

    @Override
    protected EclipsePreferences internalCreate(EclipsePreferences nodeParent, String nodeName, Object context) {
        return new SharedProfilePreferences(nodeParent, nodeName);
    }

    @Override
    protected IEclipsePreferences getLoadLevel() {
        if (this.loadLevel == null) {
            if (this.qualifier == null) {
                return null;
            }
            SharedProfilePreferences node = this;
            int i = 5;
            while (i < this.segmentCount) {
                node = (EclipsePreferences)node.parent();
                ++i;
            }
            this.loadLevel = node;
        }
        return this.loadLevel;
    }

    @Override
    protected synchronized void save() throws BackingStoreException {
        throw new BackingStoreException("Can't store in shared install");
    }

    @Override
    protected String getQualifierSegment() {
        return SharedProfilePreferences.getSegment((String)this.absolutePath(), (int)4);
    }

    @Override
    protected String getProfileIdSegment() {
        return SharedProfilePreferences.getSegment((String)this.absolutePath(), (int)3);
    }

    @Override
    protected String getAgentLocationSegment() {
        return SharedProfilePreferences.getSegment((String)this.absolutePath(), (int)2);
    }
}

