/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.DPIUtil;
import org.eclipse.swt.internal.Win32DPIUtils;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.CoordinateSystemMapper;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Monitor;

class SingleZoomCoordinateSystemMapper
implements CoordinateSystemMapper {
    private final Display display;

    SingleZoomCoordinateSystemMapper(Display display) {
        this.display = display;
    }

    private int getZoomLevelForMapping(Control from, Control to) {
        if (from != null && from.isDisposed()) {
            this.display.error(5);
        }
        if (to != null && to.isDisposed()) {
            this.display.error(5);
        }
        if (to != null) {
            return to.getAutoscalingZoom();
        }
        return from.getAutoscalingZoom();
    }

    @Override
    public Point map(Control from, Control to, Point point) {
        int zoom = this.getZoomLevelForMapping(from, to);
        point = Win32DPIUtils.pointToPixelAsLocation(point, zoom);
        return Win32DPIUtils.pixelToPointAsLocation(this.display.mapInPixels(from, to, point), zoom);
    }

    @Override
    public Rectangle map(Control from, Control to, Rectangle rectangle) {
        int zoom = this.getZoomLevelForMapping(from, to);
        rectangle = Win32DPIUtils.pointToPixel(rectangle, zoom);
        return Win32DPIUtils.pixelToPoint(this.display.mapInPixels(from, to, rectangle), zoom);
    }

    @Override
    public Point map(Control from, Control to, int x, int y) {
        int zoom = this.getZoomLevelForMapping(from, to);
        x = DPIUtil.pointToPixel(x, zoom);
        y = DPIUtil.pointToPixel(y, zoom);
        return Win32DPIUtils.pixelToPointAsLocation(this.display.mapInPixels(from, to, x, y), zoom);
    }

    @Override
    public Rectangle map(Control from, Control to, int x, int y, int width, int height) {
        int zoom = this.getZoomLevelForMapping(from, to);
        x = DPIUtil.pointToPixel(x, zoom);
        y = DPIUtil.pointToPixel(y, zoom);
        width = DPIUtil.pointToPixel(width, zoom);
        height = DPIUtil.pointToPixel(height, zoom);
        return Win32DPIUtils.pixelToPoint(this.display.mapInPixels(from, to, x, y, width, height), zoom);
    }

    @Override
    public Rectangle mapMonitorBounds(Rectangle.WithMonitor rect) {
        return Win32DPIUtils.pixelToPoint(rect, DPIUtil.getDeviceZoom());
    }

    @Override
    public Point translateFromDisplayCoordinates(Point point) {
        return Win32DPIUtils.pixelToPointAsLocation(point, DPIUtil.getDeviceZoom());
    }

    @Override
    public Point translateToDisplayCoordinates(Point point) {
        return Win32DPIUtils.pointToPixelAsLocation(point, DPIUtil.getDeviceZoom());
    }

    @Override
    public Rectangle translateFromDisplayCoordinates(Rectangle rect) {
        return Win32DPIUtils.pixelToPoint(rect, DPIUtil.getDeviceZoom());
    }

    @Override
    public Rectangle translateToDisplayCoordinates(Rectangle rect) {
        return Win32DPIUtils.pointToPixel(rect, DPIUtil.getDeviceZoom());
    }

    @Override
    public Point getCursorLocation() {
        int zoom = DPIUtil.getDeviceZoom();
        Point cursorLocationInPixels = this.display.getCursorLocationInPixels();
        return Win32DPIUtils.pixelToPointAsLocation(cursorLocationInPixels, zoom);
    }

    @Override
    public void setCursorLocation(int x, int y) {
        int zoom = DPIUtil.getDeviceZoom();
        this.display.setCursorLocationInPixels(DPIUtil.pointToPixel(x, zoom), DPIUtil.pointToPixel(y, zoom));
    }

    @Override
    public Rectangle getContainingMonitorBoundsInPixels(Point point) {
        int zoom = DPIUtil.getDeviceZoom();
        point = Win32DPIUtils.pointToPixelAsLocation(point, zoom);
        Monitor[] monitorArray = this.display.getMonitors();
        int n = monitorArray.length;
        int n2 = 0;
        while (n2 < n) {
            Monitor monitor = monitorArray[n2];
            Rectangle monitorBounds = Win32DPIUtils.pointToPixel(monitor.getBounds(), zoom);
            if (monitorBounds.contains(point)) {
                return monitorBounds;
            }
            ++n2;
        }
        return null;
    }
}

