/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.views.properties;

import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.IPropertySourceProvider;

public class PropertyEditingSupport
extends EditingSupport {
    protected IPropertySourceProvider propertySourceProvider;
    protected Object propertyID;

    public PropertyEditingSupport(ColumnViewer viewer, IPropertySourceProvider propertySourceProvider, Object propertyID) {
        super(viewer);
        this.propertySourceProvider = propertySourceProvider;
        this.propertyID = propertyID;
    }

    protected boolean canEdit(Object object) {
        IPropertyDescriptor[] propertyDescriptors;
        IPropertySource propertySource = this.propertySourceProvider.getPropertySource(object);
        IPropertyDescriptor[] iPropertyDescriptorArray = propertyDescriptors = propertySource.getPropertyDescriptors();
        int n = propertyDescriptors.length;
        int n2 = 0;
        while (n2 < n) {
            IPropertyDescriptor propertyDescriptor = iPropertyDescriptorArray[n2];
            if (this.propertyID.equals(propertyDescriptor.getId())) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    protected CellEditor getCellEditor(Object object) {
        IPropertyDescriptor[] propertyDescriptors;
        IPropertySource propertySource = this.propertySourceProvider.getPropertySource(object);
        IPropertyDescriptor[] iPropertyDescriptorArray = propertyDescriptors = propertySource.getPropertyDescriptors();
        int n = propertyDescriptors.length;
        int n2 = 0;
        while (n2 < n) {
            IPropertyDescriptor propertyDescriptor = iPropertyDescriptorArray[n2];
            if (this.propertyID.equals(propertyDescriptor.getId())) {
                return propertyDescriptor.createPropertyEditor((Composite)this.getViewer().getControl());
            }
            ++n2;
        }
        return null;
    }

    protected Object getValue(Object object) {
        IPropertySource propertySource = this.propertySourceProvider.getPropertySource(object);
        Object value = propertySource.getPropertyValue(this.propertyID);
        IPropertySource valuePropertySource = this.propertySourceProvider.getPropertySource(value);
        if (valuePropertySource != null) {
            value = valuePropertySource.getEditableValue();
        }
        return value;
    }

    protected void setValue(Object object, Object value) {
        IPropertySource propertySource = this.propertySourceProvider.getPropertySource(object);
        propertySource.setPropertyValue(this.propertyID, value);
    }
}

