/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lic.api.tests.conditions;

import org.eclipse.passage.lic.api.conditions.MatchingRule;
import org.junit.Assert;
import org.junit.Test;

public abstract class MatchingRuleContractTest {
    @Test
    public final void absolutelyEqualVersionsMatch() {
        String version = "1.23.456";
        Assert.assertTrue((boolean)this.rule().match(new String(version), new String(version)));
    }

    @Test
    public final void absolutelyEqualNotVersionsMatch() {
        String cadabra = "some strange 59t#.iQo/ing";
        Assert.assertTrue((boolean)this.rule().match(new String(cadabra), new String(cadabra)));
    }

    @Test
    public final void defaultVersionsMatch() {
        String version = "0.0.0";
        Assert.assertTrue((boolean)this.rule().match(version, version));
    }

    @Test
    public final void matchingIsDeterministic() {
        boolean second;
        String required = "1.23.456";
        String allowed = "1.23.0";
        boolean first = this.rule().match(required, allowed);
        Assert.assertTrue((first == (second = this.rule().match(required, allowed)) ? 1 : 0) != 0);
    }

    @Test
    public final void matchingIsIdempotant() {
        boolean second;
        String required = "1.23.456";
        String allowed = "1.23.0";
        MatchingRule rule = this.rule();
        boolean first = rule.match(required, allowed);
        Assert.assertTrue((first == (second = rule.match(required, allowed)) ? 1 : 0) != 0);
    }

    @Test
    public final void allInstancesAreEqual() {
        Assert.assertEquals((Object)this.rule(), (Object)this.rule());
    }

    @Test
    public final void stateless() {
        MatchingRule rule = this.rule();
        rule.match("1.23.456", "stearing wheel");
        Assert.assertEquals((Object)this.rule(), (Object)rule);
    }

    protected abstract MatchingRule rule();
}

