/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor;

import java.util.ResourceBundle;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.IVerticalRulerInfo;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IPostSelectionProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.pde.core.IBaseModel;
import org.eclipse.pde.internal.core.text.AbstractEditingModel;
import org.eclipse.pde.internal.core.text.IDocumentAttributeNode;
import org.eclipse.pde.internal.core.text.IDocumentElementNode;
import org.eclipse.pde.internal.core.text.IDocumentRange;
import org.eclipse.pde.internal.core.text.IDocumentTextNode;
import org.eclipse.pde.internal.core.text.IEditingModel;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEPluginImages;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.editor.ISortableContentOutlinePage;
import org.eclipse.pde.internal.ui.editor.PDEFormEditor;
import org.eclipse.pde.internal.ui.editor.PDEFormEditorContributor;
import org.eclipse.pde.internal.ui.editor.PDEFormTextEditorContributor;
import org.eclipse.pde.internal.ui.editor.SourceOutlinePage;
import org.eclipse.pde.internal.ui.editor.actions.FormatAction;
import org.eclipse.pde.internal.ui.editor.actions.HyperlinkAction;
import org.eclipse.pde.internal.ui.editor.context.InputContext;
import org.eclipse.pde.internal.ui.editor.outline.IOutlineContentCreator;
import org.eclipse.pde.internal.ui.editor.outline.IOutlineSelectionHandler;
import org.eclipse.pde.internal.ui.editor.plugin.ExtensionHyperLink;
import org.eclipse.pde.internal.ui.editor.text.PDESelectAnnotationRulerAction;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.IFormPage;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.ide.IGotoMarker;
import org.eclipse.ui.internal.genericeditor.ExtensionBasedTextEditor;
import org.eclipse.ui.part.IShowInTargetList;
import org.eclipse.ui.texteditor.ChainedPreferenceStore;
import org.eclipse.ui.texteditor.DefaultRangeIndicator;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.TextOperationAction;

public abstract class PDESourcePage
extends ExtensionBasedTextEditor
implements IFormPage,
IGotoMarker,
ISelectionChangedListener,
IOutlineContentCreator,
IOutlineSelectionHandler {
    private static String RES_BUNDLE_LOCATION = "org.eclipse.pde.internal.ui.editor.text.ConstructedPDEEditorMessages";
    private static ResourceBundle fgBundleForConstructedKeys = ResourceBundle.getBundle(RES_BUNDLE_LOCATION);
    private PDESourcePageChangedListener fEditorSelectionChangedListener;
    private PDEFormEditor fEditor;
    private Control fControl;
    private int fIndex;
    private final String fId;
    private InputContext fInputContext;
    private ISortableContentOutlinePage fOutlinePage;
    private ISelectionChangedListener fOutlineSelectionChangedListener;
    private Object fSelection;

    public static ResourceBundle getBundleForConstructedKeys() {
        return fgBundleForConstructedKeys;
    }

    protected void initializeKeyBindingScopes() {
        this.setKeyBindingScopes(new String[]{"org.eclipse.pde.ui.pdeEditorContext"});
    }

    public PDESourcePage(PDEFormEditor editor, String id, String title) {
        this.fId = id;
        this.initialize(editor);
        IPreferenceStore[] stores = new IPreferenceStore[]{PDEPlugin.getDefault().getPreferenceStore(), EditorsUI.getPreferenceStore()};
        this.setPreferenceStore((IPreferenceStore)new ChainedPreferenceStore(stores));
        this.setRangeIndicator((Annotation)new DefaultRangeIndicator());
        if (this.isSelectionListener()) {
            this.getEditor().getSite().getSelectionProvider().addSelectionChangedListener((ISelectionChangedListener)this);
        }
    }

    public void initialize(FormEditor editor) {
        this.fEditor = (PDEFormEditor)editor;
    }

    public void dispose() {
        if (this.fEditorSelectionChangedListener != null) {
            this.fEditorSelectionChangedListener.uninstall(this.getSelectionProvider());
            this.fEditorSelectionChangedListener = null;
        }
        if (this.fOutlinePage != null) {
            this.fOutlinePage.dispose();
            this.fOutlinePage = null;
        }
        if (this.isSelectionListener()) {
            this.getEditor().getSite().getSelectionProvider().removeSelectionChangedListener((ISelectionChangedListener)this);
        }
        super.dispose();
    }

    @Override
    public abstract ILabelProvider createOutlineLabelProvider();

    @Override
    public abstract ITreeContentProvider createOutlineContentProvider();

    @Override
    public abstract ViewerComparator createOutlineComparator();

    @Override
    public void updateSelection(SelectionChangedEvent event) {
        ISelection sel = event.getSelection();
        if (sel instanceof IStructuredSelection) {
            IStructuredSelection structuredSelection = (IStructuredSelection)sel;
            this.updateSelection(structuredSelection.getFirstElement());
        }
    }

    @Override
    public abstract void updateSelection(Object var1);

    @Override
    public ViewerComparator createDefaultOutlineComparator() {
        return null;
    }

    protected ISortableContentOutlinePage createOutlinePage() {
        IBaseModel model = this.getInputContext().getModel();
        if (model instanceof IEditingModel) {
            IEditingModel editModel = (IEditingModel)model;
            SourceOutlinePage sourceOutlinePage = new SourceOutlinePage(this.fEditor, editModel, (IBaseLabelProvider)this.createOutlineLabelProvider(), (IContentProvider)this.createOutlineContentProvider(), this.createDefaultOutlineComparator(), this.createOutlineComparator());
            this.fOutlinePage = sourceOutlinePage;
            this.fOutlineSelectionChangedListener = this::updateSelection;
            this.fOutlinePage.addSelectionChangedListener(this.fOutlineSelectionChangedListener);
            this.getSelectionProvider().addSelectionChangedListener((ISelectionChangedListener)sourceOutlinePage);
            this.fEditorSelectionChangedListener = new PDESourcePageChangedListener();
            this.fEditorSelectionChangedListener.install(this.getSelectionProvider());
        }
        return this.fOutlinePage;
    }

    @Override
    public ISortableContentOutlinePage getContentOutline() {
        if (this.fOutlinePage == null) {
            this.fOutlinePage = this.createOutlinePage();
        }
        return this.fOutlinePage;
    }

    public FormEditor getEditor() {
        return this.fEditor;
    }

    public IManagedForm getManagedForm() {
        return null;
    }

    protected void firePropertyChange(int type) {
        if (type == 257) {
            this.fEditor.fireSaveNeeded(this.getEditorInput(), true);
        }
        super.firePropertyChange(type);
    }

    public void setActive(boolean active) {
        this.fInputContext.setSourceEditingMode(active);
        if (active) {
            this.updateTextSelection();
        }
    }

    public boolean canLeaveThePage() {
        return true;
    }

    public boolean isActive() {
        return this.equals(this.fEditor.getActivePageInstance());
    }

    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        Control[] children = parent.getChildren();
        this.fControl = children[children.length - 1];
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.fControl, "org.eclipse.pde.doc.user.manifest_source_page");
    }

    public Control getPartControl() {
        return this.fControl;
    }

    public String getId() {
        return this.fId;
    }

    public int getIndex() {
        return this.fIndex;
    }

    public void setIndex(int index) {
        this.fIndex = index;
    }

    public boolean isEditor() {
        return true;
    }

    public InputContext getInputContext() {
        return this.fInputContext;
    }

    public void setInputContext(InputContext inputContext) {
        this.fInputContext = inputContext;
        this.setDocumentProvider(inputContext.getDocumentProvider());
    }

    public boolean selectReveal(Object object) {
        if (object instanceof IMarker) {
            IDE.gotoMarker((IEditorPart)this, (IMarker)((IMarker)object));
            return true;
        }
        return false;
    }

    public IDocumentRange getRangeElement(int offset, boolean searchChildren) {
        return null;
    }

    public void setHighlightRange(IDocumentRange range, boolean moveCursor) {
        int offset = range.getOffset();
        if (offset == -1) {
            this.resetHighlightRange();
            return;
        }
        ISourceViewer sourceViewer = this.getSourceViewer();
        if (sourceViewer == null) {
            return;
        }
        IDocument document = sourceViewer.getDocument();
        if (document == null) {
            return;
        }
        int length = range.getLength();
        this.setHighlightRange(offset, length == -1 ? 1 : length, moveCursor);
    }

    public void setSelectedRange(IDocumentRange range, boolean fullNodeSelection) {
        int offset;
        int length;
        ISourceViewer sourceViewer = this.getSourceViewer();
        if (sourceViewer == null) {
            return;
        }
        IDocument document = sourceViewer.getDocument();
        if (document == null) {
            return;
        }
        if (range instanceof IDocumentElementNode && !fullNodeSelection) {
            length = ((IDocumentElementNode)range).getXMLTagName().length();
            offset = range.getOffset() + 1;
        } else {
            length = range.getLength();
            offset = range.getOffset();
        }
        sourceViewer.setSelectedRange(offset, length);
    }

    public int getOrientation() {
        return 0x2000000;
    }

    protected void createActions() {
        PDEFormEditorContributor contributor;
        super.createActions();
        PDESelectAnnotationRulerAction action = new PDESelectAnnotationRulerAction(PDESourcePage.getBundleForConstructedKeys(), "PDESelectAnnotationRulerAction.", (ITextEditor)this, (IVerticalRulerInfo)this.getVerticalRuler());
        this.setAction("RulerClick", (IAction)action);
        PDEFormEditorContributor pDEFormEditorContributor = contributor = this.fEditor == null ? null : this.fEditor.getContributor();
        if (contributor instanceof PDEFormTextEditorContributor) {
            PDEFormTextEditorContributor textContributor = (PDEFormTextEditorContributor)contributor;
            this.setAction("org.eclipse.pde.ui.actions.Open", (IAction)textContributor.getHyperlinkAction());
            this.setAction("org.eclipse.pde.ui.actions.Format", (IAction)textContributor.getFormatAction());
        }
        this.createQuickOutlineAction();
    }

    private void createQuickOutlineAction() {
        TextOperationAction action = new TextOperationAction(PDESourcePage.getBundleForConstructedKeys(), "QuickOutline.", (ITextEditor)this, 513, true);
        action.setActionDefinitionId("org.eclipse.pde.ui.quickOutline");
        action.setText(PDEUIMessages.PDESourcePage_actionTextQuickOutline);
        action.setId("org.eclipse.pde.ui.quickOutline");
        action.setImageDescriptor(PDEPluginImages.DESC_OVERVIEW_OBJ);
        this.setAction("org.eclipse.pde.ui.quickOutline", (IAction)action);
    }

    public final void selectionChanged(SelectionChangedEvent event) {
        if (event.getSource() == this.getSelectionProvider()) {
            return;
        }
        ISelection sel = event.getSelection();
        if (sel instanceof IStructuredSelection) {
            IStructuredSelection structuredSel = (IStructuredSelection)sel;
            this.setSelectedObject(structuredSel.getFirstElement());
        } else if (sel instanceof ITextSelection) {
            ITextSelection textSel = (ITextSelection)sel;
            this.setSelectedObject(this.getRangeElement(textSel.getOffset(), false));
        } else {
            this.fSelection = null;
        }
    }

    protected IDocumentRange findRange() {
        return null;
    }

    public void updateTextSelection() {
        IDocumentRange range = this.findRange();
        if (range == null) {
            return;
        }
        IBaseModel model = this.getInputContext().getModel();
        if (!(model instanceof AbstractEditingModel)) {
            return;
        }
        if (range.getOffset() == -1 || this.isDirty()) {
            try {
                ((AbstractEditingModel)model).adjustOffsets(((AbstractEditingModel)model).getDocument());
            }
            catch (CoreException coreException) {
                // empty catch block
            }
            range = this.findRange();
        }
        this.setHighlightRange(range, true);
        this.setSelectedRange(range, false);
    }

    protected boolean isSelectionListener() {
        return false;
    }

    public ISourceViewer getViewer() {
        return this.getSourceViewer();
    }

    protected void editorContextMenuAboutToShow(IMenuManager menu) {
        PDEFormEditorContributor contributor;
        PDEFormEditorContributor pDEFormEditorContributor = contributor = this.fEditor == null ? null : this.fEditor.getContributor();
        if (contributor instanceof PDEFormTextEditorContributor) {
            PDEFormTextEditorContributor textContributor = (PDEFormTextEditorContributor)contributor;
            HyperlinkAction action = textContributor.getHyperlinkAction();
            if (action != null && action.isEnabled() && !(action.getHyperLink() instanceof ExtensionHyperLink)) {
                menu.add((IAction)action);
            }
            FormatAction formatManifestAction = textContributor.getFormatAction();
            if (this.isEditable() && formatManifestAction != null && formatManifestAction.isEnabled()) {
                menu.add((IAction)formatManifestAction);
            }
        }
        super.editorContextMenuAboutToShow(menu);
    }

    public Object getSelection() {
        return this.fSelection;
    }

    protected void setSelectedObject(Object selectedObject) {
        this.fSelection = selectedObject;
    }

    @Override
    public Object getOutlineInput() {
        return this.getInputContext().getModel();
    }

    protected void updateOutlinePageSelection(Object rangeElement) {
        if (PDEPlugin.getDefault().getPreferenceStore().getBoolean("ToggleLinkWithEditorAction.isChecked")) {
            if (!(this.fOutlinePage instanceof SourceOutlinePage)) {
                return;
            }
            SourceOutlinePage outlinePage = (SourceOutlinePage)this.fOutlinePage;
            outlinePage.removeAllSelectionChangedListeners();
            if (rangeElement != null) {
                outlinePage.setSelection((ISelection)new StructuredSelection(rangeElement));
            } else {
                outlinePage.setSelection((ISelection)StructuredSelection.EMPTY);
            }
            outlinePage.addAllSelectionChangedListeners();
        }
    }

    protected void handleSelectionChangedSourcePage(SelectionChangedEvent event) {
        ISelection selection = event.getSelection();
        if (!selection.isEmpty() && selection instanceof ITextSelection) {
            ITextSelection textSel = (ITextSelection)selection;
            int offset = textSel.getOffset();
            IDocumentRange rangeElement = this.getRangeElement(offset, false);
            this.setSelectedObject(rangeElement);
            this.synchronizeOutlinePage(rangeElement);
        }
    }

    protected void updateHighlightRange(IDocumentRange rangeElement) {
        if (rangeElement != null) {
            this.setHighlightRange(rangeElement, false);
        } else {
            this.resetHighlightRange();
        }
    }

    protected void synchronizeOutlinePage(int offset) {
        IDocumentRange rangeElement = this.getRangeElement(offset, false);
        this.synchronizeOutlinePage(rangeElement);
    }

    private void synchronizeOutlinePage(IDocumentRange rangeElement) {
        this.updateHighlightRange(rangeElement);
        this.updateOutlinePageSelection(rangeElement);
    }

    public void synchronizeOutlinePage() {
        int current_offset = this.getSourceViewer().getSelectedRange().x;
        this.synchronizeOutlinePage(current_offset);
    }

    protected IDocumentRange findNode(IDocumentElementNode node, int offset, boolean searchChildren) {
        return this.findNode(new Object[]{node}, offset, searchChildren);
    }

    protected IDocumentRange findNode(Object[] nodes, int offset, boolean searchChildren) {
        Object[] objectArray = nodes;
        int n = nodes.length;
        int n2 = 0;
        while (n2 < n) {
            Object nodeObject = objectArray[n2];
            IDocumentElementNode node = (IDocumentElementNode)nodeObject;
            if (node.getOffset() <= offset && offset < node.getOffset() + node.getLength()) {
                IDocumentTextNode textNode;
                if (!searchChildren) {
                    return node;
                }
                if (node.getOffset() < offset && offset <= node.getOffset() + node.getXMLTagName().length() + 1) {
                    return node;
                }
                IDocumentAttributeNode[] attrs = node.getNodeAttributes();
                if (attrs != null) {
                    IDocumentAttributeNode[] iDocumentAttributeNodeArray = attrs;
                    int n3 = attrs.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IDocumentAttributeNode attr = iDocumentAttributeNodeArray[n4];
                        if (attr.getNameOffset() <= offset && offset <= attr.getValueOffset() + attr.getValueLength()) {
                            return attr;
                        }
                        ++n4;
                    }
                }
                if ((textNode = node.getTextNode()) != null && textNode.getOffset() <= offset && offset < textNode.getOffset() + textNode.getLength()) {
                    return textNode;
                }
                IDocumentElementNode[] children = node.getChildNodes();
                if (children != null) {
                    IDocumentElementNode[] iDocumentElementNodeArray = children;
                    int n5 = children.length;
                    int n6 = 0;
                    while (n6 < n5) {
                        IDocumentElementNode child = iDocumentElementNodeArray[n6];
                        if (child.getOffset() <= offset && offset < child.getOffset() + child.getLength()) {
                            return this.findNode(child, offset, searchChildren);
                        }
                        ++n6;
                    }
                }
                return node;
            }
            ++n2;
        }
        return null;
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (adapter == IShowInTargetList.class && this.fEditor != null && this.fEditor.getEditorInput() instanceof IFileEditorInput) {
            return (T)this.getShowInTargetList();
        }
        return (T)super.getAdapter(adapter);
    }

    protected IShowInTargetList getShowInTargetList() {
        return () -> new String[]{"org.eclipse.jdt.ui.PackageExplorer", "org.eclipse.ui.navigator.ProjectExplorer"};
    }

    public IDocumentRange adaptRange(IDocumentRange range) {
        return range;
    }

    protected void initializeEditor() {
        super.initializeEditor();
    }

    private class PDESourcePageChangedListener
    implements ISelectionChangedListener {
        private PDESourcePageChangedListener() {
        }

        public void install(ISelectionProvider selectionProvider) {
            if (selectionProvider != null) {
                if (selectionProvider instanceof IPostSelectionProvider) {
                    IPostSelectionProvider provider = (IPostSelectionProvider)selectionProvider;
                    provider.addPostSelectionChangedListener((ISelectionChangedListener)this);
                } else {
                    selectionProvider.addSelectionChangedListener((ISelectionChangedListener)this);
                }
            }
        }

        public void selectionChanged(SelectionChangedEvent event) {
            PDESourcePage.this.handleSelectionChangedSourcePage(event);
        }

        public void uninstall(ISelectionProvider selectionProvider) {
            if (selectionProvider != null) {
                if (selectionProvider instanceof IPostSelectionProvider) {
                    IPostSelectionProvider provider = (IPostSelectionProvider)selectionProvider;
                    provider.removePostSelectionChangedListener((ISelectionChangedListener)this);
                } else {
                    selectionProvider.removeSelectionChangedListener((ISelectionChangedListener)this);
                }
            }
        }
    }
}

