/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.ecl.operations.internal.commands;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.rcptt.ecl.core.Command;
import org.eclipse.rcptt.ecl.core.EclList;
import org.eclipse.rcptt.ecl.core.Get;
import org.eclipse.rcptt.ecl.dispatch.IScriptletExtension;
import org.eclipse.rcptt.ecl.operations.internal.OperationsPlugin;
import org.eclipse.rcptt.ecl.runtime.BoxedValues;
import org.eclipse.rcptt.ecl.runtime.IProcess;

public class GetFromListService
implements IScriptletExtension {
    public IStatus service(Command command, IProcess context) throws InterruptedException, CoreException {
        Get get = (Get)command;
        EclList list = (EclList)get.getInput();
        Object indexObject = BoxedValues.unbox((Object)get.getKey());
        if (!(indexObject instanceof Integer)) {
            return OperationsPlugin.createErr("Invalid key: %s. Only integers can be used to get values from lists", indexObject);
        }
        int index = (Integer)indexObject;
        if (index < 0 || index >= list.getElements().size()) {
            if (get.getDefault() == null) {
                return OperationsPlugin.createErr("Index %d is out of bounds and no default value given", index);
            }
            context.getOutput().write((Object)get.getDefault());
            return Status.OK_STATUS;
        }
        context.getOutput().write((Object)EcoreUtil.copy((EObject)((EObject)list.getElements().get(index))));
        return Status.OK_STATUS;
    }

    public boolean canHandle(Command c) {
        return c instanceof Get && ((Get)c).getInput() instanceof EclList;
    }
}

