/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core.product;

import java.io.PrintWriter;
import org.eclipse.pde.internal.core.iproduct.IConfigurationProperty;
import org.eclipse.pde.internal.core.iproduct.IProductModel;
import org.eclipse.pde.internal.core.product.ProductObject;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ConfigurationProperty
extends ProductObject
implements IConfigurationProperty {
    private static final long serialVersionUID = -3549668957352554826L;
    private String fName;
    private String fValue;
    private String fOS;
    private String fArch;

    ConfigurationProperty(IProductModel model) {
        super(model);
    }

    @Override
    public void parse(Node node) {
        if (node.getNodeType() == 1) {
            Element element = (Element)node;
            this.fName = element.getAttribute("name");
            this.fValue = element.getAttribute("value");
            this.fOS = element.getAttribute("os");
            this.fArch = element.getAttribute("arch");
        }
    }

    @Override
    public void write(String indent, PrintWriter writer) {
        writer.print(indent + "<property name=\"" + this.fName + "\"");
        writer.print(" value=\"" + this.fValue + "\"");
        if (this.fOS.length() > 0) {
            writer.print(" os=\"" + this.fOS + "\"");
        }
        if (this.fArch.length() > 0) {
            writer.print(" arch=\"" + this.fArch + "\"");
        }
        writer.println(" />");
    }

    @Override
    public String getName() {
        return this.fName;
    }

    @Override
    public String getValue() {
        return this.fValue;
    }

    @Override
    public void setName(String name) {
        String oldValue = this.fName;
        this.fName = name;
        if (this.isEditable() && !this.fName.equals(oldValue)) {
            this.firePropertyChanged("name", oldValue, this.fName);
        }
    }

    @Override
    public void setValue(String value) {
        String oldValue = this.fValue;
        this.fValue = value;
        if (this.isEditable() && !this.fValue.equals(oldValue)) {
            this.firePropertyChanged("value", oldValue, this.fValue);
        }
    }

    public String toString() {
        return this.fName + " : " + this.fValue;
    }

    @Override
    public String getOs() {
        return this.fOS;
    }

    @Override
    public void setOs(String os) {
        String oldValue = this.fOS;
        this.fOS = os;
        if (this.isEditable() && !this.fOS.equals(oldValue)) {
            this.firePropertyChanged("os", oldValue, this.fOS);
        }
    }

    @Override
    public String getArch() {
        return this.fArch;
    }

    @Override
    public void setArch(String arch) {
        String oldValue = this.fArch;
        this.fArch = arch;
        if (this.isEditable() && !this.fArch.equals(oldValue)) {
            this.firePropertyChanged("arch", oldValue, this.fArch);
        }
    }
}

