/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.tesla.jface;

import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.Adapters;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.rcptt.tesla.jface.JFaceAspectsActivator;
import org.eclipse.rcptt.util.ReflectionUtil;
import org.eclipse.swt.program.Program;
import org.eclipse.ui.internal.misc.ExternalProgramImageDescriptor;
import org.osgi.framework.Bundle;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum DescriptorInfo {
    EXTERNAL_PROGRAM_ADAPTER{

        @Override
        String extract(ImageDescriptor descriptor) {
            Program p = (Program)Adapters.adapt((Object)descriptor, Program.class, (boolean)false);
            return DescriptorInfo.extractFromProgram(p);
        }
    }
    ,
    BUNDLE_URL{
        private final Pattern pattern = Pattern.compile("URLImageDescriptor\\(((bundleentry|bundleresource).*)\\)");

        @Override
        String extract(ImageDescriptor descriptor) {
            Matcher matcher = this.pattern.matcher(descriptor.toString());
            if (!matcher.matches()) {
                return null;
            }
            String uriStr = matcher.group(1);
            URI bundleUri = null;
            try {
                bundleUri = new URI(uriStr);
            }
            catch (URISyntaxException e) {
                return "InvalidUri(" + uriStr + ")";
            }
            return DescriptorInfo.extractFromUri(bundleUri);
        }
    }
    ,
    ABSOLUTE_URL{
        private final Pattern pattern = Pattern.compile("URLImageDescriptor\\((file:/|platform:/plugin/)(.*)\\)");

        @Override
        String extract(ImageDescriptor descriptor) {
            Matcher matcher = this.pattern.matcher(descriptor.toString());
            if (matcher.matches()) {
                return matcher.group(2);
            }
            return null;
        }
    }
    ,
    FILE_CLASS{
        private final Pattern pattern = Pattern.compile("FileImageDescriptor\\(location=class (.*), name=(.*)\\)");

        @Override
        String extract(ImageDescriptor descriptor) {
            Matcher matcher = this.pattern.matcher(descriptor.toString());
            if (matcher.matches()) {
                return String.format("%s%s", matcher.group(1), matcher.group(2));
            }
            return null;
        }
    }
    ,
    URL_ADAPTER{

        @Override
        String extract(ImageDescriptor descriptor) {
            URL url = (URL)Adapters.adapt((Object)descriptor, URL.class, (boolean)false);
            if (url != null) {
                try {
                    return DescriptorInfo.extractFromUri(url.toURI());
                }
                catch (URISyntaxException e) {
                    JFaceAspectsActivator.log(e);
                    return null;
                }
            }
            return null;
        }
    }
    ,
    EXTERNAL_PROGRAM{

        @Override
        String extract(ImageDescriptor descriptor) {
            if (descriptor instanceof ExternalProgramImageDescriptor) {
                try {
                    return DescriptorInfo.extractFromProgram((Program)ReflectionUtil.getField((Object)descriptor, (String)"program", (boolean)true));
                }
                catch (IllegalAccessException | NoSuchFieldException e) {
                    JFaceAspectsActivator.log(e);
                    return null;
                }
            }
            return null;
        }
    };

    private static final boolean isWindows;

    static {
        isWindows = Platform.getOS().equals("win32");
    }

    public static String getInfo(ImageDescriptor descriptor) {
        DescriptorInfo[] descriptorInfoArray = DescriptorInfo.values();
        int n = descriptorInfoArray.length;
        int n2 = 0;
        while (n2 < n) {
            DescriptorInfo i = descriptorInfoArray[n2];
            String info = i.extract(descriptor);
            if (info != null) {
                return info;
            }
            ++n2;
        }
        return null;
    }

    abstract String extract(ImageDescriptor var1);

    private static String extractFromProgram(Program p) {
        if (p == null) {
            return null;
        }
        try {
            if (isWindows) {
                String extension = (String)ReflectionUtil.getField((Object)p, (String)"extension", (boolean)true);
                if (extension != null && !extension.isEmpty()) {
                    return extension;
                }
                String iconName = (String)ReflectionUtil.getField((Object)p, (String)"iconName", (boolean)true);
                if (iconName != null && !iconName.isEmpty()) {
                    return iconName;
                }
            }
        }
        catch (IllegalArgumentException e) {
            JFaceAspectsActivator.log(e);
        }
        catch (IllegalAccessException e) {
            JFaceAspectsActivator.log(e);
        }
        catch (NoSuchFieldException e) {
            JFaceAspectsActivator.log(e);
        }
        catch (SecurityException e) {
            JFaceAspectsActivator.log(e);
        }
        return p.getName().isEmpty() ? null : p.getName();
    }

    private static String extractFromUri(URI bundleUri) {
        String host = bundleUri.getHost();
        if (host == null) {
            return null;
        }
        int bundleIdEndIndex = host.indexOf(".fwk");
        if (bundleIdEndIndex == -1) {
            return "UnknownBundleId(" + String.valueOf(bundleUri) + ")";
        }
        int bundleId = -1;
        try {
            bundleId = Integer.parseInt(host.substring(0, bundleIdEndIndex));
        }
        catch (NumberFormatException e) {
            return "UnknownBundleId(" + String.valueOf(bundleUri) + ")";
        }
        Bundle imageBundle = JFaceAspectsActivator.getDefault().getBundle().getBundleContext().getBundle((long)bundleId);
        String bundleName = imageBundle == null ? "unknownBundle" : imageBundle.getSymbolicName();
        return String.format("%s%s", bundleName, bundleUri.getPath());
    }
}

