/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.ctx.preferences.impl;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Field;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.internal.runtime.InternalPlatform;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jface.dialogs.DialogSettings;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.rcptt.ctx.preferences.impl.Activator;
import org.eclipse.rcptt.internal.preferences.PrefUtils;
import org.eclipse.rcptt.preferences.ListPrefData;
import org.eclipse.rcptt.preferences.PrefData;
import org.eclipse.rcptt.preferences.PrefNode;
import org.eclipse.rcptt.preferences.PreferencesFactory;
import org.eclipse.rcptt.preferences.StringPrefData;
import org.eclipse.rcptt.runtime.ui.preferences.DialogSettingsManager;
import org.osgi.framework.Bundle;

public final class DialogSettingsUtils {
    private static final String FN_DIALOG_SETTINGS = "dialog_settings.xml";

    private DialogSettingsUtils() {
    }

    public static void applyDialogSettings(Bundle bundle, PrefNode prefNode) throws IOException {
        IDialogSettings settings = DialogSettingsUtils.getDialogSettings(bundle);
        if (settings != null) {
            DialogSettingsUtils.applyPrefData(prefNode, settings);
            EList nodes = prefNode.getChilds();
            for (PrefNode node : nodes) {
                DialogSettingsUtils.applyDialogSettings(settings, node);
            }
            if (bundle.getState() != 32 || DialogSettingsManager.getInstance().getSettings(bundle) == null) {
                DialogSettingsUtils.saveDialogSettings(bundle, settings);
            }
        }
    }

    public static PrefNode collectDialogSettings(Bundle bundle) throws IOException {
        IDialogSettings settings = DialogSettingsUtils.getDialogSettings(bundle);
        if (settings != null) {
            return DialogSettingsUtils.convertDialogSettings(settings);
        }
        return null;
    }

    private static void applyDialogSettings(IDialogSettings parentSettings, PrefNode prefNode) {
        IDialogSettings settings = parentSettings.getSection(prefNode.getName());
        if (settings == null) {
            settings = parentSettings.addNewSection(prefNode.getName());
        }
        DialogSettingsUtils.applyPrefData(prefNode, settings);
        for (PrefNode child : prefNode.getChilds()) {
            DialogSettingsUtils.applyDialogSettings(settings, child);
        }
    }

    private static void applyPrefData(PrefNode node, IDialogSettings settings) {
        for (PrefData data : node.getData()) {
            if (data instanceof StringPrefData) {
                StringPrefData stringData = (StringPrefData)data;
                PrefUtils.decodeWorkspaceLocation((StringPrefData)stringData);
                PrefUtils.substituteVariables((StringPrefData)stringData);
                settings.put(stringData.getKey(), stringData.getValue());
                continue;
            }
            if (!(data instanceof ListPrefData)) continue;
            ListPrefData listData = (ListPrefData)data;
            EList valuesList = listData.getValues();
            String[] values = (String[])valuesList.toArray((Object[])new String[valuesList.size()]);
            int i = 0;
            while (i < values.length) {
                values[i] = PrefUtils.decodeWorkspaceLocation((String)values[i]);
                values[i] = PrefUtils.substituteVariables((String)values[i]);
                ++i;
            }
            settings.put(listData.getKey(), values);
        }
    }

    private static IDialogSettings getDialogSettings(Bundle bundle) throws IOException {
        IDialogSettings dialogSettings;
        IDialogSettings settings = null;
        if (32 == bundle.getState() && (dialogSettings = DialogSettingsManager.getInstance().getSettings(bundle)) != null) {
            settings = dialogSettings;
        }
        if (settings == null) {
            settings = DialogSettingsUtils.loadDialogSettings(bundle);
        }
        return settings;
    }

    private static PrefNode convertDialogSettings(IDialogSettings settings) {
        IDialogSettings[] childs;
        ArrayList<PrefNode> childNodes = null;
        ArrayList<Object> data = null;
        IDialogSettings[] iDialogSettingsArray = childs = settings.getSections();
        int n = childs.length;
        int n2 = 0;
        while (n2 < n) {
            IDialogSettings child = iDialogSettingsArray[n2];
            PrefNode childNode = DialogSettingsUtils.convertDialogSettings(child);
            if (childNode != null) {
                if (childNodes == null) {
                    childNodes = new ArrayList<PrefNode>();
                }
                childNodes.add(childNode);
            }
            ++n2;
        }
        Object[] itemKeys = DialogSettingsUtils.getItemKeys(settings);
        Object[] arrayItemKeys = DialogSettingsUtils.getArrayItemKeys(settings);
        if (itemKeys.length > 0 || arrayItemKeys.length > 0) {
            data = new ArrayList<Object>();
            Object[] objectArray = itemKeys;
            int n3 = itemKeys.length;
            int n4 = 0;
            while (n4 < n3) {
                Object key = objectArray[n4];
                String itemKey = (String)key;
                StringPrefData stringData = PreferencesFactory.eINSTANCE.createStringPrefData();
                stringData.setKey(itemKey);
                String value = settings.get(itemKey);
                value = PrefUtils.encodeWorkspaceLocation((String)value);
                stringData.setValue(value);
                data.add(stringData);
                ++n4;
            }
            objectArray = arrayItemKeys;
            n3 = arrayItemKeys.length;
            n4 = 0;
            while (n4 < n3) {
                String[] values;
                Object key = objectArray[n4];
                String arrayItemKey = (String)key;
                ListPrefData listPrefData = PreferencesFactory.eINSTANCE.createListPrefData();
                listPrefData.setKey(arrayItemKey);
                String[] stringArray = values = settings.getArray(arrayItemKey);
                int n5 = values.length;
                int n6 = 0;
                while (n6 < n5) {
                    String value = stringArray[n6];
                    value = PrefUtils.encodeWorkspaceLocation((String)value);
                    listPrefData.getValues().add((Object)value);
                    ++n6;
                }
                data.add(listPrefData);
                ++n4;
            }
        }
        if (childNodes != null || data != null) {
            PrefNode prefNode = PreferencesFactory.eINSTANCE.createPrefNode();
            prefNode.setName(settings.getName());
            if (childNodes != null) {
                prefNode.getChilds().addAll(childNodes);
            }
            if (data != null) {
                prefNode.getData().addAll(data);
            }
            return prefNode;
        }
        return null;
    }

    private static Object[] getItemKeys(IDialogSettings settings) {
        if (settings instanceof DialogSettings) {
            Map items = (Map)DialogSettingsUtils.getPrivateFieldValue(settings, DialogSettings.class, "items");
            return items.keySet().toArray();
        }
        return new String[0];
    }

    private static Object[] getArrayItemKeys(IDialogSettings settings) {
        if (settings instanceof DialogSettings) {
            Map items = (Map)DialogSettingsUtils.getPrivateFieldValue(settings, DialogSettings.class, "arrayItems");
            return items.keySet().toArray();
        }
        return new String[0];
    }

    private static Object getPrivateFieldValue(Object object, Class<?> targetClass, String fieldName) {
        try {
            Field field = targetClass.getDeclaredField(fieldName);
            field.setAccessible(true);
            return field.get(object);
        }
        catch (NoSuchFieldException e) {
            Activator.log(e);
        }
        catch (IllegalAccessException e) {
            Activator.log(e);
        }
        return null;
    }

    private static IDialogSettings loadDialogSettings(Bundle bundle) throws IOException {
        String readWritePath;
        File settingsFile;
        IPath dataLocation = DialogSettingsUtils.getStateLocationOrNull(bundle);
        if (dataLocation != null && (settingsFile = new File(readWritePath = dataLocation.append(FN_DIALOG_SETTINGS).toOSString())).exists()) {
            try {
                DialogSettings settings = new DialogSettings(bundle.getSymbolicName());
                settings.load(readWritePath);
                return settings;
            }
            catch (IOException e) {
                Activator.log(e);
                return new DialogSettings(bundle.getSymbolicName());
            }
        }
        URL dsURL = FileLocator.find((Bundle)bundle, (IPath)new Path(FN_DIALOG_SETTINGS), null);
        if (dsURL == null) {
            return new DialogSettings(bundle.getSymbolicName());
        }
        InputStream is = null;
        try {
            is = dsURL.openStream();
            BufferedReader reader = new BufferedReader(new InputStreamReader(is, "utf-8"));
            DialogSettings settings = new DialogSettings(bundle.getSymbolicName());
            settings.load((Reader)reader);
            DialogSettings dialogSettings = settings;
            return dialogSettings;
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    private static IPath getStateLocationOrNull(Bundle bundle) {
        try {
            return InternalPlatform.getDefault().getStateLocation(bundle, false);
        }
        catch (IllegalStateException e) {
            return null;
        }
    }

    private static void saveDialogSettings(Bundle bundle, IDialogSettings dialogSettings) throws IOException {
        if (dialogSettings == null) {
            return;
        }
        IPath path = DialogSettingsUtils.getStateLocationOrNull(bundle);
        if (path == null) {
            return;
        }
        String readWritePath = path.append(FN_DIALOG_SETTINGS).toOSString();
        File file = path.toFile();
        file.mkdirs();
        dialogSettings.save(readWritePath);
    }

    public static void clearDialogSettings(Bundle bundle) {
        try {
            IPath path;
            IDialogSettings dialogSettings;
            IDialogSettings settings = null;
            if (32 == bundle.getState() && (dialogSettings = DialogSettingsManager.getInstance().getSettings(bundle)) != null) {
                settings = dialogSettings;
            }
            if (settings != null && settings instanceof DialogSettings) {
                DialogSettingsUtils.setDialogSettingsFieldTo(settings, "items");
                DialogSettingsUtils.setDialogSettingsFieldTo(settings, "arrayItems");
                DialogSettingsUtils.setDialogSettingsFieldTo(settings, "sections");
            }
            if ((path = DialogSettingsUtils.getStateLocationOrNull(bundle)) == null) {
                return;
            }
            File readWritePath = path.append(FN_DIALOG_SETTINGS).toFile();
            if (readWritePath.exists()) {
                readWritePath.delete();
            }
        }
        catch (Throwable e) {
            Activator.log(e);
        }
    }

    private static void setDialogSettingsFieldTo(IDialogSettings settings, String name) throws NoSuchFieldException, IllegalAccessException {
        Field field = DialogSettings.class.getDeclaredField(name);
        field.setAccessible(true);
        field.set(settings, new HashMap());
    }
}

