/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.internal.launching.ext;

import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Stream;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationListener;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.rcptt.internal.core.RcpttPlugin;
import org.eclipse.rcptt.internal.launching.ext.PDELocationUtils;
import org.eclipse.rcptt.internal.launching.ext.Q7ExtLaunchingPlugin;
import org.eclipse.rcptt.internal.launching.ext.Q7TargetPlatformInitializer;
import org.eclipse.rcptt.launching.Aut;
import org.eclipse.rcptt.launching.AutListener;
import org.eclipse.rcptt.launching.AutManager;
import org.eclipse.rcptt.launching.target.ITargetPlatformHelper;
import org.eclipse.rcptt.launching.target.TargetPlatformManager;

public class Q7TargetPlatformManager {
    private static Map<String, ITargetPlatformHelper> cachedHelpers = Collections.synchronizedMap(new HashMap());

    static {
        Job.createSystem((String)"Defered initalization of AutManager listeners. AutManager is not initializaed yet.", monitor -> {
            AutManager.INSTANCE.addListener((AutListener)new AutListener.AutAdapter(){

                public void autRemoved(Aut aut) {
                    Q7TargetPlatformManager.delete(aut.getConfig());
                }
            });
            return Status.OK_STATUS;
        }).schedule();
    }

    public static synchronized ITargetPlatformHelper findTarget(ILaunchConfiguration config, IProgressMonitor monitor) throws CoreException {
        String location = config.getAttribute("aut-location", "");
        File loc = new File(location);
        if (!loc.exists()) {
            return null;
        }
        ITargetPlatformHelper cached = Q7TargetPlatformManager.familyOf(config).map(Q7TargetPlatformManager::getTargetPlatformName).map(cachedHelpers::get).filter(Objects::nonNull).findFirst().orElse(null);
        if (cached != null) {
            return cached;
        }
        cached = Q7TargetPlatformManager.familyOf(config).map(Q7TargetPlatformManager::getTargetPlatformName).map(name -> TargetPlatformManager.findTarget(name, monitor)).filter(Objects::nonNull).peek(tp -> {
            boolean bl = tp.getStatus().isOK();
        }).findFirst().orElse(null);
        IProgressMonitor.done((IProgressMonitor)monitor);
        cachedHelpers.put(Q7TargetPlatformManager.getTargetPlatformName(config), cached);
        return cached;
    }

    public static synchronized ITargetPlatformHelper getTarget(ILaunchConfiguration config, IProgressMonitor monitor) throws CoreException {
        SubMonitor sm = SubMonitor.convert((IProgressMonitor)monitor, (String)"Initialize target platform...", (int)3);
        String location = config.getAttribute("aut-location", "");
        if (!PDELocationUtils.validateProductLocation(location).isOK()) {
            return Q7TargetPlatformManager.newTargetPlatform((IProgressMonitor)sm.split(1), location);
        }
        ITargetPlatformHelper result = Q7TargetPlatformManager.findTarget(config, (IProgressMonitor)sm.split(1));
        if (result != null) {
            return result;
        }
        ITargetPlatformHelper info = Q7TargetPlatformManager.newTargetPlatform((IProgressMonitor)sm.split(1), location);
        assert (Q7TargetPlatformManager.findTarget(config, (IProgressMonitor)sm.split(1)) == info);
        IProgressMonitor.done((IProgressMonitor)monitor);
        return info;
    }

    private static synchronized ITargetPlatformHelper newTargetPlatform(IProgressMonitor monitor, String location) throws CoreException {
        ITargetPlatformHelper info = Q7TargetPlatformManager.createTargetPlatform(location, monitor);
        assert (info != null);
        info.save();
        return info;
    }

    private static void throwOnError(IStatus status) throws CoreException {
        if (status.matches(4)) {
            throw new CoreException(status);
        }
        if (!status.isOK()) {
            Q7ExtLaunchingPlugin.log(status);
        }
    }

    public static synchronized ITargetPlatformHelper createTargetPlatform(String location, IProgressMonitor monitor) throws CoreException {
        boolean isOk = false;
        ITargetPlatformHelper platform = null;
        try {
            SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)"Create AUT configuration", (int)100);
            platform = TargetPlatformManager.createTargetPlatform(location, (IProgressMonitor)subMonitor.split(50));
            Q7TargetPlatformManager.throwOnError(platform.getStatus());
            IStatus rv = Q7TargetPlatformInitializer.initialize(platform, (IProgressMonitor)subMonitor.split(50));
            Q7TargetPlatformManager.throwOnError(rv);
            isOk = true;
            ITargetPlatformHelper iTargetPlatformHelper = platform;
            return iTargetPlatformHelper;
        }
        catch (CoreException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.rcptt.launching.ext", "Target platform initialization failed", e));
        }
        finally {
            if (!isOk && platform != null) {
                platform.delete();
            }
            monitor.done();
        }
    }

    private static String getTargetPlatformName(ILaunchConfiguration config) {
        try {
            String name = config.getAttribute("aut-target-platform", null);
            return name;
        }
        catch (CoreException e) {
            RcpttPlugin.log((Throwable)e);
            return null;
        }
    }

    public static synchronized void initialize() {
        DebugPlugin.getDefault().getLaunchManager().addLaunchConfigurationListener(new ILaunchConfigurationListener(){

            public void launchConfigurationRemoved(ILaunchConfiguration configuration) {
                Q7TargetPlatformManager.delete(configuration);
            }

            public void launchConfigurationChanged(ILaunchConfiguration configuration) {
            }

            public void launchConfigurationAdded(ILaunchConfiguration configuration) {
            }
        });
    }

    public static synchronized void setHelper(ILaunchConfigurationWorkingCopy config, ITargetPlatformHelper info) {
        if (info.getName().isEmpty()) {
            throw new IllegalArgumentException("Empty target name");
        }
        config.setAttribute("aut-target-platform", info.getName());
        cachedHelpers.put(info.getName(), info);
    }

    public static synchronized void delete(ILaunchConfiguration configuration) {
        Q7TargetPlatformManager.familyOf(configuration).filter(ILaunchConfiguration::exists).map(Q7TargetPlatformManager::getTargetPlatformName).forEach(Q7TargetPlatformManager::delete);
    }

    private static synchronized void delete(String name) {
        ITargetPlatformHelper helper = cachedHelpers.remove(name);
        if (helper != null) {
            helper.delete();
        }
        TargetPlatformManager.deleteTargetPlatform(name);
    }

    public static synchronized void clear() {
        cachedHelpers.clear();
    }

    private static Stream<ILaunchConfiguration> familyOf(ILaunchConfiguration configuration) {
        Stream<Object> parents = Stream.empty();
        ILaunchConfiguration original = null;
        if (configuration instanceof ILaunchConfigurationWorkingCopy) {
            ILaunchConfigurationWorkingCopy wc = (ILaunchConfigurationWorkingCopy)configuration;
            parents = Stream.iterate(wc, Objects::nonNull, ILaunchConfigurationWorkingCopy::getParent);
            original = wc.getOriginal();
        }
        return Stream.of(Stream.of(configuration), parents, Stream.of(original)).flatMap(Function.identity()).filter(Objects::nonNull);
    }
}

