/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.refactoring;

import java.util.ArrayList;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.TextFileChange;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.BundleSpecification;
import org.eclipse.osgi.service.resolver.ExportPackageDescription;
import org.eclipse.osgi.service.resolver.StateHelper;
import org.eclipse.pde.core.plugin.IFragmentModel;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.PluginRegistry;
import org.eclipse.pde.internal.build.BundleHelper;
import org.eclipse.pde.internal.ui.refactoring.CreateHeaderChangeOperation;
import org.osgi.resource.Resource;

public class FindReferenceOperation
implements IWorkspaceRunnable {
    private final BundleDescription fDesc;
    private final String fNewId;
    private Change[] fChanges;

    public FindReferenceOperation(BundleDescription desc, String newId) {
        this.fDesc = desc;
        this.fNewId = newId;
    }

    public void run(IProgressMonitor monitor) throws CoreException {
        ArrayList<TextFileChange> list = new ArrayList<TextFileChange>();
        if (this.fDesc != null) {
            SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)3);
            this.findRequireBundleReferences(list, (IProgressMonitor)subMonitor.split(1));
            this.findFragmentReferences(list, (IProgressMonitor)subMonitor.split(1));
            this.findXFriendReferences(list, (IProgressMonitor)subMonitor.split(1));
        }
        this.fChanges = list.toArray(new Change[list.size()]);
    }

    public Change[] getChanges() {
        return this.fChanges;
    }

    private void findRequireBundleReferences(ArrayList<TextFileChange> changes, IProgressMonitor monitor) throws CoreException {
        String oldId = this.fDesc.getSymbolicName();
        BundleDescription[] dependents = this.fDesc.getDependents();
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)dependents.length);
        BundleDescription[] bundleDescriptionArray = dependents;
        int n = dependents.length;
        int n2 = 0;
        while (n2 < n) {
            BundleDescription dependent = bundleDescriptionArray[n2];
            BundleSpecification[] requires = dependent.getRequiredBundles();
            SubMonitor iterationMonitor = subMonitor.split(1);
            BundleSpecification[] bundleSpecificationArray = requires;
            int n3 = requires.length;
            int n4 = 0;
            while (n4 < n3) {
                BundleSpecification require = bundleSpecificationArray[n4];
                if (require.getName().equals(oldId)) {
                    CreateHeaderChangeOperation op = new CreateHeaderChangeOperation(PluginRegistry.findModel((Resource)dependent), "Require-Bundle", oldId, this.fNewId);
                    op.run((IProgressMonitor)iterationMonitor);
                    TextFileChange change = op.getChange();
                    if (change == null) break;
                    changes.add(change);
                    break;
                }
                ++n4;
            }
            ++n2;
        }
    }

    private void findFragmentReferences(ArrayList<TextFileChange> changes, IProgressMonitor monitor) throws CoreException {
        BundleDescription[] fragments = this.fDesc.getFragments();
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)fragments.length);
        String id = this.fDesc.getSymbolicName();
        BundleDescription[] bundleDescriptionArray = fragments;
        int n = fragments.length;
        int n2 = 0;
        while (n2 < n) {
            BundleDescription fragment = bundleDescriptionArray[n2];
            IPluginModelBase base = PluginRegistry.findModel((Resource)fragment);
            SubMonitor iterationMonitor = subMonitor.split(1);
            if (base instanceof IFragmentModel && id.equals(((IFragmentModel)base).getFragment().getPluginId())) {
                CreateHeaderChangeOperation op = new CreateHeaderChangeOperation(base, "Fragment-Host", id, this.fNewId);
                op.run((IProgressMonitor)iterationMonitor);
                TextFileChange change = op.getChange();
                if (change != null) {
                    changes.add(change);
                }
            }
            ++n2;
        }
    }

    private void findXFriendReferences(ArrayList<TextFileChange> changes, IProgressMonitor monitor) throws CoreException {
        StateHelper helper = BundleHelper.getPlatformAdmin().getStateHelper();
        ExportPackageDescription[] pkgs = helper.getVisiblePackages(this.fDesc);
        String id = this.fDesc.getSymbolicName();
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)pkgs.length);
        ExportPackageDescription[] exportPackageDescriptionArray = pkgs;
        int n = pkgs.length;
        int n2 = 0;
        while (n2 < n) {
            ExportPackageDescription pkg = exportPackageDescriptionArray[n2];
            SubMonitor iterationMonitor = subMonitor.split(1);
            String[] friends = (String[])pkg.getDirective("x-friends");
            if (friends != null) {
                String[] stringArray = friends;
                int n3 = friends.length;
                int n4 = 0;
                while (n4 < n3) {
                    String friend = stringArray[n4];
                    if (friend.equals(id)) {
                        CreateHeaderChangeOperation op = new CreateHeaderChangeOperation(PluginRegistry.findModel((Resource)pkg.getExporter()), "Export-Package", id, this.fNewId);
                        op.run((IProgressMonitor)iterationMonitor);
                        TextFileChange change = op.getChange();
                        if (change == null) break;
                        changes.add(change);
                        break;
                    }
                    ++n4;
                }
            }
            ++n2;
        }
    }
}

