/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.apt.core.util;

import com.sun.mirror.apt.AnnotationProcessorFactory;
import java.util.Collection;
import java.util.List;
import org.eclipse.jdt.apt.core.internal.AnnotationProcessorFactoryLoader;
import org.eclipse.jdt.core.IJavaProject;

public final class AptUtil {
    private AptUtil() {
    }

    public static AnnotationProcessorFactory getFactoryForAnnotation(String fullyQualifiedAnnotation, IJavaProject jproj) {
        AnnotationProcessorFactoryLoader loader = AnnotationProcessorFactoryLoader.getLoader();
        List<AnnotationProcessorFactory> factories = loader.getJava5FactoriesForProject(jproj);
        for (AnnotationProcessorFactory factory : factories) {
            Collection<String> supportedAnnos = factory.supportedAnnotationTypes();
            for (String anno : supportedAnnos) {
                String prefix;
                if (anno.equals(fullyQualifiedAnnotation)) {
                    return factory;
                }
                if ("*".equals(anno)) {
                    return factory;
                }
                if (!anno.endsWith("*") || !fullyQualifiedAnnotation.startsWith(prefix = anno.substring(0, anno.length() - 2))) continue;
                return factory;
            }
        }
        return null;
    }
}

