/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.lucene101;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.lucene.codecs.BlockTermState;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.codecs.CompetitiveImpactAccumulator;
import org.apache.lucene.codecs.PushPostingsWriterBase;
import org.apache.lucene.codecs.lucene101.ForDeltaUtil;
import org.apache.lucene.codecs.lucene101.Lucene101PostingsFormat;
import org.apache.lucene.codecs.lucene101.PForUtil;
import org.apache.lucene.codecs.lucene101.PostingsUtil;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.Impact;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.index.SegmentWriteState;
import org.apache.lucene.store.ByteBuffersDataOutput;
import org.apache.lucene.store.DataOutput;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.BitUtil;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.FixedBitSet;
import org.apache.lucene.util.IOUtils;

public class Lucene101PostingsWriter
extends PushPostingsWriterBase {
    static final Lucene101PostingsFormat.IntBlockTermState EMPTY_STATE = new Lucene101PostingsFormat.IntBlockTermState();
    private final int version;
    IndexOutput metaOut;
    IndexOutput docOut;
    IndexOutput posOut;
    IndexOutput payOut;
    Lucene101PostingsFormat.IntBlockTermState lastState;
    private long docStartFP;
    private long posStartFP;
    private long payStartFP;
    final int[] docDeltaBuffer;
    final int[] freqBuffer;
    private int docBufferUpto;
    final int[] posDeltaBuffer;
    final int[] payloadLengthBuffer;
    final int[] offsetStartDeltaBuffer;
    final int[] offsetLengthBuffer;
    private int posBufferUpto;
    private byte[] payloadBytes;
    private int payloadByteUpto;
    private int level0LastDocID;
    private long level0LastPosFP;
    private long level0LastPayFP;
    private int level1LastDocID;
    private long level1LastPosFP;
    private long level1LastPayFP;
    private int docID;
    private int lastDocID;
    private int lastPosition;
    private int lastStartOffset;
    private int docCount;
    private final PForUtil pforUtil;
    private final ForDeltaUtil forDeltaUtil;
    private boolean fieldHasNorms;
    private NumericDocValues norms;
    private final CompetitiveImpactAccumulator level0FreqNormAccumulator;
    private final CompetitiveImpactAccumulator level1CompetitiveFreqNormAccumulator;
    private int maxNumImpactsAtLevel0;
    private int maxImpactNumBytesAtLevel0;
    private int maxNumImpactsAtLevel1;
    private int maxImpactNumBytesAtLevel1;
    private final ByteBuffersDataOutput scratchOutput;
    private final ByteBuffersDataOutput level0Output;
    private final ByteBuffersDataOutput level1Output;
    private final FixedBitSet spareBitSet;

    public Lucene101PostingsWriter(SegmentWriteState state) throws IOException {
        this(state, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    Lucene101PostingsWriter(SegmentWriteState state, int version) throws IOException {
        block10: {
            this.level0FreqNormAccumulator = new CompetitiveImpactAccumulator();
            this.level1CompetitiveFreqNormAccumulator = new CompetitiveImpactAccumulator();
            this.scratchOutput = ByteBuffersDataOutput.newResettableInstance();
            this.level0Output = ByteBuffersDataOutput.newResettableInstance();
            this.level1Output = ByteBuffersDataOutput.newResettableInstance();
            this.spareBitSet = new FixedBitSet(4096);
            this.version = version;
            String metaFileName = IndexFileNames.segmentFileName(state.segmentInfo.name, state.segmentSuffix, "psm");
            String docFileName = IndexFileNames.segmentFileName(state.segmentInfo.name, state.segmentSuffix, "doc");
            this.metaOut = state.directory.createOutput(metaFileName, state.context);
            IndexOutput posOut = null;
            IndexOutput payOut = null;
            boolean success = false;
            try {
                this.docOut = state.directory.createOutput(docFileName, state.context);
                CodecUtil.writeIndexHeader(this.metaOut, "Lucene101PostingsWriterMeta", version, state.segmentInfo.getId(), state.segmentSuffix);
                CodecUtil.writeIndexHeader(this.docOut, "Lucene101PostingsWriterDoc", version, state.segmentInfo.getId(), state.segmentSuffix);
                this.forDeltaUtil = new ForDeltaUtil();
                this.pforUtil = new PForUtil();
                if (state.fieldInfos.hasProx()) {
                    this.posDeltaBuffer = new int[128];
                    String posFileName = IndexFileNames.segmentFileName(state.segmentInfo.name, state.segmentSuffix, "pos");
                    posOut = state.directory.createOutput(posFileName, state.context);
                    CodecUtil.writeIndexHeader(posOut, "Lucene101PostingsWriterPos", version, state.segmentInfo.getId(), state.segmentSuffix);
                    if (state.fieldInfos.hasPayloads()) {
                        this.payloadBytes = new byte[128];
                        this.payloadLengthBuffer = new int[128];
                    } else {
                        this.payloadBytes = null;
                        this.payloadLengthBuffer = null;
                    }
                    if (state.fieldInfos.hasOffsets()) {
                        this.offsetStartDeltaBuffer = new int[128];
                        this.offsetLengthBuffer = new int[128];
                    } else {
                        this.offsetStartDeltaBuffer = null;
                        this.offsetLengthBuffer = null;
                    }
                    if (state.fieldInfos.hasPayloads() || state.fieldInfos.hasOffsets()) {
                        String payFileName = IndexFileNames.segmentFileName(state.segmentInfo.name, state.segmentSuffix, "pay");
                        payOut = state.directory.createOutput(payFileName, state.context);
                        CodecUtil.writeIndexHeader(payOut, "Lucene101PostingsWriterPay", version, state.segmentInfo.getId(), state.segmentSuffix);
                    }
                } else {
                    this.posDeltaBuffer = null;
                    this.payloadLengthBuffer = null;
                    this.offsetStartDeltaBuffer = null;
                    this.offsetLengthBuffer = null;
                    this.payloadBytes = null;
                }
                this.payOut = payOut;
                this.posOut = posOut;
                success = true;
                if (success) break block10;
            }
            catch (Throwable throwable) {
                if (!success) {
                    IOUtils.closeWhileHandlingException(this.metaOut, this.docOut, posOut, payOut);
                }
                throw throwable;
            }
            IOUtils.closeWhileHandlingException(this.metaOut, this.docOut, posOut, payOut);
        }
        this.docDeltaBuffer = new int[128];
        this.freqBuffer = new int[128];
    }

    @Override
    public Lucene101PostingsFormat.IntBlockTermState newTermState() {
        return new Lucene101PostingsFormat.IntBlockTermState();
    }

    @Override
    public void init(IndexOutput termsOut, SegmentWriteState state) throws IOException {
        CodecUtil.writeIndexHeader(termsOut, "Lucene90PostingsWriterTerms", this.version, state.segmentInfo.getId(), state.segmentSuffix);
        termsOut.writeVInt(128);
    }

    @Override
    public void setField(FieldInfo fieldInfo) {
        super.setField(fieldInfo);
        this.lastState = EMPTY_STATE;
        this.fieldHasNorms = fieldInfo.hasNorms();
    }

    @Override
    public void startTerm(NumericDocValues norms) {
        this.docStartFP = this.docOut.getFilePointer();
        if (this.writePositions) {
            this.level1LastPosFP = this.level0LastPosFP = (this.posStartFP = this.posOut.getFilePointer());
            if (this.writePayloads || this.writeOffsets) {
                this.level1LastPayFP = this.level0LastPayFP = (this.payStartFP = this.payOut.getFilePointer());
            }
        }
        this.lastDocID = -1;
        this.level0LastDocID = -1;
        this.level1LastDocID = -1;
        this.norms = norms;
        if (this.writeFreqs) {
            this.level0FreqNormAccumulator.clear();
        }
    }

    @Override
    public void startDoc(int docID, int termDocFreq) throws IOException {
        if (this.docBufferUpto == 128) {
            this.flushDocBlock(false);
            this.docBufferUpto = 0;
        }
        int docDelta = docID - this.lastDocID;
        if (docID < 0 || docDelta <= 0) {
            throw new CorruptIndexException("docs out of order (" + docID + " <= " + this.lastDocID + " )", this.docOut);
        }
        this.docDeltaBuffer[this.docBufferUpto] = docDelta;
        if (this.writeFreqs) {
            this.freqBuffer[this.docBufferUpto] = termDocFreq;
        }
        this.docID = docID;
        this.lastPosition = 0;
        this.lastStartOffset = 0;
        if (this.writeFreqs) {
            long norm;
            if (this.fieldHasNorms) {
                boolean found = this.norms.advanceExact(docID);
                if (!found) {
                    norm = 1L;
                } else {
                    norm = this.norms.longValue();
                    assert (norm != 0L) : docID;
                }
            } else {
                norm = 1L;
            }
            this.level0FreqNormAccumulator.add(termDocFreq, norm);
        }
    }

    @Override
    public void addPosition(int position, BytesRef payload, int startOffset, int endOffset) throws IOException {
        if (position > 0x7FFFFF7F) {
            throw new CorruptIndexException("position=" + position + " is too large (> IndexWriter.MAX_POSITION=2147483519)", this.docOut);
        }
        if (position < 0) {
            throw new CorruptIndexException("position=" + position + " is < 0", this.docOut);
        }
        this.posDeltaBuffer[this.posBufferUpto] = position - this.lastPosition;
        if (this.writePayloads) {
            if (payload == null || payload.length == 0) {
                this.payloadLengthBuffer[this.posBufferUpto] = 0;
            } else {
                this.payloadLengthBuffer[this.posBufferUpto] = payload.length;
                if (this.payloadByteUpto + payload.length > this.payloadBytes.length) {
                    this.payloadBytes = ArrayUtil.grow(this.payloadBytes, this.payloadByteUpto + payload.length);
                }
                System.arraycopy(payload.bytes, payload.offset, this.payloadBytes, this.payloadByteUpto, payload.length);
                this.payloadByteUpto += payload.length;
            }
        }
        if (this.writeOffsets) {
            assert (startOffset >= this.lastStartOffset);
            assert (endOffset >= startOffset);
            this.offsetStartDeltaBuffer[this.posBufferUpto] = startOffset - this.lastStartOffset;
            this.offsetLengthBuffer[this.posBufferUpto] = endOffset - startOffset;
            this.lastStartOffset = startOffset;
        }
        ++this.posBufferUpto;
        this.lastPosition = position;
        if (this.posBufferUpto == 128) {
            this.pforUtil.encode(this.posDeltaBuffer, this.posOut);
            if (this.writePayloads) {
                this.pforUtil.encode(this.payloadLengthBuffer, this.payOut);
                this.payOut.writeVInt(this.payloadByteUpto);
                this.payOut.writeBytes(this.payloadBytes, 0, this.payloadByteUpto);
                this.payloadByteUpto = 0;
            }
            if (this.writeOffsets) {
                this.pforUtil.encode(this.offsetStartDeltaBuffer, this.payOut);
                this.pforUtil.encode(this.offsetLengthBuffer, this.payOut);
            }
            this.posBufferUpto = 0;
        }
    }

    @Override
    public void finishDoc() {
        ++this.docBufferUpto;
        ++this.docCount;
        this.lastDocID = this.docID;
    }

    static void writeVInt15(DataOutput out, int v) throws IOException {
        assert (v >= 0);
        Lucene101PostingsWriter.writeVLong15(out, v);
    }

    static void writeVLong15(DataOutput out, long v) throws IOException {
        assert (v >= 0L);
        if ((v & 0xFFFFFFFFFFFF8000L) == 0L) {
            out.writeShort((short)v);
        } else {
            out.writeShort((short)(0x8000L | v & 0x7FFFL));
            out.writeVLong(v >> 15);
        }
    }

    private void flushDocBlock(boolean finishTerm) throws IOException {
        assert (this.docBufferUpto != 0);
        if (this.docBufferUpto < 128) {
            assert (finishTerm);
            PostingsUtil.writeVIntBlock(this.level0Output, this.docDeltaBuffer, this.freqBuffer, this.docBufferUpto, this.writeFreqs);
        } else {
            if (this.writeFreqs) {
                List<Impact> impacts = this.level0FreqNormAccumulator.getCompetitiveFreqNormPairs();
                if (impacts.size() > this.maxNumImpactsAtLevel0) {
                    this.maxNumImpactsAtLevel0 = impacts.size();
                }
                Lucene101PostingsWriter.writeImpacts(impacts, this.scratchOutput);
                assert (this.level0Output.size() == 0L);
                if (this.scratchOutput.size() > (long)this.maxImpactNumBytesAtLevel0) {
                    this.maxImpactNumBytesAtLevel0 = Math.toIntExact(this.scratchOutput.size());
                }
                this.level0Output.writeVLong(this.scratchOutput.size());
                this.scratchOutput.copyTo(this.level0Output);
                this.scratchOutput.reset();
                if (this.writePositions) {
                    this.level0Output.writeVLong(this.posOut.getFilePointer() - this.level0LastPosFP);
                    this.level0Output.writeByte((byte)this.posBufferUpto);
                    this.level0LastPosFP = this.posOut.getFilePointer();
                    if (this.writeOffsets || this.writePayloads) {
                        this.level0Output.writeVLong(this.payOut.getFilePointer() - this.level0LastPayFP);
                        this.level0Output.writeVInt(this.payloadByteUpto);
                        this.level0LastPayFP = this.payOut.getFilePointer();
                    }
                }
            }
            long numSkipBytes = this.level0Output.size();
            int bitsPerValue = this.forDeltaUtil.bitsRequired(this.docDeltaBuffer);
            int sum = Math.toIntExact(Arrays.stream(this.docDeltaBuffer).sum());
            int numBitSetLongs = FixedBitSet.bits2words(sum);
            int numBitsNextBitsPerValue = Math.min(32, bitsPerValue + 1) * 128;
            if (sum == 128) {
                this.level0Output.writeByte((byte)0);
            } else if (this.version < 1 || numBitsNextBitsPerValue <= sum) {
                this.level0Output.writeByte((byte)bitsPerValue);
                this.forDeltaUtil.encodeDeltas(bitsPerValue, this.docDeltaBuffer, this.level0Output);
            } else {
                this.spareBitSet.clear(0, numBitSetLongs << 6);
                int s = -1;
                for (int i : this.docDeltaBuffer) {
                    this.spareBitSet.set(s += i);
                }
                assert (numBitSetLongs <= 64);
                this.level0Output.writeByte((byte)(-numBitSetLongs));
                for (int i = 0; i < numBitSetLongs; ++i) {
                    this.level0Output.writeLong(this.spareBitSet.getBits()[i]);
                }
            }
            if (this.writeFreqs) {
                this.pforUtil.encode(this.freqBuffer, this.level0Output);
            }
            Lucene101PostingsWriter.writeVInt15(this.scratchOutput, this.docID - this.level0LastDocID);
            Lucene101PostingsWriter.writeVLong15(this.scratchOutput, this.level0Output.size());
            this.level1Output.writeVLong(numSkipBytes += this.scratchOutput.size());
            this.scratchOutput.copyTo(this.level1Output);
            this.scratchOutput.reset();
        }
        this.level0Output.copyTo(this.level1Output);
        this.level0Output.reset();
        this.level0LastDocID = this.docID;
        if (this.writeFreqs) {
            this.level1CompetitiveFreqNormAccumulator.addAll(this.level0FreqNormAccumulator);
            this.level0FreqNormAccumulator.clear();
        }
        if ((this.docCount & 0xFFF) == 0) {
            this.writeLevel1SkipData();
            this.level1LastDocID = this.docID;
            this.level1CompetitiveFreqNormAccumulator.clear();
        } else if (finishTerm) {
            this.level1Output.copyTo(this.docOut);
            this.level1Output.reset();
            this.level1CompetitiveFreqNormAccumulator.clear();
        }
    }

    private void writeLevel1SkipData() throws IOException {
        long level1End;
        this.docOut.writeVInt(this.docID - this.level1LastDocID);
        if (this.writeFreqs) {
            List<Impact> impacts = this.level1CompetitiveFreqNormAccumulator.getCompetitiveFreqNormPairs();
            if (impacts.size() > this.maxNumImpactsAtLevel1) {
                this.maxNumImpactsAtLevel1 = impacts.size();
            }
            Lucene101PostingsWriter.writeImpacts(impacts, this.scratchOutput);
            long numImpactBytes = this.scratchOutput.size();
            if (numImpactBytes > (long)this.maxImpactNumBytesAtLevel1) {
                this.maxImpactNumBytesAtLevel1 = Math.toIntExact(numImpactBytes);
            }
            if (this.writePositions) {
                this.scratchOutput.writeVLong(this.posOut.getFilePointer() - this.level1LastPosFP);
                this.scratchOutput.writeByte((byte)this.posBufferUpto);
                this.level1LastPosFP = this.posOut.getFilePointer();
                if (this.writeOffsets || this.writePayloads) {
                    this.scratchOutput.writeVLong(this.payOut.getFilePointer() - this.level1LastPayFP);
                    this.scratchOutput.writeVInt(this.payloadByteUpto);
                    this.level1LastPayFP = this.payOut.getFilePointer();
                }
            }
            long level1Len = 4L + this.scratchOutput.size() + this.level1Output.size();
            this.docOut.writeVLong(level1Len);
            level1End = this.docOut.getFilePointer() + level1Len;
            assert (numImpactBytes <= 32767L);
            assert (this.scratchOutput.size() + 2L <= 32767L);
            this.docOut.writeShort((short)(this.scratchOutput.size() + 2L));
            this.docOut.writeShort((short)numImpactBytes);
            this.scratchOutput.copyTo(this.docOut);
            this.scratchOutput.reset();
        } else {
            this.docOut.writeVLong(this.level1Output.size());
            level1End = this.docOut.getFilePointer() + this.level1Output.size();
        }
        this.level1Output.copyTo(this.docOut);
        this.level1Output.reset();
        assert (this.docOut.getFilePointer() == level1End) : this.docOut.getFilePointer() + " " + level1End;
    }

    static void writeImpacts(Collection<Impact> impacts, DataOutput out) throws IOException {
        Impact previous = new Impact(0, 0L);
        for (Impact impact : impacts) {
            assert (impact.freq > previous.freq);
            assert (Long.compareUnsigned(impact.norm, previous.norm) > 0);
            int freqDelta = impact.freq - previous.freq - 1;
            long normDelta = impact.norm - previous.norm - 1L;
            if (normDelta == 0L) {
                out.writeVInt(freqDelta << 1);
            } else {
                out.writeVInt(freqDelta << 1 | 1);
                out.writeZLong(normDelta);
            }
            previous = impact;
        }
    }

    @Override
    public void finishTerm(BlockTermState _state) throws IOException {
        long lastPosBlockOffset;
        int singletonDocID;
        Lucene101PostingsFormat.IntBlockTermState state = (Lucene101PostingsFormat.IntBlockTermState)_state;
        assert (state.docFreq > 0);
        assert (state.docFreq == this.docCount) : state.docFreq + " vs " + this.docCount;
        if (state.docFreq == 1) {
            singletonDocID = this.docDeltaBuffer[0] - 1;
        } else {
            singletonDocID = -1;
            this.flushDocBlock(true);
        }
        if (this.writePositions) {
            assert (state.totalTermFreq != -1L);
            lastPosBlockOffset = state.totalTermFreq > 128L ? this.posOut.getFilePointer() - this.posStartFP : -1L;
            if (this.posBufferUpto > 0) {
                assert (this.posBufferUpto < 128);
                int lastPayloadLength = -1;
                int lastOffsetLength = -1;
                int payloadBytesReadUpto = 0;
                for (int i = 0; i < this.posBufferUpto; ++i) {
                    int posDelta = this.posDeltaBuffer[i];
                    if (this.writePayloads) {
                        int payloadLength = this.payloadLengthBuffer[i];
                        if (payloadLength != lastPayloadLength) {
                            lastPayloadLength = payloadLength;
                            this.posOut.writeVInt(posDelta << 1 | 1);
                            this.posOut.writeVInt(payloadLength);
                        } else {
                            this.posOut.writeVInt(posDelta << 1);
                        }
                        if (payloadLength != 0) {
                            this.posOut.writeBytes(this.payloadBytes, payloadBytesReadUpto, payloadLength);
                            payloadBytesReadUpto += payloadLength;
                        }
                    } else {
                        this.posOut.writeVInt(posDelta);
                    }
                    if (!this.writeOffsets) continue;
                    int delta = this.offsetStartDeltaBuffer[i];
                    int length = this.offsetLengthBuffer[i];
                    if (length == lastOffsetLength) {
                        this.posOut.writeVInt(delta << 1);
                        continue;
                    }
                    this.posOut.writeVInt(delta << 1 | 1);
                    this.posOut.writeVInt(length);
                    lastOffsetLength = length;
                }
                if (this.writePayloads) {
                    assert (payloadBytesReadUpto == this.payloadByteUpto);
                    this.payloadByteUpto = 0;
                }
            }
        } else {
            lastPosBlockOffset = -1L;
        }
        state.docStartFP = this.docStartFP;
        state.posStartFP = this.posStartFP;
        state.payStartFP = this.payStartFP;
        state.singletonDocID = singletonDocID;
        state.lastPosBlockOffset = lastPosBlockOffset;
        this.docBufferUpto = 0;
        this.posBufferUpto = 0;
        this.lastDocID = -1;
        this.docCount = 0;
    }

    @Override
    public void encodeTerm(DataOutput out, FieldInfo fieldInfo, BlockTermState _state, boolean absolute) throws IOException {
        Lucene101PostingsFormat.IntBlockTermState state = (Lucene101PostingsFormat.IntBlockTermState)_state;
        if (absolute) {
            this.lastState = EMPTY_STATE;
            assert (this.lastState.docStartFP == 0L);
        }
        if (this.lastState.singletonDocID != -1 && state.singletonDocID != -1 && state.docStartFP == this.lastState.docStartFP) {
            long delta = (long)state.singletonDocID - (long)this.lastState.singletonDocID;
            out.writeVLong(BitUtil.zigZagEncode(delta) << 1 | 1L);
        } else {
            out.writeVLong(state.docStartFP - this.lastState.docStartFP << 1);
            if (state.singletonDocID != -1) {
                out.writeVInt(state.singletonDocID);
            }
        }
        if (this.writePositions) {
            out.writeVLong(state.posStartFP - this.lastState.posStartFP);
            if (this.writePayloads || this.writeOffsets) {
                out.writeVLong(state.payStartFP - this.lastState.payStartFP);
            }
        }
        if (this.writePositions && state.lastPosBlockOffset != -1L) {
            out.writeVLong(state.lastPosBlockOffset);
        }
        this.lastState = state;
    }

    @Override
    public void close() throws IOException {
        block11: {
            block10: {
                boolean success = false;
                try {
                    if (this.docOut != null) {
                        CodecUtil.writeFooter(this.docOut);
                    }
                    if (this.posOut != null) {
                        CodecUtil.writeFooter(this.posOut);
                    }
                    if (this.payOut != null) {
                        CodecUtil.writeFooter(this.payOut);
                    }
                    if (this.metaOut != null) {
                        this.metaOut.writeInt(this.maxNumImpactsAtLevel0);
                        this.metaOut.writeInt(this.maxImpactNumBytesAtLevel0);
                        this.metaOut.writeInt(this.maxNumImpactsAtLevel1);
                        this.metaOut.writeInt(this.maxImpactNumBytesAtLevel1);
                        this.metaOut.writeLong(this.docOut.getFilePointer());
                        if (this.posOut != null) {
                            this.metaOut.writeLong(this.posOut.getFilePointer());
                            if (this.payOut != null) {
                                this.metaOut.writeLong(this.payOut.getFilePointer());
                            }
                        }
                        CodecUtil.writeFooter(this.metaOut);
                    }
                    if (!(success = true)) break block10;
                }
                catch (Throwable throwable) {
                    if (success) {
                        IOUtils.close(this.metaOut, this.docOut, this.posOut, this.payOut);
                    } else {
                        IOUtils.closeWhileHandlingException(this.metaOut, this.docOut, this.posOut, this.payOut);
                    }
                    this.payOut = null;
                    this.posOut = null;
                    this.docOut = null;
                    this.metaOut = null;
                    throw throwable;
                }
                IOUtils.close(this.metaOut, this.docOut, this.posOut, this.payOut);
                break block11;
            }
            IOUtils.closeWhileHandlingException(this.metaOut, this.docOut, this.posOut, this.payOut);
        }
        this.payOut = null;
        this.posOut = null;
        this.docOut = null;
        this.metaOut = null;
    }
}

