/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.api.tools.internal.provisional;

public final class VisibilityModifiers {
    public static final int API = 1;
    public static final int PRIVATE = 2;
    public static final int SPI = 4;
    public static final int ILLEGAL_API = 22;
    public static final int PRIVATE_PERMISSIBLE = 8;
    public static final int ALL_VISIBILITIES = 65535;

    private VisibilityModifiers() {
    }

    public static final boolean isAPI(int modifiers) {
        return (modifiers & 1) > 0;
    }

    public static final boolean isSPI(int modifiers) {
        return (modifiers & 4) > 0;
    }

    public static final boolean isPrivate(int modifiers) {
        return (modifiers & 2) > 0;
    }

    public static final boolean isPermissiblePrivate(int modifiers) {
        return (modifiers & 8) > 0;
    }

    public static String getVisibilityName(int visibility) {
        switch (visibility) {
            case 65535: {
                return "ALL_VISIBILITIES";
            }
            case 1: {
                return "API";
            }
            case 2: {
                return "PRIVATE";
            }
            case 8: {
                return "PRIVATE_PERMISSIBLE";
            }
            case 5: {
                return "FRAGMENT_PERMISSIBLE";
            }
            case 4: {
                return "SPI";
            }
            case 22: {
                return "ILLEGAL_API";
            }
            case 0: {
                return "INHERITED";
            }
        }
        return "UNKNOWN_VISIBILITY";
    }
}

