/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.product;

import java.util.Arrays;
import java.util.stream.Stream;
import org.eclipse.pde.core.IBaseModel;
import org.eclipse.pde.internal.core.iproduct.IProduct;
import org.eclipse.pde.internal.core.iproduct.IProductFeature;
import org.eclipse.pde.internal.core.iproduct.IProductModel;
import org.eclipse.pde.internal.core.iproduct.IProductPlugin;
import org.eclipse.pde.internal.ui.editor.FormOutlinePage;
import org.eclipse.pde.internal.ui.editor.PDEFormEditor;
import org.eclipse.pde.internal.ui.editor.product.DependenciesPage;

public class ProductOutlinePage
extends FormOutlinePage {
    public ProductOutlinePage(PDEFormEditor editor) {
        super(editor);
    }

    @Override
    protected Object[] getChildren(Object parent) {
        DependenciesPage page;
        IBaseModel iBaseModel;
        if (parent instanceof DependenciesPage && (iBaseModel = (page = (DependenciesPage)((Object)parent)).getModel()) instanceof IProductModel) {
            IProductModel model = (IProductModel)iBaseModel;
            IProduct product = model.getProduct();
            return switch (product.getType()) {
                case IProduct.ProductType.BUNDLES -> product.getPlugins();
                case IProduct.ProductType.FEATURES -> product.getFeatures();
                case IProduct.ProductType.MIXED -> Stream.of(product.getFeatures(), product.getPlugins()).flatMap(Arrays::stream).toArray();
                default -> throw new MatchException(null, null);
            };
        }
        return new Object[0];
    }

    @Override
    protected String getParentPageId(Object item) {
        if (item instanceof IProductPlugin) {
            return "plugin-dependencies";
        }
        if (item instanceof IProductFeature) {
            return "feature-dependencies";
        }
        return super.getParentPageId(item);
    }
}

