/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.runner.util;

import com.google.common.base.Joiner;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceDescription;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugException;
import org.eclipse.rcptt.core.internal.builder.MigrateProjectsJob;
import org.eclipse.rcptt.core.model.IQ7Element;
import org.eclipse.rcptt.core.model.IQ7ElementVisitor;
import org.eclipse.rcptt.core.model.IQ7NamedElement;
import org.eclipse.rcptt.core.model.IQ7Project;
import org.eclipse.rcptt.core.model.ITestCase;
import org.eclipse.rcptt.core.model.ModelException;
import org.eclipse.rcptt.core.scenario.UnresolvedContext;
import org.eclipse.rcptt.core.utils.TagsUtil;
import org.eclipse.rcptt.core.workspace.IWorkspaceFinder;
import org.eclipse.rcptt.core.workspace.ProjectUtil;
import org.eclipse.rcptt.core.workspace.RcpttCore;
import org.eclipse.rcptt.core.workspace.WorkspaceFinder;
import org.eclipse.rcptt.internal.core.model.ModelManager;
import org.eclipse.rcptt.internal.core.model.Q7InternalContext;
import org.eclipse.rcptt.internal.core.model.Q7TestCase;
import org.eclipse.rcptt.internal.core.model.index.NamedElementCollector;
import org.eclipse.rcptt.internal.launching.TestEngineManager;
import org.eclipse.rcptt.launching.CheckedExceptionWrapper;
import org.eclipse.rcptt.launching.utils.TestSuiteElementCollector;
import org.eclipse.rcptt.reporting.util.Q7ReportIterator;
import org.eclipse.rcptt.runner.HeadlessRunner;
import org.eclipse.rcptt.runner.HeadlessRunnerPlugin;
import org.eclipse.rcptt.runner.RunnerConfiguration;
import org.eclipse.rcptt.runner.ScenarioRunnable;
import org.eclipse.rcptt.runner.util.AUTsManager;
import org.eclipse.rcptt.runner.util.AutLaunchFail;
import org.eclipse.rcptt.runner.util.AutThread;
import org.eclipse.rcptt.runner.util.Reporter;
import org.eclipse.rcptt.runner.util.ResultsHandler;
import org.eclipse.rcptt.runner.util.TestResult;
import org.eclipse.rcptt.runner.util.TestSuite;
import org.eclipse.rcptt.sherlock.core.streams.SherlockReportOutputStream;
import org.eclipse.rcptt.util.StringUtils;

public class TestsRunner {
    private final RunnerConfiguration conf;
    private final Reporter reporter;
    private final ResultsHandler resultsHandler;
    private final AUTsManager auts;
    private int failedCount = 0;
    private AtomicReference<Exception> error = new AtomicReference<Object>(null);

    public int getFailedCount() {
        return this.failedCount;
    }

    public TestsRunner(RunnerConfiguration conf, HeadlessRunner caller, ResultsHandler resultsHandler) {
        this.conf = conf;
        this.reporter = caller.reporter;
        this.resultsHandler = resultsHandler;
        this.auts = new AUTsManager(conf, caller.tpc);
    }

    public Q7ReportIterator findAndRunTests() throws CoreException, AutLaunchFail, InterruptedException {
        System.out.println("Looking for tests...");
        TestSuite[] tests = this.findScenarios();
        if (tests.length <= 0) {
            throw new IllegalArgumentException("No tests found.");
        }
        return this.runTests(tests);
    }

    private static List<String> buildTestNamePatterns(List<String> globs) {
        ArrayList<String> result = new ArrayList<String>();
        for (String glob : globs) {
            result.add(StringUtils.globToRegex((String)glob));
        }
        return result;
    }

    private static boolean matches(String name, List<String> patterns) {
        if (patterns.isEmpty()) {
            return true;
        }
        for (String pattern : patterns) {
            if (!name.matches(pattern)) continue;
            return true;
        }
        return false;
    }

    private TestSuite[] findScenarios() throws CoreException, InterruptedException {
        TestSuiteElementCollector ts;
        Set absent;
        IProject[] projects;
        List<String> testNamePatterns = TestsRunner.buildTestNamePatterns(this.conf.toTest);
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IWorkspaceDescription descrition = workspace.getDescription();
        descrition.setAutoBuilding(false);
        workspace.setDescription(descrition);
        ProjectUtil.importProjects(this.conf.toImport, (PrintStream)System.out);
        new MigrateProjectsJob((IContainer)ResourcesPlugin.getWorkspace().getRoot()).runSync();
        try {
            projects = ProjectUtil.projects();
        }
        catch (InterruptedException e1) {
            throw new CoreException((IStatus)new Status(8, "org.eclipse.rcptt.runner", "Interrupted", (Throwable)e1));
        }
        if (projects.length == 0) {
            System.out.println("No projects ready to test");
            return new TestSuite[0];
        }
        ModelManager.getModelManager().getIndexManager().waitUntilReady((IProgressMonitor)new NullProgressMonitor());
        System.out.println("Searching for tests in workspace:");
        Object collector = null;
        collector = this.conf.suites.size() == 0 ? new NamedElementCollector(new IQ7Element.HandleType[]{IQ7Element.HandleType.TestCase}) : new TestSuiteElementCollector(this.conf.suites, true);
        try {
            ModelManager.getModelManager().getModel().accept((IQ7ElementVisitor)collector);
        }
        catch (CheckedExceptionWrapper e) {
            e.rethrow(CoreException.class);
            e.rethrow(InterruptedException.class);
            e.rethrowUnchecked();
            throw e;
        }
        WorkspaceFinder finder = WorkspaceFinder.getInstance();
        if (collector instanceof TestSuiteElementCollector && !(absent = (ts = collector).getAbsentSuites()).isEmpty()) {
            throw new CoreException(Status.error((String)String.format("Test suites %s were not found", absent)));
        }
        HashMap<IQ7Project, TestSuite> result = new HashMap<IQ7Project, TestSuite>();
        for (IQ7NamedElement element : collector.getElements()) {
            if (!(element instanceof ITestCase)) continue;
            ITestCase tcase = (ITestCase)element;
            if (this.isSkipExecuton(tcase)) {
                String tags = tcase.getTags();
                String skipBy = null;
                String[] stringArray = this.conf.tagsToSkip;
                int n = this.conf.tagsToSkip.length;
                int n2 = 0;
                while (n2 < n) {
                    String s = stringArray[n2];
                    if (tags.contains(s)) {
                        skipBy = s;
                    }
                    ++n2;
                }
                System.out.println("-- Testcase is skipped by tag \"" + skipBy + "\" -- " + tcase.getName());
                continue;
            }
            if (!TestsRunner.matches(tcase.getName(), testNamePatterns)) continue;
            if (!this.ensureIntegrity((IQ7NamedElement)tcase, (IWorkspaceFinder)finder, new HashSet<String>())) {
                throw new CoreException(Status.error((String)(String.valueOf(tcase.getPath()) + " is malformed")));
            }
            TestSuite suite = result.computeIfAbsent(tcase.getQ7Project(), p -> new TestSuite(p.getProject()));
            suite.add(tcase);
        }
        if (this.conf.suites.size() == 0) {
            result.values().forEach(TestSuite::sort);
        }
        if (result.isEmpty()) {
            System.out.println(String.format("No tests found", new Object[0]));
        } else {
            System.out.println("Complete OK");
        }
        return result.values().toArray(new TestSuite[0]);
    }

    private boolean isSkipExecuton(ITestCase testCase) {
        try {
            return TagsUtil.hasAny((IQ7NamedElement)testCase, (String[])this.conf.tagsToSkip);
        }
        catch (ModelException e) {
            HeadlessRunnerPlugin.getDefault().info("Failed to get tags for testcase:" + testCase.getPath().toString());
            return false;
        }
    }

    /*
     * Unable to fully structure code
     */
    private boolean ensureIntegrity(IQ7NamedElement tcase, IWorkspaceFinder finder, Set<String> processedIds) {
        if (!processedIds.add(tcase.getPath().toString())) {
            return true;
        }
        contexts = RcpttCore.getInstance().getContexts(tcase, finder, false);
        unresolved = new ArrayList<String>();
        var9_6 = contexts;
        var8_7 = contexts.length;
        var7_8 = 0;
        while (var7_8 < var8_7) {
            ctx = var9_6[var7_8];
            if (ctx instanceof Q7InternalContext) {
                try {
                    namedElement = ctx.getNamedElement();
                    if (!(namedElement instanceof UnresolvedContext)) ** GOTO lbl22
                    unresolved.add(ctx.getName());
                }
                catch (ModelException e) {
                    HeadlessRunnerPlugin.logErr("Failed to check testcase: " + tcase.getName() + " for dependencies. Cause: " + e.getMessage(), e);
                    return false;
                }
            } else if (!this.ensureIntegrity((IQ7NamedElement)ctx, finder, processedIds)) {
                return false;
            }
lbl22:
            // 4 sources

            ++var7_8;
        }
        if (unresolved.size() > 0) {
            try {
                System.out.println("-- Testcase is skipped because of incorrect dependencies -- " + tcase.getName() + ". Requires contexts: [" + Joiner.on((String)",").join(unresolved) + "]");
            }
            catch (Exception e) {
                HeadlessRunnerPlugin.logErr("Failed to check testcase: " + tcase.getName() + " for dependencies. Cause: " + e.getMessage(), e);
                return false;
            }
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Q7ReportIterator runTests(TestSuite[] tests) throws DebugException, AutLaunchFail {
        File reportFile;
        block42: {
            Assert.isTrue((boolean)this.auts.isClean(), (String)"AUTs manages should not have been used before");
            List<ScenarioRunnable> runnables = Collections.synchronizedList(new ArrayList());
            this.failedCount = 0;
            reportFile = new File(this.conf.getQ7ReportLocation());
            this.createFolderForFile(reportFile);
            HashSet<String> failed = new HashSet<String>();
            try {
                try {
                    Throwable throwable = null;
                    Object var6_9 = null;
                    try (SherlockReportOutputStream reportWriter = new SherlockReportOutputStream((OutputStream)new BufferedOutputStream(new FileOutputStream(reportFile)));){
                        IQ7NamedElement scenario2;
                        int count = 0;
                        IQ7NamedElement iQ7NamedElement = tests;
                        int n = ((TestSuite[])iQ7NamedElement).length;
                        int n2 = 0;
                        while (n2 < n) {
                            TestSuite suite = iQ7NamedElement[n2];
                            suite.setLimit(this.conf.limit);
                            count += suite.getScenarios().size();
                            ++n2;
                        }
                        int artifacts = 0;
                        IQ7NamedElement iQ7NamedElement2 = tests;
                        int n3 = ((TestSuite[])iQ7NamedElement2).length;
                        n = 0;
                        while (n < n3) {
                            TestSuite suite = iQ7NamedElement2[n];
                            for (IQ7NamedElement scenario2 : suite.getScenarios()) {
                                ScenarioRunnable runnable = new ScenarioRunnable(this.resultsHandler, scenario2, suite, "(" + String.valueOf((Object)artifacts) + " from " + String.valueOf((Object)count) + ")", reportWriter);
                                runnables.add(runnable);
                                ++artifacts;
                            }
                            ++n;
                        }
                        System.out.println("Testcase Artifacts:" + artifacts);
                        ArrayList<Q7TestCase> testCases = new ArrayList<Q7TestCase>();
                        scenario2 = tests;
                        int n4 = ((TestSuite[])scenario2).length;
                        n3 = 0;
                        while (n3 < n4) {
                            IQ7NamedElement suite = scenario2[n3];
                            for (IQ7NamedElement scenario3 : suite.getScenarios()) {
                                if (!(scenario3 instanceof Q7TestCase)) continue;
                                testCases.add((Q7TestCase)scenario3);
                            }
                            ++n3;
                        }
                        TestEngineManager.getInstance().fireTestRunStarted(this.conf.testEngines, testCases);
                        this.auts.initShutdownHook();
                        this.auts.launchAutsAndStartTheirThreads(runnables);
                        long startTime = System.currentTimeMillis();
                        int processed = 0;
                        while (true) {
                            long current;
                            if (startTime + (long)(this.conf.executionTimeout * 1000) < (current = System.currentTimeMillis())) {
                                for (AutThread thread : this.auts.autThreads) {
                                    if (!thread.isAlive()) continue;
                                    thread.cancel();
                                    try {
                                        thread.join();
                                    }
                                    catch (InterruptedException e) {
                                        HeadlessRunnerPlugin.getDefault().info("Exception during join for AUT thread termination because of timeout", e);
                                    }
                                }
                                this.skipRemaining(runnables, "Global execution timeout");
                                this.reporter.displayTimeoutMessage = true;
                            }
                            int executed = count - runnables.size();
                            int timeLeft = (int)((1.0 + (double)current - (double)startTime) / 1000.0);
                            int est = (int)(1.0 * (double)timeLeft / (double)(1 + executed) * (double)runnables.size());
                            List<TestResult> list = this.resultsHandler.results;
                            synchronized (list) {
                                for (TestResult r : this.resultsHandler.results) {
                                    ++processed;
                                    if (r.failed) {
                                        failed.add(r.name);
                                    }
                                    String out = r.userFriendlyMessage(est, timeLeft, processed, artifacts, failed.size());
                                    HeadlessRunnerPlugin.getDefault().info(out, null);
                                    System.out.println(out);
                                }
                                this.resultsHandler.results.clear();
                            }
                            boolean alive = false;
                            for (AutThread thread : this.auts.autThreads) {
                                if (!thread.isAlive()) continue;
                                alive = true;
                                break;
                            }
                            if (!alive) {
                                if (!runnables.isEmpty()) {
                                    this.error.compareAndSet(null, new AutLaunchFail("AUT is not available", null));
                                }
                                break;
                            }
                            Thread.sleep(100L);
                        }
                        this.skipRemaining(runnables, "AUT is not available");
                        if (failed.size() > 0) {
                            System.out.println("Failed Tests:");
                            for (String scenario4 : failed) {
                                System.out.println(scenario4);
                            }
                        }
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (FileNotFoundException e1) {
                    System.out.println("Failed to create report file:" + this.conf.getQ7ReportLocation());
                    HeadlessRunnerPlugin.getDefault().info("Failed to create report file:" + this.conf.getQ7ReportLocation());
                    throw new RuntimeException(e1);
                }
                catch (InterruptedException e) {
                    HeadlessRunnerPlugin.getDefault().info("Execution interrupted");
                    this.skipRemaining(runnables, "Execution finished");
                    HeadlessRunnerPlugin.getDefault().info("Shut down AUTs: executed");
                    try {
                        this.auts.shutdownAUTs();
                    }
                    catch (CoreException e2) {
                        HeadlessRunnerPlugin.log(e2.getStatus());
                    }
                    this.auts.removeShutdownHook();
                    this.failedCount = failed.size();
                    TestEngineManager.getInstance().fireTestRunCompleted();
                    break block42;
                }
            }
            catch (Throwable throwable) {
                this.skipRemaining(runnables, "Execution finished");
                HeadlessRunnerPlugin.getDefault().info("Shut down AUTs: executed");
                try {
                    this.auts.shutdownAUTs();
                }
                catch (CoreException e) {
                    HeadlessRunnerPlugin.log(e.getStatus());
                }
                this.auts.removeShutdownHook();
                this.failedCount = failed.size();
                TestEngineManager.getInstance().fireTestRunCompleted();
                throw throwable;
            }
            this.skipRemaining(runnables, "Execution finished");
            HeadlessRunnerPlugin.getDefault().info("Shut down AUTs: executed");
            try {
                this.auts.shutdownAUTs();
            }
            catch (CoreException e) {
                HeadlessRunnerPlugin.log(e.getStatus());
            }
            this.auts.removeShutdownHook();
            this.failedCount = failed.size();
            TestEngineManager.getInstance().fireTestRunCompleted();
        }
        if (reportFile.exists()) {
            return new Q7ReportIterator(reportFile);
        }
        return null;
    }

    private void skipRemaining(List<ScenarioRunnable> runnables, String message) {
        if (runnables.size() > 0) {
            System.out.println("Skip remaining: " + message);
            HeadlessRunnerPlugin.getDefault().info("Skip remaining: " + message);
            for (ScenarioRunnable runnable : runnables) {
                runnable.skip(message, true);
            }
            runnables.clear();
        }
    }

    private void createFolderForFile(File reportFile) {
        if (reportFile.isDirectory()) {
            throw new RuntimeException("Requested report file " + String.valueOf(reportFile) + " already exists and is a directory. It should not exists or be a file. Remove it or configure a different report location.");
        }
        File parent = reportFile.getParentFile();
        if (parent == null) {
            System.out.println("ERROR: invalid report location: " + String.valueOf(reportFile));
        } else {
            parent.mkdirs();
            if (!reportFile.exists()) {
                try {
                    reportFile.createNewFile();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (!reportFile.canWrite()) {
                System.out.println("ERROR: report file is not writable: " + String.valueOf(reportFile));
            }
        }
    }

    public void throwOnError() throws Exception {
        Exception result = this.error.get();
        if (result != null) {
            throw result;
        }
    }
}

