/*
 * Decompiled with CFR 0.152.
 */
package no.hasmac.jsonld.flattening;

import jakarta.json.JsonArrayBuilder;
import jakarta.json.JsonValue;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import no.hasmac.jsonld.flattening.BlankNodeIdGenerator;
import no.hasmac.jsonld.json.JsonProvider;
import no.hasmac.jsonld.json.JsonUtils;
import no.hasmac.jsonld.lang.Keywords;

public final class NodeMap {
    private final Map<String, Map<String, Map<String, JsonValue>>> index;
    private final BlankNodeIdGenerator generator = new BlankNodeIdGenerator();

    public NodeMap() {
        this.index = new LinkedHashMap<String, Map<String, Map<String, JsonValue>>>();
        this.index.put("@default", new LinkedHashMap());
    }

    public void set(String graphName, String subject, String property, JsonValue value) {
        if (subject == null) {
            return;
        }
        this.index.computeIfAbsent(graphName, x -> new LinkedHashMap()).computeIfAbsent(subject, x -> new LinkedHashMap()).put(property, value);
    }

    public JsonValue get(String graphName, String subject, String property) {
        Map<String, JsonValue> indexSubject;
        Map<String, Map<String, JsonValue>> indexGraphName = this.index.get(graphName);
        if (indexGraphName != null && (indexSubject = indexGraphName.get(subject)) != null) {
            return indexSubject.get(property);
        }
        return null;
    }

    public Map<String, JsonValue> get(String graphName, String subject) {
        Map<String, Map<String, JsonValue>> indexGraphName = this.index.get(graphName);
        if (indexGraphName != null) {
            return indexGraphName.get(subject);
        }
        return null;
    }

    public boolean contains(String graphName, String subject) {
        Map<String, Map<String, JsonValue>> indexGraphName = this.index.get(graphName);
        if (indexGraphName != null) {
            return indexGraphName.containsKey(subject);
        }
        return false;
    }

    public boolean contains(String graphName, String subject, String property) {
        Map<String, JsonValue> indexSubject;
        Map<String, Map<String, JsonValue>> indexGraphName = this.index.get(graphName);
        if (indexGraphName != null && (indexSubject = indexGraphName.get(subject)) != null) {
            return indexSubject.containsKey(property);
        }
        return false;
    }

    public Optional<Map<String, Map<String, JsonValue>>> get(String graphName) {
        return Optional.ofNullable(this.index.get(graphName));
    }

    public String createIdentifier(String name) {
        return this.generator.createIdentifier(name);
    }

    public String createIdentifier() {
        return this.generator.createIdentifier();
    }

    public Collection<String> graphs() {
        return this.index.keySet();
    }

    public Collection<String> subjects(String graphName) {
        return this.index.getOrDefault(graphName, Collections.emptyMap()).keySet();
    }

    public Collection<String> properties(String graphName, String subject) {
        return this.index.getOrDefault(graphName, Collections.emptyMap()).getOrDefault(subject, Collections.emptyMap()).keySet();
    }

    public void merge() {
        NodeMap result = new NodeMap();
        for (Map.Entry<String, Map<String, Map<String, JsonValue>>> graphEntry : this.index.entrySet()) {
            for (Map.Entry<String, Map<String, JsonValue>> subject : graphEntry.getValue().entrySet()) {
                if (!result.contains("@merged", subject.getKey())) {
                    result.set("@merged", subject.getKey(), "@id", (JsonValue)JsonProvider.instance().createValue(subject.getKey()));
                }
                for (Map.Entry<String, JsonValue> property : subject.getValue().entrySet()) {
                    if (!"@type".equals(property.getKey()) && Keywords.matchForm(property.getKey())) {
                        result.set("@merged", subject.getKey(), property.getKey(), property.getValue());
                        continue;
                    }
                    JsonArrayBuilder array = result.contains("@merged", subject.getKey(), property.getKey()) ? JsonProvider.instance().createArrayBuilder(JsonUtils.toJsonArray(result.get("@merged", subject.getKey(), property.getKey()))) : JsonProvider.instance().createArrayBuilder();
                    JsonUtils.toJsonArray(property.getValue()).forEach(arg_0 -> ((JsonArrayBuilder)array).add(arg_0));
                    result.set("@merged", subject.getKey(), property.getKey(), (JsonValue)array.build());
                }
            }
        }
        if (result.index.get("@merged") != null) {
            this.index.put("@merged", result.index.get("@merged"));
        }
    }

    public boolean contains(String id) {
        return this.index.containsKey(id);
    }

    public String toString() {
        return Objects.toString(this.index);
    }
}

