/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.common.concurrent.locks;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.StampedLock;
import org.eclipse.rdf4j.common.concurrent.locks.Lock;
import org.eclipse.rdf4j.common.concurrent.locks.Properties;
import org.eclipse.rdf4j.common.concurrent.locks.diagnostics.LockCleaner;
import org.eclipse.rdf4j.common.concurrent.locks.diagnostics.LockMonitoring;
import org.eclipse.rdf4j.common.concurrent.locks.diagnostics.LockTracking;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExclusiveLockManager {
    private static final Logger logger = LoggerFactory.getLogger(ExclusiveLockManager.class);
    final StampedLock lock = new StampedLock();
    private final int waitToCollect;
    LockMonitoring lockMonitoring;

    public ExclusiveLockManager() {
        this(false);
    }

    public ExclusiveLockManager(boolean trackLocks) {
        this(trackLocks, 10000);
    }

    public ExclusiveLockManager(boolean trackLocks, int collectionFrequency) {
        this.waitToCollect = collectionFrequency;
        this.lockMonitoring = trackLocks || Properties.lockTrackingEnabled() ? new LockTracking<Lock>(true, "ExclusiveLockManager", LoggerFactory.getLogger(this.getClass()), this.waitToCollect, Lock.ExtendedSupplier.wrap(this::getExclusiveLockInner, this::tryExclusiveLockInner)) : new LockCleaner<Lock>(false, "ExclusiveLockManager", LoggerFactory.getLogger(this.getClass()), Lock.ExtendedSupplier.wrap(this::getExclusiveLockInner, this::tryExclusiveLockInner));
    }

    private Lock tryExclusiveLockInner() {
        long writeLock = this.lock.tryWriteLock();
        if (writeLock != 0L) {
            return new ExclusiveLock(writeLock, this.lock);
        }
        this.lockMonitoring.runCleanup();
        return null;
    }

    private Lock getExclusiveLockInner() throws InterruptedException {
        long writeLock;
        if (this.lockMonitoring.requiresManualCleanup()) {
            do {
                if (Thread.interrupted()) {
                    throw new InterruptedException();
                }
                writeLock = this.lock.tryWriteLock(this.waitToCollect, TimeUnit.MILLISECONDS);
                if (writeLock != 0L) continue;
                this.lockMonitoring.runCleanup();
            } while (writeLock == 0L);
        } else {
            writeLock = this.lock.writeLockInterruptibly();
        }
        return new ExclusiveLock(writeLock, this.lock);
    }

    public Lock tryExclusiveLock() {
        return this.lockMonitoring.tryLock();
    }

    public Lock getExclusiveLock() throws InterruptedException {
        return this.lockMonitoring.getLock();
    }

    public boolean isActiveLock() {
        return this.lock.isWriteLocked();
    }

    static class ExclusiveLock
    implements Lock {
        private final StampedLock lock;
        private long stamp;

        public ExclusiveLock(long stamp, StampedLock lock) {
            assert (stamp != 0L);
            this.stamp = stamp;
            this.lock = lock;
        }

        @Override
        public boolean isActive() {
            return this.stamp != 0L;
        }

        @Override
        public void release() {
            long temp = this.stamp;
            this.stamp = 0L;
            if (temp == 0L) {
                throw new IllegalMonitorStateException("Trying to release a lock that is not locked");
            }
            this.lock.unlockWrite(temp);
        }
    }
}

