/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.repository.sparql;

import java.io.File;
import java.lang.ref.Cleaner;
import java.util.Collections;
import java.util.Map;
import org.apache.http.client.HttpClient;
import org.eclipse.rdf4j.common.concurrent.locks.diagnostics.ConcurrentCleaner;
import org.eclipse.rdf4j.http.client.HttpClientDependent;
import org.eclipse.rdf4j.http.client.HttpClientSessionManager;
import org.eclipse.rdf4j.http.client.SPARQLProtocolSession;
import org.eclipse.rdf4j.http.client.SessionManagerDependent;
import org.eclipse.rdf4j.http.client.SharedHttpClientSessionManager;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;
import org.eclipse.rdf4j.repository.RepositoryConnection;
import org.eclipse.rdf4j.repository.RepositoryException;
import org.eclipse.rdf4j.repository.base.AbstractRepository;
import org.eclipse.rdf4j.repository.sparql.SPARQLConnection;

public class SPARQLRepository
extends AbstractRepository
implements HttpClientDependent,
SessionManagerDependent {
    private static final ConcurrentCleaner CLEANER = new ConcurrentCleaner();
    private boolean quadMode = false;
    private volatile HttpClientSessionManager client;
    private volatile SharedHttpClientSessionManager dependentClient;
    private volatile Cleaner.Cleanable cleanable;
    private String username;
    private String password;
    private final String queryEndpointUrl;
    private final String updateEndpointUrl;
    private volatile Map<String, String> additionalHttpHeaders = Collections.emptyMap();
    private Boolean passThroughEnabled;

    public SPARQLRepository(String endpointUrl) {
        this(endpointUrl, endpointUrl);
    }

    public SPARQLRepository(String queryEndpointUrl, String updateEndpointUrl) {
        if (queryEndpointUrl == null || updateEndpointUrl == null) {
            throw new IllegalArgumentException("endpoint URL may not be null.");
        }
        this.queryEndpointUrl = queryEndpointUrl;
        this.updateEndpointUrl = updateEndpointUrl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpClientSessionManager getHttpClientSessionManager() {
        HttpClientSessionManager result = this.client;
        if (result == null) {
            SPARQLRepository sPARQLRepository = this;
            synchronized (sPARQLRepository) {
                result = this.client;
                if (result == null) {
                    SharedHttpClientSessionManager created;
                    this.dependentClient = created = new SharedHttpClientSessionManager();
                    this.client = this.dependentClient;
                    result = this.dependentClient;
                    this.cleanable = CLEANER.register(this, () -> {
                        try {
                            created.shutDown();
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    });
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setHttpClientSessionManager(HttpClientSessionManager client) {
        SPARQLRepository sPARQLRepository = this;
        synchronized (sPARQLRepository) {
            this.client = client;
            SharedHttpClientSessionManager toCloseDependentClient = this.dependentClient;
            this.dependentClient = null;
            if (toCloseDependentClient != null) {
                toCloseDependentClient.shutDown();
            }
            Cleaner.Cleanable toClean = this.cleanable;
            this.cleanable = null;
            if (toClean != null) {
                toClean.clean();
            }
        }
    }

    @Override
    public final HttpClient getHttpClient() {
        return this.getHttpClientSessionManager().getHttpClient();
    }

    @Override
    public void setHttpClient(HttpClient httpClient) {
        SharedHttpClientSessionManager toSetDependentClient = this.dependentClient;
        if (toSetDependentClient == null) {
            this.getHttpClientSessionManager();
            toSetDependentClient = this.dependentClient;
        }
        if (toSetDependentClient != null) {
            toSetDependentClient.setHttpClient(httpClient);
        }
    }

    protected SPARQLProtocolSession createSPARQLProtocolSession() {
        SPARQLProtocolSession session = this.getHttpClientSessionManager().createSPARQLProtocolSession(this.queryEndpointUrl, this.updateEndpointUrl);
        session.setValueFactory(this.getValueFactory());
        session.setAdditionalHttpHeaders(this.additionalHttpHeaders);
        if (this.username != null) {
            session.setUsernameAndPassword(this.username, this.password);
        }
        if (this.getPassThroughEnabled() != null) {
            session.setPassThroughEnabled(this.getPassThroughEnabled());
        }
        return session;
    }

    @Deprecated
    protected SPARQLProtocolSession createHTTPClient() {
        return this.createSPARQLProtocolSession();
    }

    @Override
    public RepositoryConnection getConnection() throws RepositoryException {
        if (!this.isInitialized()) {
            this.init();
        }
        return new SPARQLConnection(this, this.createSPARQLProtocolSession(), this.quadMode);
    }

    @Override
    public File getDataDir() {
        return null;
    }

    @Override
    public ValueFactory getValueFactory() {
        return SimpleValueFactory.getInstance();
    }

    @Override
    protected void initializeInternal() throws RepositoryException {
    }

    @Override
    public boolean isWritable() throws RepositoryException {
        return false;
    }

    @Override
    public void setDataDir(File dataDir) {
    }

    public void setUsernameAndPassword(String username, String password) {
        this.username = username;
        this.password = password;
    }

    @Override
    protected void shutDownInternal() throws RepositoryException {
        try {
            SharedHttpClientSessionManager toCloseDependentClient = this.dependentClient;
            this.dependentClient = null;
            if (toCloseDependentClient != null) {
                toCloseDependentClient.shutDown();
            }
        }
        finally {
            Cleaner.Cleanable toClean = this.cleanable;
            this.cleanable = null;
            if (toClean != null) {
                toClean.clean();
            }
            this.client = null;
        }
    }

    public String toString() {
        return this.queryEndpointUrl;
    }

    public Map<String, String> getAdditionalHttpHeaders() {
        return Collections.unmodifiableMap(this.additionalHttpHeaders);
    }

    public void setAdditionalHttpHeaders(Map<String, String> additionalHttpHeaders) {
        this.additionalHttpHeaders = additionalHttpHeaders == null ? Collections.emptyMap() : additionalHttpHeaders;
    }

    public void enableQuadMode(boolean flag) {
        this.quadMode = flag;
    }

    public Boolean getPassThroughEnabled() {
        return this.passThroughEnabled;
    }

    public void setPassThroughEnabled(Boolean passThroughEnabled) {
        this.passThroughEnabled = passThroughEnabled;
    }
}

