/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.collection.factory.api;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.function.ToIntBiFunction;
import java.util.function.ToIntFunction;
import org.eclipse.rdf4j.collection.factory.api.BindingSetKey;
import org.eclipse.rdf4j.common.annotation.Experimental;
import org.eclipse.rdf4j.common.annotation.InternalUseOnly;
import org.eclipse.rdf4j.common.exception.RDF4JException;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.MutableBindingSet;
import org.eclipse.rdf4j.query.impl.MapBindingSet;

@InternalUseOnly
public interface CollectionFactory
extends AutoCloseable {
    @Override
    public void close() throws RDF4JException;

    public <T> List<T> createList();

    public List<Value> createValueList();

    public <T> Set<T> createSet();

    default public Set<BindingSet> createSetOfBindingSets() {
        Function<String, Predicate<BindingSet>> gethas = n -> b -> b.hasBinding(n);
        Function<String, Function<BindingSet, Value>> getget = n -> b -> b.getValue(n);
        Function<String, BiConsumer<Value, MutableBindingSet>> getSet = n -> (v, b) -> b.setBinding(n, v);
        return this.createSetOfBindingSets(MapBindingSet::new, gethas, getget, getSet);
    }

    public Set<BindingSet> createSetOfBindingSets(Supplier<MutableBindingSet> var1, Function<String, Predicate<BindingSet>> var2, Function<String, Function<BindingSet, Value>> var3, Function<String, BiConsumer<Value, MutableBindingSet>> var4);

    public Set<Value> createValueSet();

    public <K, V> Map<K, V> createMap();

    public <V> Map<Value, V> createValueKeyedMap();

    public <T> Queue<T> createQueue();

    public Queue<Value> createValueQueue();

    @Experimental
    default public Queue<BindingSet> createBindingSetQueue(Supplier<MutableBindingSet> create, Function<String, Predicate<BindingSet>> getHas, Function<String, Function<BindingSet, Value>> getget, Function<String, BiConsumer<Value, MutableBindingSet>> getSet) {
        return this.createQueue();
    }

    @Experimental
    default public Queue<BindingSet> createBindingSetQueue() {
        Function<String, Predicate<BindingSet>> gethas = n -> b -> b.hasBinding(n);
        Function<String, Function<BindingSet, Value>> getget = n -> b -> b.getValue(n);
        Function<String, BiConsumer<Value, MutableBindingSet>> getSet = n -> (v, b) -> b.setBinding(n, v);
        return this.createBindingSetQueue(MapBindingSet::new, gethas, getget, getSet);
    }

    @InternalUseOnly
    public <E> Map<BindingSetKey, E> createGroupByMap();

    @InternalUseOnly
    public BindingSetKey createBindingSetKey(BindingSet var1, List<Function<BindingSet, Value>> var2, ToIntFunction<BindingSet> var3);

    @InternalUseOnly
    @Experimental
    private byte[] valueIntoByteArray(Value value) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try (ObjectOutputStream oos = new ObjectOutputStream(baos);){
            oos.writeObject(value);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        return baos.toByteArray();
    }

    @InternalUseOnly
    @Experimental
    private void valueIntoObjectOutputStream(Value value, ObjectOutputStream oos) throws IOException {
        oos.writeObject(value);
    }

    @InternalUseOnly
    @Experimental
    private Value valueFromObjectInputStream(ObjectInputStream ois) throws ClassNotFoundException, IOException {
        return (Value)ois.readObject();
    }

    @InternalUseOnly
    default public int hashAValue(Function<BindingSet, Value> getValue, int nextHash, BindingSet bs) {
        Value value = getValue.apply(bs);
        if (value != null) {
            return 31 * nextHash + value.hashCode();
        }
        return nextHash;
    }

    @InternalUseOnly
    default public ToIntFunction<BindingSet> hashOfBindingSetFuntion(List<Function<BindingSet, Value>> getValues) {
        if (!getValues.isEmpty()) {
            Iterator<Function<BindingSet, Value>> iterator = getValues.iterator();
            Function<BindingSet, Value> getFirstValue = iterator.next();
            ToIntFunction<BindingSet> hashFirstValue = bs -> {
                Value value = (Value)getFirstValue.apply((BindingSet)bs);
                if (value != null) {
                    return 31 + value.hashCode();
                }
                return 1;
            };
            if (!iterator.hasNext()) {
                return hashFirstValue;
            }
            ToIntBiFunction[] hashOtherValues = new ToIntBiFunction[getValues.size() - 1];
            int i = 0;
            while (iterator.hasNext()) {
                Function<BindingSet, Value> getValue = iterator.next();
                hashOtherValues[i] = (bs, nextHash) -> this.hashAValue(getValue, (int)nextHash, (BindingSet)bs);
                ++i;
            }
            switch (hashOtherValues.length) {
                case 1: {
                    ToIntBiFunction hashSecondValue = hashOtherValues[0];
                    return bs -> {
                        int nextHash = hashFirstValue.applyAsInt((BindingSet)bs);
                        return hashSecondValue.applyAsInt(bs, nextHash);
                    };
                }
                case 2: {
                    ToIntBiFunction hashSecondValue = hashOtherValues[0];
                    ToIntBiFunction hashThirdValue = hashOtherValues[1];
                    return bs -> {
                        int nextHash = hashFirstValue.applyAsInt((BindingSet)bs);
                        nextHash = hashSecondValue.applyAsInt(bs, nextHash);
                        nextHash = hashThirdValue.applyAsInt(bs, nextHash);
                        return nextHash;
                    };
                }
                case 3: {
                    ToIntBiFunction hashSecondValue = hashOtherValues[0];
                    ToIntBiFunction hashThirdValue = hashOtherValues[1];
                    ToIntBiFunction hashFourthValue = hashOtherValues[2];
                    return bs -> {
                        int nextHash = hashFirstValue.applyAsInt((BindingSet)bs);
                        nextHash = hashSecondValue.applyAsInt(bs, nextHash);
                        nextHash = hashThirdValue.applyAsInt(bs, nextHash);
                        nextHash = hashFourthValue.applyAsInt(bs, nextHash);
                        return nextHash;
                    };
                }
            }
            return bs -> {
                int nextHash = hashFirstValue.applyAsInt((BindingSet)bs);
                for (int i = 0; i < hashOtherValues.length; ++i) {
                    nextHash = hashOtherValues[i].applyAsInt(bs, nextHash);
                }
                return nextHash;
            };
        }
        return bs -> 1;
    }
}

