/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.ui.internal;

import com.google.common.collect.Maps;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import org.eclipse.buildship.core.internal.CorePlugin;
import org.eclipse.buildship.core.internal.CoreTraceScopes;
import org.eclipse.buildship.core.internal.Logger;
import org.eclipse.buildship.core.internal.console.ProcessStreamsProvider;
import org.eclipse.buildship.core.internal.event.EventListener;
import org.eclipse.buildship.core.internal.launch.GradleLaunchConfigurationManager;
import org.eclipse.buildship.core.internal.util.logging.EclipseLogger;
import org.eclipse.buildship.ui.internal.PluginImages;
import org.eclipse.buildship.ui.internal.console.ConsoleProcessStreamsProvider;
import org.eclipse.buildship.ui.internal.launch.ConsoleShowingLaunchListener;
import org.eclipse.buildship.ui.internal.launch.UiGradleLaunchConfigurationManager;
import org.eclipse.buildship.ui.internal.view.execution.ExecutionShowingLaunchRequestListener;
import org.eclipse.buildship.ui.internal.workspace.ShutdownListener;
import org.eclipse.core.runtime.Platform;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchListener;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.ui.IWorkbenchListener;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;

public final class UiPlugin
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "org.eclipse.buildship.ui";
    private static UiPlugin plugin;
    private ServiceRegistration loggerService;
    private ServiceRegistration processStreamsProviderService;
    private ServiceRegistration gradleLaunchConfigurationService;
    private ConsoleShowingLaunchListener consoleShowingLaunchListener;
    private ExecutionShowingLaunchRequestListener executionShowingLaunchRequestListener;
    private ShutdownListener shutdownListener;

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        this.registerServices(context);
        this.registerListeners();
    }

    public void stop(BundleContext context) throws Exception {
        this.unregisterListeners();
        this.unregisterServices();
        plugin = null;
        super.stop(context);
    }

    private void registerServices(BundleContext context) {
        Hashtable<String, Object> preferences = new Hashtable<String, Object>();
        ((Dictionary)preferences).put("service.ranking", 1);
        Hashtable<String, Object> priorityPreferences = new Hashtable<String, Object>();
        ((Dictionary)priorityPreferences).put("service.ranking", 2);
        this.loggerService = this.registerService(context, Logger.class, this.createLogger(), preferences);
        this.processStreamsProviderService = this.registerService(context, ProcessStreamsProvider.class, this.createConsoleProcessStreamsProvider(), priorityPreferences);
        this.gradleLaunchConfigurationService = this.registerService(context, GradleLaunchConfigurationManager.class, this.createLaunchConfigurationManager(), priorityPreferences);
    }

    private <T> ServiceRegistration registerService(BundleContext context, Class<T> clazz, T service, Dictionary<String, Object> properties) {
        return context.registerService(clazz.getName(), service, properties);
    }

    private EclipseLogger createLogger() {
        HashMap tracingEnablement = Maps.newHashMap();
        for (CoreTraceScopes scope : CoreTraceScopes.values()) {
            String option = Platform.getDebugOption((String)("org.eclipse.buildship.ui/trace/" + scope.getScopeKey()));
            tracingEnablement.put(scope, "true".equalsIgnoreCase(option));
        }
        return new EclipseLogger(this.getLog(), PLUGIN_ID, (Map)tracingEnablement);
    }

    private ProcessStreamsProvider createConsoleProcessStreamsProvider() {
        return new ConsoleProcessStreamsProvider();
    }

    private GradleLaunchConfigurationManager createLaunchConfigurationManager() {
        return new UiGradleLaunchConfigurationManager(CorePlugin.gradleLaunchConfigurationManager());
    }

    private void unregisterServices() {
        this.gradleLaunchConfigurationService.unregister();
        this.processStreamsProviderService.unregister();
        this.loggerService.unregister();
    }

    private void registerListeners() {
        this.consoleShowingLaunchListener = new ConsoleShowingLaunchListener();
        this.consoleShowingLaunchListener.handleAlreadyRunningLaunches();
        DebugPlugin.getDefault().getLaunchManager().addLaunchListener((ILaunchListener)this.consoleShowingLaunchListener);
        this.executionShowingLaunchRequestListener = new ExecutionShowingLaunchRequestListener();
        CorePlugin.listenerRegistry().addEventListener((EventListener)this.executionShowingLaunchRequestListener);
        this.shutdownListener = new ShutdownListener();
        PlatformUI.getWorkbench().addWorkbenchListener((IWorkbenchListener)this.shutdownListener);
    }

    private void unregisterListeners() {
        PlatformUI.getWorkbench().removeWorkbenchListener((IWorkbenchListener)this.shutdownListener);
        CorePlugin.listenerRegistry().removeEventListener((EventListener)this.executionShowingLaunchRequestListener);
        DebugPlugin.getDefault().getLaunchManager().removeLaunchListener((ILaunchListener)this.consoleShowingLaunchListener);
    }

    public static UiPlugin getInstance() {
        return plugin;
    }

    public static Logger logger() {
        return (Logger)UiPlugin.getService(UiPlugin.getInstance().loggerService.getReference());
    }

    private static <T> T getService(ServiceReference reference) {
        return (T)reference.getBundle().getBundleContext().getService(reference);
    }

    protected void initializeImageRegistry(ImageRegistry imageRegistry) {
        for (PluginImages pluginImage : PluginImages.values()) {
            pluginImage.register();
        }
    }
}

