/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.gdb.internal.ui.launching;

import java.io.File;
import org.eclipse.cdt.dsf.gdb.internal.ui.commands.Messages;
import org.eclipse.cdt.dsf.gdb.internal.ui.launching.NewExecutableInfo;
import org.eclipse.cdt.dsf.gdb.launching.LaunchMessages;
import org.eclipse.cdt.dsf.gdb.service.SessionType;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class NewExecutableDialog
extends TitleAreaDialog {
    private NewExecutableInfo fInfo = null;
    private Text fHostBinaryText;
    private Text fTargetBinaryText;
    private Text fArgumentsText;
    private Button fStopInMain;
    private Text fStopInMainSymbol;

    public NewExecutableDialog(Shell parentShell, NewExecutableInfo info) {
        super(parentShell);
        assert (info != null);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.fInfo = info;
    }

    protected Control createContents(Composite parent) {
        Control control = super.createContents(parent);
        this.initialize();
        this.validate();
        return control;
    }

    protected Control createDialogArea(Composite parent) {
        boolean remote = this.fInfo.getSessionType() == SessionType.REMOTE;
        this.getShell().setText(Messages.GdbDebugNewExecutableCommand_Debug_New_Executable);
        this.setTitle(Messages.GdbDebugNewExecutableCommand_Select_Binary);
        String message = remote ? Messages.GdbDebugNewExecutableCommand_Select_binaries_on_host_and_target : Messages.GdbDebugNewExecutableCommand_Select_binary_and_specify_arguments;
        this.setMessage(message);
        Composite control = (Composite)super.createDialogArea(parent);
        Composite comp = new Composite(control, 0);
        GridData gd = new GridData(4, 4, true, true);
        GridLayout layout = new GridLayout(3, false);
        comp.setLayout((Layout)layout);
        comp.setLayoutData((Object)gd);
        new Label(comp, 0).setText(remote ? Messages.GdbDebugNewExecutableCommand_Binary_on_host : Messages.GdbDebugNewExecutableCommand_Binary);
        this.fHostBinaryText = new Text(comp, 2048);
        this.fHostBinaryText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.fHostBinaryText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                NewExecutableDialog.this.validate();
            }
        });
        Button browseButton = new Button(comp, 8);
        browseButton.setText(Messages.GdbDebugNewExecutableCommand_Browse);
        browseButton.setFont(JFaceResources.getDialogFont());
        this.setButtonLayoutData(browseButton);
        browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog dialog = new FileDialog(NewExecutableDialog.this.getShell());
                dialog.setFileName(NewExecutableDialog.this.fHostBinaryText.getText());
                String result = dialog.open();
                if (result != null) {
                    NewExecutableDialog.this.fHostBinaryText.setText(result);
                }
            }
        });
        if (remote) {
            new Label(comp, 0).setText(Messages.GdbDebugNewExecutableCommand_Binary_on_target);
            this.fTargetBinaryText = new Text(comp, 2048);
            this.fTargetBinaryText.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
            this.fTargetBinaryText.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    NewExecutableDialog.this.validate();
                }
            });
        }
        new Label(comp, 0).setText(Messages.GdbDebugNewExecutableCommand_Arguments);
        this.fArgumentsText = new Text(comp, 2048);
        this.fArgumentsText.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.createOptionsArea(comp);
        return control;
    }

    protected void createOptionsArea(Composite parent) {
        Composite optionsComp = new Composite(parent, 0);
        GridLayout layout = new GridLayout(3, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        optionsComp.setLayout((Layout)layout);
        optionsComp.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 3, 1));
        this.fStopInMain = new Button(optionsComp, 32);
        this.fStopInMain.setText(LaunchMessages.getString((String)"CDebuggerTab.Stop_at_main_on_startup"));
        this.fStopInMain.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NewExecutableDialog.this.fStopInMainSymbol.setEnabled(NewExecutableDialog.this.fStopInMain.getSelection());
                NewExecutableDialog.this.validate();
            }
        });
        this.fStopInMainSymbol = new Text(optionsComp, 2052);
        GridData gridData = new GridData(4, 0x1000000, false, false);
        gridData.widthHint = 100;
        this.fStopInMainSymbol.setLayoutData((Object)gridData);
        this.fStopInMainSymbol.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent evt) {
                NewExecutableDialog.this.validate();
            }
        });
        this.fStopInMainSymbol.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                e.result = LaunchMessages.getString((String)"CDebuggerTab.Stop_at_main_on_startup");
            }
        });
    }

    protected void okPressed() {
        this.fInfo.setHostPath(this.fHostBinaryText.getText().trim());
        String targetPath = this.fTargetBinaryText != null ? this.fTargetBinaryText.getText().trim() : null;
        this.fInfo.setAttribute("org.eclipse.cdt.dsf.gdb.REMOTE_BINARY", targetPath);
        String args = this.fArgumentsText.getText().trim();
        this.fInfo.setAttribute("org.eclipse.cdt.launch.PROGRAM_ARGUMENTS", args);
        this.saveOptions();
        super.okPressed();
    }

    protected void initialize() {
        this.fHostBinaryText.setText(this.fInfo.getHostPath());
        if (this.fTargetBinaryText != null) {
            String targetPath = this.fInfo.getTargetPath();
            this.fTargetBinaryText.setText(targetPath != null ? targetPath : "");
        }
        this.fArgumentsText.setText(this.fInfo.getArguments());
        if (this.fStopInMain != null && this.fStopInMainSymbol != null) {
            this.fStopInMain.setSelection(((Boolean)this.fInfo.getAttribute("org.eclipse.cdt.launch.DEBUGGER_STOP_AT_MAIN")).booleanValue());
            this.fStopInMainSymbol.setText((String)this.fInfo.getAttribute("org.eclipse.cdt.launch.DEBUGGER_STOP_AT_MAIN_SYMBOL"));
        }
    }

    protected void validate() {
        boolean remote = this.fInfo.getSessionType() == SessionType.REMOTE;
        StringBuilder sb = new StringBuilder();
        String hostBinary = this.fHostBinaryText.getText().trim();
        if (hostBinary.isEmpty()) {
            sb.append(remote ? Messages.GdbDebugNewExecutableCommand_Host_binary_must_be_specified : Messages.GdbDebugNewExecutableCommand_Binary_must_be_specified);
        } else {
            File file = new File(hostBinary);
            if (!file.exists()) {
                sb.append(remote ? Messages.GdbDebugNewExecutableCommand_Host_binary_file_does_not_exist : Messages.GdbDebugNewExecutableCommand_Binary_file_does_not_exist);
            } else if (file.isDirectory()) {
                sb.append(remote ? Messages.GdbDebugNewExecutableCommand_Invalid_host_binary : Messages.GdbDebugNewExecutableCommand_Invalid_binary);
            }
        }
        if (this.fTargetBinaryText != null && this.fTargetBinaryText.getText().trim().length() == 0) {
            if (sb.length() != 0) {
                sb.append("\n ");
            }
            sb.append(Messages.GdbDebugNewExecutableCommand_Binary_on_target_must_be_specified);
        }
        if (this.fStopInMain != null && this.fStopInMainSymbol != null) {
            String mainSymbol = this.fStopInMainSymbol.getText().trim();
            if (this.fStopInMain.getSelection() && mainSymbol.length() == 0) {
                if (sb.length() > 0) {
                    sb.append("\n ");
                }
                sb.append(LaunchMessages.getString((String)"CDebuggerTab.Stop_on_startup_at_can_not_be_empty"));
            }
        }
        this.setErrorMessage(sb.length() != 0 ? sb.toString() : null);
        this.getButton(0).setEnabled(this.getErrorMessage() == null);
    }

    protected void saveOptions() {
        if (this.fStopInMain != null && this.fStopInMainSymbol != null) {
            this.fInfo.setAttribute("org.eclipse.cdt.launch.DEBUGGER_STOP_AT_MAIN", this.fStopInMain.getSelection());
            this.fInfo.setAttribute("org.eclipse.cdt.launch.DEBUGGER_STOP_AT_MAIN_SYMBOL", this.fStopInMainSymbol.getText().trim());
        }
    }
}

