/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.sybase.asa.schemaobjecteditor.examples.tableeditor.pages.constraints;

import java.util.Iterator;
import org.eclipse.datatools.enablement.sybase.asa.schemaobjecteditor.examples.commonui.privilege.FolderNode;
import org.eclipse.datatools.enablement.sybase.asa.schemaobjecteditor.examples.commonui.privilege.LeafNode;
import org.eclipse.datatools.enablement.sybase.asa.schemaobjecteditor.examples.utils.SybaseImages;
import org.eclipse.datatools.modelbase.sql.constraints.CheckConstraint;
import org.eclipse.datatools.modelbase.sql.constraints.ForeignKey;
import org.eclipse.datatools.modelbase.sql.constraints.PrimaryKey;
import org.eclipse.datatools.modelbase.sql.constraints.UniqueConstraint;
import org.eclipse.datatools.modelbase.sql.schema.SQLObject;
import org.eclipse.datatools.modelbase.sql.tables.Column;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.swt.graphics.Image;

public class ConstraintsLabelProvider
implements ITableLabelProvider {
    public Image getColumnImage(Object element, int columnIndex) {
        if (!(element instanceof LeafNode) && columnIndex == 0) {
            return SybaseImages.get("org.eclipse.datatools.enablement.sybasefolder.gif");
        }
        if (columnIndex == 0 && element instanceof LeafNode) {
            LeafNode leafNode = (LeafNode)element;
            Object constraint = leafNode.getData();
            if (constraint instanceof PrimaryKey) {
                return SybaseImages.get("org.eclipse.datatools.enablement.sybaseprimaryKey.gif");
            }
            if (constraint instanceof UniqueConstraint) {
                return SybaseImages.get("org.eclipse.datatools.enablement.sybaseunique_constraint.gif");
            }
            if (constraint instanceof ForeignKey) {
                return SybaseImages.get("org.eclipse.datatools.enablement.sybaseforeignKey.gif");
            }
            if (constraint instanceof CheckConstraint) {
                return SybaseImages.get("org.eclipse.datatools.enablement.sybasecheck_constraint.gif");
            }
        }
        return null;
    }

    public String getColumnText(Object element, int columnIndex) {
        if (!(element instanceof FolderNode)) {
            return "";
        }
        FolderNode node = (FolderNode)element;
        switch (columnIndex) {
            case 0: {
                if (node instanceof LeafNode) {
                    LeafNode leafNode = (LeafNode)element;
                    String dspName = "";
                    if (leafNode.isDirty()) {
                        dspName = "* ";
                    }
                    if (((SQLObject)leafNode.getData()).getName() != null) {
                        dspName = String.valueOf(dspName) + ((SQLObject)leafNode.getData()).getName();
                    }
                    return dspName;
                }
                return node.getName();
            }
            case 1: {
                if (!(element instanceof LeafNode)) {
                    return "";
                }
                LeafNode leafNode = (LeafNode)element;
                Object constraint = leafNode.getData();
                if (constraint instanceof UniqueConstraint) {
                    UniqueConstraint unique = (UniqueConstraint)constraint;
                    StringBuffer sb = new StringBuffer("(");
                    Iterator iter = unique.getMembers().iterator();
                    while (iter.hasNext()) {
                        if (!sb.toString().equals("(")) {
                            sb.append(",");
                        }
                        Column col = (Column)iter.next();
                        sb.append(col.getName());
                    }
                    sb.append(")");
                    return sb.toString();
                }
                if (constraint instanceof ForeignKey) {
                    Column col;
                    ForeignKey fk = (ForeignKey)constraint;
                    StringBuffer sb = new StringBuffer("(");
                    Iterator iter = fk.getMembers().iterator();
                    while (iter.hasNext()) {
                        if (!sb.toString().equals("(")) {
                            sb.append(",");
                        }
                        col = (Column)iter.next();
                        sb.append(col.getName());
                    }
                    sb.append(") reference ").append(fk.getReferencedTable() == null ? "" : fk.getReferencedTable().getName()).append("(");
                    iter = fk.getReferencedMembers().iterator();
                    while (iter.hasNext()) {
                        if (sb.toString().charAt(sb.length() - 1) != '(') {
                            sb.append(",");
                        }
                        col = (Column)iter.next();
                        sb.append(col.getName());
                    }
                    sb.append(")");
                    return sb.toString();
                }
                if (!(constraint instanceof CheckConstraint)) break;
                CheckConstraint ck = (CheckConstraint)constraint;
                return ck.getSearchCondition() == null ? "" : ck.getSearchCondition().getSQL();
            }
        }
        return "";
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public void dispose() {
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
    }
}

