/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.validators.internal.externalchecker.ui;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.dltk.internal.ui.editor.EditorUtility;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.console.IHyperlink;
import org.eclipse.ui.console.TextConsole;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;

public abstract class ExternalCheckerGenericHyperlink
implements IHyperlink {
    private TextConsole fConsole;

    public ExternalCheckerGenericHyperlink(TextConsole console) {
        this.fConsole = console;
    }

    public void linkEntered() {
    }

    public void linkExited() {
    }

    protected TextConsole getConsole() {
        return this.fConsole;
    }

    protected String getLinkText() throws CoreException {
        try {
            IDocument document = this.getConsole().getDocument();
            IRegion region = this.getConsole().getRegion((IHyperlink)this);
            int regionOffset = region.getOffset();
            int lineNumber = document.getLineOfOffset(regionOffset);
            IRegion lineInformation = document.getLineInformation(lineNumber);
            int lineOffset = lineInformation.getOffset();
            String line = document.get(lineOffset, lineInformation.getLength());
            return line;
        }
        catch (BadLocationException e) {
            return "";
        }
    }

    protected abstract String getFileName();

    protected abstract int getLineNumber();

    public void linkActivated() {
        block8: {
            try {
                Object sourceElement;
                int lineNumber;
                String fileName;
                try {
                    String linkText = this.getLinkText();
                    fileName = this.getFileName();
                    lineNumber = this.getLineNumber();
                }
                catch (CoreException e1) {
                    return;
                }
                if (lineNumber > 0) {
                    --lineNumber;
                }
                if ((sourceElement = this.getSourceModule(fileName)) == null) break block8;
                IEditorPart part = EditorUtility.openInEditor((Object)sourceElement);
                IEditorPart editorPart = EditorUtility.openInEditor((Object)sourceElement);
                if (editorPart instanceof ITextEditor && lineNumber >= 0) {
                    ITextEditor textEditor = (ITextEditor)editorPart;
                    IDocumentProvider provider = textEditor.getDocumentProvider();
                    IEditorInput input = part.getEditorInput();
                    provider.connect((Object)input);
                    IDocument document = provider.getDocument((Object)input);
                    try {
                        IRegion line = document.getLineInformation(lineNumber);
                        textEditor.selectAndReveal(line.getOffset(), line.getLength());
                    }
                    catch (BadLocationException badLocationException) {
                        // empty catch block
                    }
                    provider.disconnect((Object)input);
                }
                return;
            }
            catch (CoreException e) {
                return;
            }
        }
    }

    public String getEditorId(IEditorInput input, Object inputObject) {
        try {
            IEditorDescriptor descriptor = IDE.getEditorDescriptor((String)input.getName(), (boolean)true, (boolean)false);
            return descriptor.getId();
        }
        catch (PartInitException e) {
            return null;
        }
    }

    protected Object getSourceModule(String fileName) throws CoreException {
        IFile f = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation((IPath)new Path(fileName));
        return f;
    }
}

