/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.scm.internal.wizards;

import java.util.LinkedHashSet;
import org.apache.maven.model.Scm;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.RegistryFactory;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.m2e.core.project.ProjectImportConfiguration;
import org.eclipse.m2e.core.ui.internal.IMavenDiscovery;
import org.eclipse.m2e.core.ui.internal.wizards.AbstractMavenWizardPage;
import org.eclipse.m2e.scm.ScmTag;
import org.eclipse.m2e.scm.ScmUrl;
import org.eclipse.m2e.scm.internal.Messages;
import org.eclipse.m2e.scm.internal.ScmHandlerFactory;
import org.eclipse.m2e.scm.spi.ScmHandlerUi;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Text;

public class MavenCheckoutLocationPage
extends AbstractMavenWizardPage {
    String scmType;
    ScmUrl[] scmUrls;
    String scmParentUrl;
    Combo scmTypeCombo;
    Combo scmUrlCombo;
    Button scmUrlBrowseButton;
    Button headRevisionButton;
    Label revisionLabel;
    Text revisionText;
    Button revisionBrowseButton;
    private Button checkoutAllProjectsButton;
    private Link m2eMarketplace;

    protected MavenCheckoutLocationPage(ProjectImportConfiguration projectImportConfiguration) {
        super("MavenCheckoutLocationPage", projectImportConfiguration);
        this.setTitle(Messages.MavenCheckoutLocationPage_title);
        this.setDescription(Messages.MavenCheckoutLocationPage_description);
    }

    public void createControl(Composite parent) {
        ScmTag tag;
        Composite composite = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(5, false);
        gridLayout.verticalSpacing = 0;
        composite.setLayout((Layout)gridLayout);
        this.setControl((Control)composite);
        SelectionListener selectionAdapter = SelectionListener.widgetSelectedAdapter(e -> this.updatePage());
        if (this.scmUrls == null || this.scmUrls.length < 2) {
            String[] types;
            Label urlLabel = new Label(composite, 0);
            urlLabel.setText(Messages.MavenCheckoutLocationPage_lblurl);
            this.scmTypeCombo = new Combo(composite, 8);
            GridData gd_scmTypeCombo = new GridData(4, 0x1000000, false, false);
            gd_scmTypeCombo.widthHint = 80;
            this.scmTypeCombo.setLayoutData((Object)gd_scmTypeCombo);
            this.scmTypeCombo.setData("name", (Object)"mavenCheckoutLocation.typeCombo");
            String[] stringArray = types = ScmHandlerFactory.getTypes();
            int n = types.length;
            int n2 = 0;
            while (n2 < n) {
                String type = stringArray[n2];
                this.scmTypeCombo.add(type);
                ++n2;
            }
            this.scmTypeCombo.addModifyListener(e -> {
                String newScmType = this.scmTypeCombo.getText();
                if (!newScmType.equals(this.scmType)) {
                    this.scmType = newScmType;
                    this.scmUrlCombo.setText("");
                    this.updatePage();
                }
            });
            if (this.scmUrls != null && this.scmUrls.length == 1) {
                try {
                    this.scmType = ScmUrl.getType(this.scmUrls[0].getUrl());
                }
                catch (CoreException type) {
                    // empty catch block
                }
            }
            this.scmUrlCombo = new Combo(composite, 0);
            this.scmUrlCombo.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
            this.scmUrlCombo.setData("name", (Object)"mavenCheckoutLocation.urlCombo");
            this.scmUrlBrowseButton = new Button(composite, 0);
            this.scmUrlBrowseButton.setText(Messages.MavenCheckoutLocationPage_btnBrowse);
        }
        this.headRevisionButton = new Button(composite, 32);
        GridData headRevisionButtonData = new GridData(16384, 0x1000000, false, false, 5, 1);
        headRevisionButtonData.verticalIndent = 5;
        this.headRevisionButton.setLayoutData((Object)headRevisionButtonData);
        this.headRevisionButton.setText(Messages.MavenCheckoutLocationPage_btnHead);
        this.headRevisionButton.setSelection(true);
        this.headRevisionButton.addSelectionListener(selectionAdapter);
        this.revisionLabel = new Label(composite, 16);
        GridData revisionButtonData = new GridData();
        revisionButtonData.horizontalIndent = 10;
        this.revisionLabel.setLayoutData((Object)revisionButtonData);
        this.revisionLabel.setText(Messages.MavenCheckoutLocationPage_lblRevision);
        this.revisionText = new Text(composite, 2048);
        GridData revisionTextData = new GridData(16384, 0x1000000, false, false, 2, 1);
        revisionTextData.widthHint = 115;
        revisionTextData.verticalIndent = 3;
        this.revisionText.setLayoutData((Object)revisionTextData);
        if (this.scmUrls != null && (tag = this.scmUrls[0].getTag()) != null) {
            this.headRevisionButton.setSelection(false);
            this.revisionText.setText(tag.getName());
        }
        this.revisionText.addModifyListener(e -> this.updatePage());
        this.revisionBrowseButton = new Button(composite, 0);
        GridData gd_revisionBrowseButton = new GridData(16384, 0x1000000, false, false, 2, 1);
        gd_revisionBrowseButton.verticalIndent = 3;
        this.revisionBrowseButton.setLayoutData((Object)gd_revisionBrowseButton);
        this.revisionBrowseButton.setText(Messages.MavenCheckoutLocationPage_btnRevSelect);
        this.revisionBrowseButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            String url = this.scmParentUrl;
            if (url == null) {
                return;
            }
            String scmType = this.scmTypeCombo.getText();
            ScmHandlerUi handlerUi = ScmHandlerFactory.getHandlerUiByType(scmType);
            String revision = handlerUi.selectRevision(this.getShell(), this.scmUrls[0], this.revisionText.getText());
            if (revision != null) {
                this.revisionText.setText(revision);
                this.headRevisionButton.setSelection(false);
                this.updatePage();
            }
        }));
        this.checkoutAllProjectsButton = new Button(composite, 32);
        GridData checkoutAllProjectsData = new GridData(16384, 128, true, false, 5, 1);
        checkoutAllProjectsData.verticalIndent = 10;
        this.checkoutAllProjectsButton.setLayoutData((Object)checkoutAllProjectsData);
        this.checkoutAllProjectsButton.setText(Messages.MavenCheckoutLocationPage_btnCheckout);
        this.checkoutAllProjectsButton.setSelection(true);
        this.checkoutAllProjectsButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> this.updatePage()));
        GridData advancedSettingsData = new GridData(4, 128, true, false, 5, 1);
        advancedSettingsData.verticalIndent = 10;
        this.createAdvancedSettings(composite, advancedSettingsData);
        if (this.scmUrls != null && this.scmUrls.length == 1) {
            this.scmTypeCombo.setText(this.scmType == null ? "" : this.scmType);
            this.scmUrlCombo.setText(this.scmUrls[0].getProviderUrl());
        }
        if (this.scmUrls == null || this.scmUrls.length < 2) {
            this.scmUrlBrowseButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
                ScmHandlerUi handlerUi = ScmHandlerFactory.getHandlerUiByType(this.scmType);
                ScmUrl currentUrl = this.scmUrls == null || this.scmUrls.length == 0 ? new ScmUrl("scm:" + this.scmType + ":") : this.scmUrls[0];
                ScmUrl scmUrl = handlerUi.selectUrl(this.getShell(), currentUrl);
                if (scmUrl != null) {
                    this.scmUrlCombo.setText(scmUrl.getProviderUrl());
                    if (this.scmUrls == null) {
                        this.scmUrls = new ScmUrl[1];
                    }
                    this.scmUrls[0] = scmUrl;
                    this.scmParentUrl = scmUrl.getUrl();
                    this.updatePage();
                }
            }));
            this.scmUrlCombo.addModifyListener(e -> {
                ScmUrl scmUrl;
                String url = this.scmUrlCombo.getText().trim();
                if (url.startsWith("scm:")) {
                    try {
                        String type = ScmUrl.getType(url);
                        this.scmTypeCombo.setText(type);
                        this.scmType = type;
                        Display.getDefault().asyncExec(() -> this.scmUrlCombo.setText(url.substring(type.length() + 5)));
                    }
                    catch (CoreException type) {
                        // empty catch block
                    }
                    return;
                }
                if (this.scmUrls == null) {
                    this.scmUrls = new ScmUrl[1];
                }
                this.scmUrls[0] = scmUrl = new ScmUrl("scm:" + this.scmType + ":" + url);
                this.scmParentUrl = scmUrl.getUrl();
                this.updatePage();
            });
        }
        if (Platform.getBundle((String)"org.eclipse.m2e.discovery") != null) {
            this.m2eMarketplace = new Link(composite, 0);
            this.m2eMarketplace.setLayoutData((Object)new GridData(0x1000008, 0x1000008, true, true, 5, 1));
            this.m2eMarketplace.setText(Messages.MavenCheckoutLocationPage_linkMarketPlace);
            this.m2eMarketplace.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    IExtension[] extension;
                    IExtensionRegistry registry;
                    IExtensionPoint point;
                    IWizardContainer container = MavenCheckoutLocationPage.this.getWizard().getContainer();
                    if (container instanceof WizardDialog) {
                        ((WizardDialog)container).close();
                    }
                    if ((point = (registry = RegistryFactory.getRegistry()).getExtensionPoint("org.eclipse.m2e.core.ui.discoveryLaunch")) != null && (extension = point.getExtensions()).length > 0) {
                        IConfigurationElement[] iConfigurationElementArray = extension[0].getConfigurationElements();
                        int n = iConfigurationElementArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            IConfigurationElement element = iConfigurationElementArray[n2];
                            if ("launcher".equals(element.getName())) {
                                try {
                                    ((IMavenDiscovery)element.createExecutableExtension("class")).launch(Display.getCurrent().getActiveShell());
                                    break;
                                }
                                catch (CoreException coreException) {
                                    // empty catch block
                                }
                            }
                            ++n2;
                        }
                    }
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
        }
        this.updatePage();
    }

    public void setVisible(boolean visible) {
        String[] items;
        super.setVisible(visible);
        if (this.scmType == null && this.scmTypeCombo != null && this.scmTypeCombo.getItems().length == 1 && !this.scmTypeCombo.getItem(0).isEmpty()) {
            this.scmTypeCombo.select(0);
        }
        if (this.dialogSettings != null && this.scmUrlCombo != null && (items = this.dialogSettings.getArray("scmUrl")) != null) {
            String text = this.scmUrlCombo.getText();
            this.scmUrlCombo.setItems(items);
            if (text.length() > 0) {
                this.scmUrlCombo.setText(text);
            }
        }
    }

    public void dispose() {
        if (this.dialogSettings != null && this.scmUrlCombo != null) {
            LinkedHashSet<Object> history = new LinkedHashSet<Object>(15);
            String lastValue = this.scmUrlCombo.getText();
            if (lastValue != null && lastValue.trim().length() > 0) {
                history.add("scm:" + this.scmType + ":" + lastValue);
            }
            String[] items = this.scmUrlCombo.getItems();
            int j = 0;
            while (j < items.length && history.size() < 15) {
                history.add(items[j]);
                ++j;
            }
            this.dialogSettings.put("scmUrl", history.toArray(new String[history.size()]));
        }
        super.dispose();
    }

    public IWizardContainer getContainer() {
        return super.getContainer();
    }

    void updatePage() {
        boolean canSelectUrl = false;
        boolean canSelectRevision = false;
        ScmHandlerUi handlerUi = ScmHandlerFactory.getHandlerUiByType(this.scmType);
        if (handlerUi != null) {
            canSelectUrl = handlerUi.canSelectUrl();
            canSelectRevision = handlerUi.canSelectRevision();
        }
        if (this.scmUrlBrowseButton != null) {
            this.scmUrlBrowseButton.setEnabled(canSelectUrl);
            this.scmUrlBrowseButton.setVisible(canSelectUrl);
        }
        this.revisionBrowseButton.setEnabled(canSelectRevision);
        this.revisionBrowseButton.setVisible(canSelectRevision);
        boolean isHeadRevision = this.isHeadRevision();
        this.revisionLabel.setEnabled(!isHeadRevision);
        this.revisionText.setEnabled(!isHeadRevision);
        this.setPageComplete(this.isPageValid());
    }

    private boolean isPageValid() {
        this.setErrorMessage(null);
        boolean emptyUrl = this.isEmptyScmUrl(this.scmUrls);
        if (this.scmType == null && emptyUrl) {
            this.setErrorMessage(Messages.MavenCheckoutLocationPage_error_empty);
            return false;
        }
        if (emptyUrl) {
            this.setErrorMessage(Messages.MavenCheckoutLocationPage_error_empty_url);
            return false;
        }
        ScmHandlerUi handlerUi = ScmHandlerFactory.getHandlerUiByType(this.scmType);
        if (handlerUi != null && !handlerUi.isValidUrl(this.scmUrls[0].getUrl())) {
            this.setErrorMessage(Messages.MavenCheckoutLocationPage_error_url_empty);
            return false;
        }
        if (!this.isHeadRevision()) {
            String revision = this.revisionText.getText().trim();
            if (revision.length() == 0) {
                this.setErrorMessage(Messages.MavenCheckoutLocationPage_error_scm_empty);
                return false;
            }
            if (handlerUi != null && !handlerUi.isValidRevision(null, revision)) {
                this.setErrorMessage(Messages.MavenCheckoutLocationPage_error_scm_invalid);
                return false;
            }
        }
        return true;
    }

    private boolean isEmptyScmUrl(ScmUrl[] scmUrls) {
        if (scmUrls == null || scmUrls.length == 0) {
            return true;
        }
        String type = null;
        String url = scmUrls[0].getUrl();
        if (url != null) {
            try {
                type = ScmUrl.getType(url);
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }
        return url == null || url.isEmpty() || ("scm:" + type + ":").equals(url);
    }

    public void setParent(String parentUrl) {
        this.scmParentUrl = parentUrl;
    }

    public void setUrls(ScmUrl[] urls) {
        this.scmUrls = urls;
    }

    public ScmUrl[] getUrls() {
        return this.scmUrls;
    }

    public Scm[] getScms() {
        if (this.scmUrls == null) {
            return new Scm[0];
        }
        String revision = this.getRevision();
        Scm[] scms = new Scm[this.scmUrls.length];
        int i = 0;
        while (i < scms.length) {
            Scm scm = new Scm();
            scm.setConnection(this.scmUrls[i].getUrl());
            scm.setTag(revision);
            scms[i] = scm;
            ++i;
        }
        return scms;
    }

    public boolean isCheckoutAllProjects() {
        return this.checkoutAllProjectsButton.getSelection();
    }

    public boolean isHeadRevision() {
        return this.headRevisionButton.getSelection();
    }

    public String getRevision() {
        if (this.isHeadRevision()) {
            return "HEAD";
        }
        return this.revisionText.getText().trim();
    }

    public void addListener(SelectionListener listener) {
        ModifyListener listenerProxy = e -> {
            Event event = new Event();
            event.widget = e.widget;
            listener.widgetSelected(new SelectionEvent(event));
        };
        this.scmUrlCombo.addModifyListener(listenerProxy);
        this.revisionText.addModifyListener(listenerProxy);
        this.headRevisionButton.addSelectionListener(listener);
    }
}

