/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.internal.collectionextract;

import org.eclipse.mat.SnapshotException;
import org.eclipse.mat.collect.ArrayInt;
import org.eclipse.mat.internal.Messages;
import org.eclipse.mat.internal.collectionextract.ExtractionUtils;
import org.eclipse.mat.internal.collectionextract.FieldSizedCollectionExtractor;
import org.eclipse.mat.snapshot.ISnapshot;
import org.eclipse.mat.snapshot.model.IObject;
import org.eclipse.mat.util.MessageUtil;
import org.eclipse.mat.util.VoidProgressListener;

public class LinkedListCollectionExtractor
extends FieldSizedCollectionExtractor {
    private final String leadField;

    public LinkedListCollectionExtractor(String sizeField, String leadField) {
        super(sizeField);
        this.leadField = leadField;
    }

    @Override
    public boolean hasExtractableContents() {
        return true;
    }

    @Override
    public int[] extractEntryIds(IObject list) throws SnapshotException {
        IObject o;
        int i;
        int n;
        int n2;
        int[] nArray;
        ISnapshot snapshot;
        Integer s;
        VoidProgressListener listener = new VoidProgressListener();
        int size = super.hasSize() && (s = super.getSize(list)) != null ? s : 10000000;
        String taskMsg = MessageUtil.format((String)Messages.ExtractListValuesQuery_CollectingElements, (Object[])new Object[]{size, list.getTechnicalName()});
        listener.beginTask(taskMsg, size);
        ArrayInt result = new ArrayInt();
        int loopingLimit = size;
        IObject header = (IObject)list.resolveValue("header");
        if (header == null) {
            header = (IObject)list.resolveValue("voidLink");
        }
        if (header == null) {
            header = (IObject)list.resolveValue("first");
        }
        if (header == null && (header = ExtractionUtils.followOnlyOutgoingReferencesExceptLast(this.leadField, list)) == null) {
            header = list;
        }
        IObject tail = null;
        if (header == list) {
            IObject first = null;
            IObject second = null;
            snapshot = header.getSnapshot();
            nArray = snapshot.getOutboundReferentIds(header.getObjectId());
            n2 = nArray.length;
            n = 0;
            while (n < n2) {
                String tn;
                i = nArray[n];
                o = snapshot.getObject(i);
                if (i != header.getClazz().getObjectId() && ((tn = o.getClazz().getName()).endsWith("$Entry") || tn.endsWith("$Node"))) {
                    if (first == null) {
                        first = o;
                    } else if (first.getClass().equals(o.getClass()) && second == null) {
                        second = o;
                    } else {
                        first = null;
                        second = null;
                        break;
                    }
                }
                ++n;
            }
            if (first != null) {
                header = first;
                tail = second;
            }
        }
        if (header == null) {
            return new int[0];
        }
        IObject previous = header;
        IObject current = header;
        if (current.getClazz().getName().equals("java.util.LinkedList$Entry") || current.getClazz().getName().equals("java.util.LinkedList$Link") || current.getClazz().getName().equals("java.util.concurrent.LinkedBlockingQueue$Node")) {
            current = (IObject)header.resolveValue("next");
            if (current == null) {
                snapshot = header.getSnapshot();
                nArray = snapshot.getOutboundReferentIds(header.getObjectId());
                n2 = nArray.length;
                n = 0;
                while (n < n2) {
                    i = nArray[n];
                    o = snapshot.getObject(i);
                    if (i != header.getClazz().getObjectId() && o.getClazz().equals(header.getClazz())) {
                        current = o;
                        break;
                    }
                    ++n;
                }
            }
        } else {
            header = null;
        }
        while (current != null && current != header && loopingLimit-- > 0) {
            IObject next;
            IObject ref = (IObject)current.resolveValue("element");
            if (ref == null) {
                ref = (IObject)current.resolveValue("data");
            }
            if (ref == null) {
                ref = (IObject)current.resolveValue("item");
            }
            if (current.equals(ref)) {
                ref = null;
            }
            if ((next = (IObject)current.resolveValue("next")) == null) {
                ISnapshot snapshot2 = current.getSnapshot();
                int[] nArray2 = snapshot2.getOutboundReferentIds(current.getObjectId());
                int n3 = nArray2.length;
                int n4 = 0;
                while (n4 < n3) {
                    int i2 = nArray2[n4];
                    IObject o2 = snapshot2.getObject(i2);
                    if (i2 != previous.getObjectId() && i2 != current.getClazz().getObjectId()) {
                        if (o2.getClazz().equals(current.getClazz())) {
                            if (next != null) {
                                next = null;
                                break;
                            }
                            next = o2;
                        } else if (ref == null) {
                            ref = o2;
                        }
                    }
                    ++n4;
                }
            }
            if (ref != null) {
                result.add(ref.getObjectId());
            }
            if (header == null) {
                header = current;
            }
            previous = current;
            current = next;
            if (current == null && tail != null && tail.getObjectId() != header.getObjectId() && tail.getObjectId() != previous.getObjectId()) {
                current = tail;
                tail = null;
                header = previous;
            }
            listener.worked(1);
            if (listener.isCanceled()) break;
        }
        listener.done();
        return result.toArray();
    }

    @Override
    public boolean hasSize() {
        return true;
    }

    @Override
    public Integer getSize(IObject coll) throws SnapshotException {
        Integer s;
        if (super.hasSize() && (s = super.getSize(coll)) != null) {
            return s;
        }
        int[] entries = this.extractEntryIds(coll);
        if (entries == null) {
            return 0;
        }
        return entries.length;
    }
}

