/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.internal.db.ddl;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.net4j.db.DBException;
import org.eclipse.net4j.db.ddl.IDBField;
import org.eclipse.net4j.db.ddl.IDBIndex;
import org.eclipse.net4j.db.ddl.IDBIndexField;
import org.eclipse.net4j.db.ddl.IDBNamedElement;
import org.eclipse.net4j.db.ddl.IDBSchema;
import org.eclipse.net4j.db.ddl.IDBSchemaElement;
import org.eclipse.net4j.db.ddl.IDBSchemaVisitor;
import org.eclipse.net4j.db.ddl.IDBTable;
import org.eclipse.net4j.db.ddl.SchemaElementNotFoundException;
import org.eclipse.net4j.internal.db.ddl.DBIndexField;
import org.eclipse.net4j.internal.db.ddl.DBSchemaElement;
import org.eclipse.net4j.spi.db.ddl.InternalDBField;
import org.eclipse.net4j.spi.db.ddl.InternalDBIndex;
import org.eclipse.net4j.spi.db.ddl.InternalDBSchema;
import org.eclipse.net4j.spi.db.ddl.InternalDBTable;
import org.eclipse.net4j.util.om.OMPlatform;

public class DBIndex
extends DBSchemaElement
implements InternalDBIndex {
    public static final ThreadLocal<Boolean> FIX_NULLABLE_INDEX_COLUMNS = new InheritableThreadLocal<Boolean>();
    public static final ThreadLocal<Set<IDBField>> NULLABLE_INDEX_FIELDS = new InheritableThreadLocal<Set<IDBField>>();
    private static final boolean DISABLE_NULLABLE_CHECK = OMPlatform.INSTANCE.isProperty("org.eclipse.net4j.db.DisableNullableCheck", true);
    private static final long serialVersionUID = 1L;
    private IDBTable table;
    private IDBIndex.Type type;
    private List<IDBIndexField> indexFields = new ArrayList<IDBIndexField>();
    private boolean optional;

    public DBIndex(IDBTable table, String name, IDBIndex.Type type, IDBField[] fields) {
        super(name);
        this.table = table;
        this.type = type;
        int i = 0;
        while (i < fields.length) {
            IDBField field = fields[i];
            this.addIndexField(field);
            ++i;
        }
    }

    protected DBIndex() {
    }

    @Override
    public IDBIndex getWrapper() {
        return (IDBIndex)super.getWrapper();
    }

    @Override
    public IDBSchemaElement.SchemaElementType getSchemaElementType() {
        return IDBSchemaElement.SchemaElementType.INDEX;
    }

    @Override
    public IDBSchema getSchema() {
        return this.table.getSchema();
    }

    @Override
    public IDBTable getTable() {
        return this.table;
    }

    @Override
    public IDBTable getParent() {
        return this.getTable();
    }

    @Override
    public IDBIndex.Type getType() {
        return this.type;
    }

    @Override
    public void setType(IDBIndex.Type type) {
        this.assertUnlocked();
        this.type = type;
    }

    @Override
    public boolean isOptional() {
        return this.optional;
    }

    @Override
    public void setOptional(boolean optional) {
        this.optional = optional;
    }

    @Override
    @Deprecated
    public int getPosition() {
        IDBIndex[] indices = this.table.getIndices();
        return Arrays.asList(indices).indexOf(this);
    }

    @Override
    public IDBIndexField addIndexField(IDBField field) {
        this.assertUnlocked();
        if (this.type != IDBIndex.Type.NON_UNIQUE && !field.isNotNull()) {
            if (!DISABLE_NULLABLE_CHECK && FIX_NULLABLE_INDEX_COLUMNS.get() != Boolean.TRUE) {
                Exception constructionStackTrace = ((InternalDBField)field).getConstructionStackTrace();
                throw new DBException("Index field is nullable: " + field + " (to disable this check run with '-Dorg.eclipse.net4j.db.DisableNullableCheck=true')", constructionStackTrace);
            }
            Set<IDBField> nullableIndexFields = NULLABLE_INDEX_FIELDS.get();
            if (nullableIndexFields == null) {
                nullableIndexFields = new HashSet<IDBField>();
                NULLABLE_INDEX_FIELDS.set(nullableIndexFields);
            }
            nullableIndexFields.add(field);
        }
        if (field.getTable() != this.table) {
            throw new DBException("Index field is from different table: " + field);
        }
        String name = field.getName();
        if (this.getIndexField(name) != null) {
            throw new DBException("Index field exists: " + name);
        }
        int position = this.indexFields.size();
        DBIndexField indexField = new DBIndexField(this, field, position);
        this.indexFields.add(indexField);
        this.resetElements();
        return indexField;
    }

    @Override
    public IDBIndexField addIndexField(String name) throws SchemaElementNotFoundException {
        IDBField field = this.table.getFieldSafe(name);
        return this.addIndexField(field);
    }

    @Override
    public void removeIndexField(IDBIndexField indexFieldToRemove) {
        this.assertUnlocked();
        boolean found = false;
        Iterator<IDBIndexField> it = this.indexFields.iterator();
        while (it.hasNext()) {
            IDBIndexField indexField = it.next();
            if (found) {
                ((InternalDBField)((Object)indexField)).setPosition(indexField.getPosition() - 1);
                continue;
            }
            if (indexField != indexFieldToRemove) continue;
            it.remove();
            found = true;
        }
        this.resetElements();
    }

    @Override
    public IDBIndexField getIndexFieldSafe(String name) throws SchemaElementNotFoundException {
        IDBIndexField indexField = this.getIndexField(name);
        if (indexField == null) {
            throw new SchemaElementNotFoundException(this, IDBSchemaElement.SchemaElementType.INDEX_FIELD, name);
        }
        return indexField;
    }

    @Override
    public IDBIndexField getIndexField(String name) {
        InternalDBSchema schema = (InternalDBSchema)this.getSchema();
        IDBNamedElement[] indexFields = this.getIndexFields();
        return (IDBIndexField)DBIndex.findElement((InternalDBSchema)schema, (IDBNamedElement[])indexFields, (String)name);
    }

    @Override
    public IDBIndexField getIndexField(int position) {
        return this.indexFields.get(position);
    }

    @Override
    public IDBField getFieldSafe(String name) throws SchemaElementNotFoundException {
        IDBIndexField indexField = this.getIndexFieldSafe(name);
        return indexField.getField();
    }

    @Override
    public IDBField getField(String name) {
        InternalDBSchema schema = (InternalDBSchema)this.getSchema();
        for (IDBIndexField indexField : this.indexFields) {
            if (!schema.equalNames(indexField.getName(), name)) continue;
            return indexField.getField();
        }
        return null;
    }

    @Override
    public IDBField getField(int position) {
        return this.indexFields.get(position).getField();
    }

    @Override
    public int getFieldCount() {
        return this.indexFields.size();
    }

    @Override
    public IDBIndexField[] getIndexFields() {
        return this.indexFields.toArray(new IDBIndexField[this.indexFields.size()]);
    }

    @Override
    public IDBField[] getFields() {
        IDBField[] fields = new IDBField[this.indexFields.size()];
        int i = 0;
        while (i < fields.length) {
            fields[i] = this.getField(i);
            ++i;
        }
        return fields;
    }

    @Override
    public String getFullName() {
        return this.getName();
    }

    @Override
    public void remove() {
        ((InternalDBTable)this.table).removeIndex(this);
    }

    @Override
    protected void collectElements(List<IDBSchemaElement> elements) {
        elements.addAll(this.indexFields);
    }

    @Override
    protected void doAccept(IDBSchemaVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    protected void dumpAdditionalProperties(Writer writer) throws IOException {
        writer.append(", type=");
        writer.append(String.valueOf((Object)this.getType()));
    }

    private void assertUnlocked() {
        ((InternalDBSchema)this.table.getSchema()).assertUnlocked();
    }
}

