/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.sequence.business.internal.elements;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.sequence.business.api.util.Range;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.AbstractFrame;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.AbstractNodeEvent;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.AbstractSequenceElement;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.ISequenceElement;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.ISequenceElementAccessor;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.ISequenceEvent;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.InstanceRole;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.Lifeline;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.Message;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.NotationPredicate;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.Operand;
import org.eclipse.sirius.diagram.sequence.business.internal.ordering.EventEndHelper;
import org.eclipse.sirius.diagram.sequence.business.internal.query.ISequenceEventQuery;
import org.eclipse.sirius.diagram.sequence.business.internal.util.CacheHelper;
import org.eclipse.sirius.diagram.sequence.business.internal.util.SubEventsHelper;
import org.eclipse.sirius.diagram.sequence.description.DescriptionPackage;
import org.eclipse.sirius.diagram.sequence.ordering.CompoundEventEnd;
import org.eclipse.sirius.diagram.sequence.ordering.EventEnd;
import org.eclipse.sirius.diagram.sequence.ordering.SingleEventEnd;
import org.eclipse.sirius.diagram.sequence.tool.internal.Messages;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.ext.base.Options;

public class Execution
extends AbstractNodeEvent {
    public static final Predicate<ISequenceEvent> NO_REPARENTABLE_EVENTS = new Predicate<ISequenceEvent>(){

        public boolean apply(ISequenceEvent input) {
            return input instanceof AbstractFrame || input instanceof Operand || input instanceof Message;
        }
    };
    public static final int VISUAL_ID = 3001;

    Execution(Node node) {
        super(node);
        Preconditions.checkArgument((boolean)Execution.notationPredicate().apply((Object)node), (Object)Messages.Execution_nonExecutionNode);
    }

    public static Predicate<View> notationPredicate() {
        return new NotationPredicate(NotationPackage.eINSTANCE.getNode(), 3001, Execution.viewpointElementPredicate());
    }

    public static Predicate<DDiagramElement> viewpointElementPredicate() {
        return SiriusElementPredicate.INSTANCE;
    }

    @Override
    public boolean canChildOccupy(ISequenceEvent child, Range range) {
        return new SubEventsHelper(this).canChildOccupy(child, range);
    }

    @Override
    public boolean canChildOccupy(ISequenceEvent child, Range range, List<ISequenceEvent> eventsToIgnore, Collection<Lifeline> lifelines) {
        return new SubEventsHelper(this).canChildOccupy(child, range, eventsToIgnore, lifelines);
    }

    @Override
    public boolean isLogicallyInstantaneous() {
        return false;
    }

    @Override
    public ISequenceEvent getHierarchicalParentEvent() {
        return this.getHierarchicalParentEvent(Messages.Execution_invalidExecutionContext);
    }

    @Override
    public List<ISequenceEvent> getSubEvents() {
        return new SubEventsHelper(this).getSubEvents();
    }

    @Override
    public Collection<ISequenceEvent> getEventsToMoveWith() {
        LinkedHashSet<ISequenceEvent> toMove = new LinkedHashSet<ISequenceEvent>();
        List<ISequenceEvent> subEvents = this.getSubEvents();
        toMove.addAll(this.findLinkedExecutions(subEvents));
        toMove.addAll(this.getLinkedMessages());
        toMove.addAll(this.findCoveredExecutions(subEvents));
        toMove.addAll(subEvents);
        return toMove;
    }

    @Override
    public Range getOccupiedRange() {
        return new ISequenceEventQuery(this).getOccupiedRange();
    }

    @Override
    public Range getValidSubEventsRange() {
        Range range = this.getVerticalRange();
        if (range.width() > 10) {
            return range.shrinked(5);
        }
        return range;
    }

    @Override
    public List<Message> getLinkedMessages() {
        Option<Message> targetMessage;
        ArrayList<Message> linkedMessages = new ArrayList<Message>();
        Option<Message> startMessage = this.getStartMessage();
        if (startMessage.some()) {
            linkedMessages.add((Message)startMessage.get());
        }
        if ((targetMessage = this.getEndMessage()).some()) {
            linkedMessages.add((Message)targetMessage.get());
        }
        return linkedMessages;
    }

    public Option<Message> getStartMessage() {
        return this.getCompoundMessage(true);
    }

    public Option<Message> getEndMessage() {
        return this.getCompoundMessage(false);
    }

    private Option<Message> getCompoundMessage(boolean start) {
        Message result = null;
        Option resultOption = Options.newNone();
        if (CacheHelper.isStructuralCacheEnabled() && (result = start ? CacheHelper.getStartCompoundMessageCache().get(this) : CacheHelper.getEndCompoundMessageCache().get(this)) != null) {
            resultOption = Options.newSome((Object)result);
        }
        if (!resultOption.some()) {
            Node node = this.getNotationNode();
            HashSet edges = new HashSet();
            Iterables.addAll(edges, (Iterable)Iterables.filter((Iterable)node.getSourceEdges(), Edge.class));
            Iterables.addAll(edges, (Iterable)Iterables.filter((Iterable)node.getTargetEdges(), Edge.class));
            List<EventEnd> ends = EventEndHelper.findEndsFromSemanticOrdering(this);
            for (Edge edge : edges) {
                SingleEventEnd see;
                Option<Message> message = ISequenceElementAccessor.getMessage((View)edge);
                if (!message.some()) continue;
                List<EventEnd> messageEnds = EventEndHelper.findEndsFromSemanticOrdering((ISequenceElement)message.get());
                Iterables.retainAll(messageEnds, ends);
                if (messageEnds.isEmpty() || start != (see = EventEndHelper.getSingleEventEnd(messageEnds.get(0), (EObject)this.getSemanticTargetElement().get())).isStart()) continue;
                this.putMessageInCache(start, (Message)message.get());
                return message;
            }
        }
        return resultOption;
    }

    private void putMessageInCache(boolean start, Message message) {
        if (CacheHelper.isStructuralCacheEnabled()) {
            if (start) {
                CacheHelper.getStartCompoundMessageCache().put(this, message);
            } else {
                CacheHelper.getEndCompoundMessageCache().put(this, message);
            }
        }
    }

    public boolean startsWithReflectiveMessage() {
        Option<Message> startMessage = this.getStartMessage();
        if (startMessage.some()) {
            return ((Message)startMessage.get()).isReflective();
        }
        return false;
    }

    public boolean endsWithReflectiveMessage() {
        Option<Message> finishMessage = this.getEndMessage();
        if (finishMessage.some()) {
            return ((Message)finishMessage.get()).isReflective();
        }
        return false;
    }

    public boolean isReflective() {
        Option<Message> startMessage = this.getStartMessage();
        Option<Message> endMessage = this.getEndMessage();
        return startMessage.some() && ((Message)startMessage.get()).isReflective() && (!endMessage.some() || ((Message)endMessage.get()).isReflective());
    }

    private Collection<? extends ISequenceEvent> findLinkedExecutions(List<ISequenceEvent> subEvents) {
        LinkedHashSet<Execution> linkedExecutions = new LinkedHashSet<Execution>();
        for (Message message : Iterables.filter(subEvents, Message.class)) {
            if (!this.equals(message.getSourceElement()) || !(message.getTargetElement() instanceof Execution)) continue;
            Execution targetExecution = (Execution)message.getTargetElement();
            for (CompoundEventEnd messageCompoundEventEnd : Iterables.filter(EventEndHelper.findEndsFromSemanticOrdering(message), CompoundEventEnd.class)) {
                for (CompoundEventEnd executionCompoundEventEnd : Iterables.filter(EventEndHelper.findEndsFromSemanticOrdering(targetExecution), CompoundEventEnd.class)) {
                    if (!messageCompoundEventEnd.equals(executionCompoundEventEnd) || this.equals(targetExecution)) continue;
                    linkedExecutions.add(targetExecution);
                }
            }
        }
        return linkedExecutions;
    }

    private Collection<? extends ISequenceEvent> findCoveredExecutions(List<ISequenceEvent> subEvents) {
        ArrayList coveredExecutions = new ArrayList();
        for (AbstractFrame frame : Iterables.filter(subEvents, AbstractFrame.class)) {
            Collection<ISequenceEvent> parentEvents = frame.computeParentEvents();
            parentEvents.remove(this);
            Iterables.addAll(coveredExecutions, (Iterable)Iterables.filter(parentEvents, Execution.class));
        }
        return coveredExecutions;
    }

    public List<Execution> findLinkedExecutions(boolean recurse) {
        ArrayList<Execution> impactedExecutions = new ArrayList<Execution>();
        this.findLinkedExecutions(impactedExecutions, this, recurse);
        return impactedExecutions;
    }

    private void findLinkedExecutions(List<Execution> impactedExecutions, Execution execution, boolean recurse) {
        List<Message> messagesFrom = new ISequenceEventQuery(execution).getAllMessagesFrom();
        for (Message message : messagesFrom) {
            boolean targetsUnseenExecution;
            boolean bl = targetsUnseenExecution = message.getTargetElement() instanceof Execution && !impactedExecutions.contains(message.getTargetElement());
            if (!targetsUnseenExecution) continue;
            Execution targetExecution = (Execution)message.getTargetElement();
            for (CompoundEventEnd messageCompoundEventEnd : Iterables.filter(EventEndHelper.findEndsFromSemanticOrdering(message), CompoundEventEnd.class)) {
                for (CompoundEventEnd executionCompoundEventEnd : Iterables.filter(EventEndHelper.findEndsFromSemanticOrdering(targetExecution), CompoundEventEnd.class)) {
                    if (!messageCompoundEventEnd.equals(executionCompoundEventEnd) || impactedExecutions.contains(targetExecution)) continue;
                    impactedExecutions.add(targetExecution);
                    if (!recurse) continue;
                    this.findLinkedExecutions(impactedExecutions, targetExecution, recurse);
                }
            }
        }
    }

    public Range getExtendedVerticalRange() {
        Range result = this.getVerticalRange();
        for (Message linkedMessage : this.getLinkedMessages()) {
            result = result.union(linkedMessage.getVerticalRange());
        }
        return result;
    }

    private static enum SiriusElementPredicate implements Predicate<DDiagramElement>
    {
        INSTANCE;


        public boolean apply(DDiagramElement input) {
            return AbstractSequenceElement.isSequenceDiagramElement(input, DescriptionPackage.eINSTANCE.getExecutionMapping()) && !InstanceRole.viewpointElementPredicate().apply((Object)((DDiagramElement)input.eContainer()));
        }
    }
}

