/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.tcl.internal.validators.checks;

import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.builder.ISourceLineTracker;
import org.eclipse.dltk.core.mixin.IMixinElement;
import org.eclipse.dltk.core.mixin.IMixinRequestor;
import org.eclipse.dltk.tcl.ast.TclCommand;
import org.eclipse.dltk.tcl.ast.VariableReference;
import org.eclipse.dltk.tcl.internal.core.search.mixin.TclMixinModel;
import org.eclipse.dltk.tcl.internal.core.search.mixin.model.TclField;
import org.eclipse.dltk.tcl.parser.ITclErrorReporter;
import org.eclipse.dltk.tcl.parser.TclParserUtils;
import org.eclipse.dltk.tcl.parser.TclVisitor;
import org.eclipse.dltk.tcl.validators.ITclCheck;

public class UndefinedVariableCheck
implements ITclCheck {
    @Override
    public void checkCommands(List<TclCommand> commands, final ITclErrorReporter reporter, Map<String, String> options, final IScriptProject project, ISourceLineTracker sourceLineTracker) {
        TclParserUtils.traverse(commands, (TclVisitor)new TclVisitor(){

            public boolean visit(VariableReference ref) {
                String name = ref.getName();
                IMixinElement[] elements = TclMixinModel.getInstance().getMixin(project).find(name.replaceAll("::", IMixinRequestor.MIXIN_NAME_SEPARATOR), (IProgressMonitor)new NullProgressMonitor());
                String realName = name;
                if (realName.indexOf("::") != -1) {
                    realName = realName.substring(realName.lastIndexOf("::") + 2);
                }
                boolean found = false;
                int i = 0;
                while (i < elements.length) {
                    Object[] objects = elements[i].getAllObjects();
                    int j = 0;
                    while (j < objects.length) {
                        if (objects[j] instanceof TclField) {
                            found = true;
                            break;
                        }
                        ++j;
                    }
                    ++i;
                }
                if (!found) {
                    reporter.report(10001, "Use of undefined variable:" + realName, null, ref.getStart(), ref.getEnd(), ITclErrorReporter.WARNING);
                }
                return true;
            }
        });
    }
}

